/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.entity.DragonEggHiveBlockEntity;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DragonEggHive
extends AdvancedBeehive {
    protected static final VoxelShape SHAPE = DragonEggHive.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public DragonEggHive(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DragonEggHiveBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : DragonEggHive.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.DRACONIC_BEEHIVE.get()), DragonEggHiveBlockEntity::tick);
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL) >= this.getMaxHoneyLevel()) {
            for (int i = 0; i < 22; ++i) {
                double rnd = world.random.nextDouble();
                float xSpeed = (world.random.nextFloat() - 0.5f) * 0.2f;
                float ySpeed = (world.random.nextFloat() - 0.5f) * 0.2f;
                float zSpeed = (world.random.nextFloat() - 0.5f) * 0.2f;
                double x = Mth.lerp((double)rnd, (double)pos.getX(), (double)pos.getX()) + (world.random.nextDouble() - 0.5) + 0.5;
                double y = Mth.lerp((double)rnd, (double)pos.getY(), (double)pos.getY()) + world.random.nextDouble() - 0.5;
                double z = Mth.lerp((double)rnd, (double)pos.getZ(), (double)pos.getZ()) + (world.random.nextDouble() - 0.5) + 0.5;
                world.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
            }
        }
    }
}

