/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity.model;

import cy.jdkdigital.productivebees.client.render.entity.model.MediumBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.hive.HoarderBee;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class HoarderBeeModel<T extends ProductiveBee>
extends ProductiveBeeModel<T> {
    public HoarderBeeModel(ModelPart modelPart) {
        super(modelPart);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = MediumBeeModel.createMeshDefinition(false);
        PartDefinition root = meshDefinition.getRoot();
        PartDefinition bone = root.getChild("bone");
        PartDefinition body = bone.addOrReplaceChild("body", CubeListBuilder.create().texOffs(3, 3).addBox(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 7.0f), PartPose.ZERO);
        body.addOrReplaceChild("externals", CubeListBuilder.create().texOffs(38, 7).addBox(-3.5f, -4.0f, 1.0f, 7.0f, 7.0f, 4.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        assert (entity instanceof HoarderBee);
        HoarderBee beeEntity = (HoarderBee)entity;
        float time = ageInTicks - (float)beeEntity.tickCount;
        float peekAmount = (0.5f + beeEntity.getClientPeekAmount(time)) * (float)Math.PI;
        float rotation = -1.0f + Mth.sin((float)peekAmount);
        this.externals.setPos(0.0f, 0.0f, 3.0f + Mth.sin((float)peekAmount) * 3.0f);
        this.stinger.setPos(0.0f, 0.0f, 3.0f + Mth.sin((float)peekAmount) * 3.0f);
        this.externals.zRot = beeEntity.getClientPeekAmount(time) > 0.3f ? rotation * rotation * rotation * rotation * (float)Math.PI * 0.125f : 0.0f;
        this.stinger.zRot = this.externals.zRot;
    }
}

