/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CentrifugeBlockEntityRenderer
implements BlockEntityRenderer<CentrifugeBlockEntity> {
    public CentrifugeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CentrifugeBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack;
        IItemHandler invHandler;
        if (((Boolean)ProductiveBeesConfig.CLIENT.renderCombsInCentrifuge.get()).booleanValue() && (invHandler = (IItemHandler)tileEntityIn.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tileEntityIn.getBlockPos(), null)) instanceof ItemStackHandler && !(stack = invHandler.getStackInSlot(1)).isEmpty()) {
            ItemRenderer ir = Minecraft.getInstance().getItemRenderer();
            long time = System.currentTimeMillis();
            double d = (double)time / 50.0 % 360.0;
            int stackCount = stack.getCount();
            double shownItemCount = stackCount < 20 ? (double)stackCount : 20.0 + Math.ceil((float)(stackCount - 20) / 4.0f);
            int i = 0;
            while ((double)i < shownItemCount) {
                double angle = -d + 360.0 / shownItemCount * (double)i;
                double dX = Math.sin(Math.toRadians(angle)) * 0.25;
                double dZ = Math.cos(Math.toRadians(angle)) * 0.25;
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5 + dX, 0.6375, 0.5 + dZ);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)angle + 90.0f));
                matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                ir.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, tileEntityIn.getLevel(), 0);
                matrixStackIn.popPose();
                ++i;
            }
        }
    }
}

