/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.init;

import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.blocks.Mortar;
import com.thevortex.potionsmaster.init.ModFoods;
import com.thevortex.potionsmaster.items.Bezoar;
import com.thevortex.potionsmaster.items.GallBladder;
import com.thevortex.potionsmaster.items.Pestle;
import com.thevortex.potionsmaster.items.potions.effect.oresight.OreSightEffect;
import com.thevortex.potionsmaster.items.powders.base.BasePowder;
import com.thevortex.potionsmaster.items.powders.base.CalcinatedPowder;
import com.thevortex.potionsmaster.items.powders.calcinated.ActivatedCharcoal;
import com.thevortex.potionsmaster.reference.Reference;
import com.thevortex.potionsmaster.render.util.BlockData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"potionsmaster");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"potionsmaster");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((ResourceKey)Registries.POTION, (String)"potionsmaster");
    public static final DeferredRegister<MobEffect> MOBEFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"potionsmaster");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"potionsmaster");
    public static final DeferredBlock<Mortar> MORTAR = BLOCKS.register("tile_mortar", () -> new Mortar());
    public static final DeferredItem<Item> ENDER_POWDER = ITEMS.register("ender_powder", () -> new Item(new Item.Properties()));
    public static HashMap<String, DeferredHolder<MobEffect, MobEffect>> EffectsListParsed = new HashMap();
    public static HashMap<String, DeferredHolder<Potion, Potion>> PotionsListParsed = new HashMap();
    public static final List<DeferredHolder<MobEffect, MobEffect>> EffectList = ModRegistry.registerEffects();
    public static final List<DeferredHolder<Potion, Potion>> PotionList = ModRegistry.registerPotions();
    public static final DeferredItem<Bezoar> BEZOAR = ITEMS.register("bezoar", () -> new Bezoar(new Item.Properties().food(ModFoods.BEZOAR)));
    public static final DeferredItem<GallBladder> GALLBLADDER = ITEMS.register("gallbladder", () -> new GallBladder(new Item.Properties().food(ModFoods.GALLBLADDER)));
    public static final DeferredItem<ActivatedCharcoal> ACTIVATEDCHARCOAL = ITEMS.register("activated_charcoal", () -> new ActivatedCharcoal(new Item.Properties().food(ModFoods.ACTIVATEDCHARCOAL)));
    public static final DeferredItem<Pestle> PESTLE = ITEMS.register("pestle", () -> new Pestle(new Item.Properties()));
    public static final DeferredItem<com.thevortex.potionsmaster.items.Mortar> ITEM_MORTAR = ITEMS.register("tile_mortar", () -> new com.thevortex.potionsmaster.items.Mortar((Block)MORTAR.get(), new Item.Properties()));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("creative_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)Reference.tab())).icon(() -> ((Item)Items.BREWING_STAND).getDefaultInstance()).displayItems((parameters, output) -> ITEMS.getEntries().stream().map(DeferredHolder::get).map(Item::getDefaultInstance).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());

    public static DeferredHolder<Item, Item> createBasePowder(String name, Supplier<BasePowder> itemSupplier) {
        return ITEMS.register(name, itemSupplier);
    }

    public static DeferredHolder<Item, Item> createCalcinatedPowder(String name, Supplier<CalcinatedPowder> itemSupplier) {
        return ITEMS.register(name, itemSupplier);
    }

    public static DeferredHolder<MobEffect, MobEffect> createMobEffect(String name, Supplier<OreSightEffect> effectSupplier) {
        return MOBEFFECTS.register(name, effectSupplier);
    }

    public static DeferredHolder<Potion, Potion> createPotion(String name, Supplier<Potion> potionSupplier) {
        return POTIONS.register(name, potionSupplier);
    }

    public static List<DeferredHolder<Item, Item>> registerBaseItems() {
        ArrayList<DeferredHolder<Item, Item>> list = new ArrayList<DeferredHolder<Item, Item>>();
        for (BlockData blockData : PotionsMaster.blockStore.getStore().values()) {
            list.add(ModRegistry.createBasePowder(blockData.getEntryName() + "_oresight_powder", () -> new BasePowder(blockData.getColor(), new Item.Properties())));
        }
        return list;
    }

    public static List<DeferredHolder<Item, Item>> registerCalcinatedItems() {
        ArrayList<DeferredHolder<Item, Item>> list = new ArrayList<DeferredHolder<Item, Item>>();
        for (BlockData blockData : PotionsMaster.blockStore.getStore().values()) {
            list.add(ModRegistry.createCalcinatedPowder("calcinated_" + blockData.getEntryName() + "_oresight_powder", () -> new CalcinatedPowder(blockData.getColor(), new Item.Properties())));
        }
        return list;
    }

    public static List<DeferredHolder<MobEffect, MobEffect>> registerEffects() {
        ArrayList<DeferredHolder<MobEffect, MobEffect>> list = new ArrayList<DeferredHolder<MobEffect, MobEffect>>();
        for (BlockData blockData : PotionsMaster.blockStore.getStore().values()) {
            DeferredHolder<MobEffect, MobEffect> effect = ModRegistry.createMobEffect(blockData.getEntryName() + "_sight", () -> new OreSightEffect(MobEffectCategory.BENEFICIAL, blockData.getoreTag(), blockData.getColor()));
            list.add(effect);
            EffectsListParsed.put(blockData.getEntryName(), effect);
        }
        return list;
    }

    public static List<DeferredHolder<Potion, Potion>> registerPotions() {
        ArrayList<DeferredHolder<Potion, Potion>> list = new ArrayList<DeferredHolder<Potion, Potion>>();
        for (String potionName : EffectsListParsed.keySet()) {
            DeferredHolder<Potion, Potion> potion = ModRegistry.createPotion(potionName, () -> new Potion(potionName + "_sight_potion", new MobEffectInstance[]{new MobEffectInstance(EffectsListParsed.get(potionName).getDelegate(), 2500, 0, false, true, false)}));
            list.add(potion);
            PotionsListParsed.put(potionName, potion);
        }
        return list;
    }
}

