/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.creeperhost.polylib.io.sentry.Attachment;
import net.creeperhost.polylib.io.sentry.Breadcrumb;
import net.creeperhost.polylib.io.sentry.CircularFifoQueue;
import net.creeperhost.polylib.io.sentry.EventProcessor;
import net.creeperhost.polylib.io.sentry.IScopeObserver;
import net.creeperhost.polylib.io.sentry.ISpan;
import net.creeperhost.polylib.io.sentry.ITransaction;
import net.creeperhost.polylib.io.sentry.SentryLevel;
import net.creeperhost.polylib.io.sentry.SentryOptions;
import net.creeperhost.polylib.io.sentry.Session;
import net.creeperhost.polylib.io.sentry.Span;
import net.creeperhost.polylib.io.sentry.SynchronizedQueue;
import net.creeperhost.polylib.io.sentry.protocol.Contexts;
import net.creeperhost.polylib.io.sentry.protocol.Request;
import net.creeperhost.polylib.io.sentry.protocol.User;
import net.creeperhost.polylib.io.sentry.util.CollectionUtils;
import net.creeperhost.polylib.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scope {
    @Nullable
    private SentryLevel level;
    @Nullable
    private ITransaction transaction;
    @Nullable
    private String transactionName;
    @Nullable
    private User user;
    @Nullable
    private Request request;
    @NotNull
    private List<String> fingerprint = new ArrayList<String>();
    @NotNull
    private Queue<Breadcrumb> breadcrumbs;
    @NotNull
    private @NotNull Map<String, @NotNull String> tags = new ConcurrentHashMap<String, String>();
    @NotNull
    private @NotNull Map<String, @NotNull Object> extra = new ConcurrentHashMap<String, Object>();
    @NotNull
    private List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    @NotNull
    private final SentryOptions options;
    @Nullable
    private volatile Session session;
    @NotNull
    private final Object sessionLock = new Object();
    @NotNull
    private final Object transactionLock = new Object();
    @NotNull
    private Contexts contexts = new Contexts();
    @NotNull
    private List<Attachment> attachments = new CopyOnWriteArrayList<Attachment>();

    public Scope(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "SentryOptions is required.");
        this.breadcrumbs = this.createBreadcrumbsList(this.options.getMaxBreadcrumbs());
    }

    Scope(@NotNull Scope scope) {
        this.transaction = scope.transaction;
        this.transactionName = scope.transactionName;
        this.session = scope.session;
        this.options = scope.options;
        this.level = scope.level;
        User userRef = scope.user;
        this.user = userRef != null ? new User(userRef) : null;
        Request requestRef = scope.request;
        this.request = requestRef != null ? new Request(requestRef) : null;
        this.fingerprint = new ArrayList<String>(scope.fingerprint);
        this.eventProcessors = new CopyOnWriteArrayList<EventProcessor>(scope.eventProcessors);
        Queue<Breadcrumb> breadcrumbsRef = scope.breadcrumbs;
        Queue<Breadcrumb> breadcrumbsClone = this.createBreadcrumbsList(scope.options.getMaxBreadcrumbs());
        for (Breadcrumb item : breadcrumbsRef) {
            Breadcrumb breadcrumbClone = new Breadcrumb(item);
            breadcrumbsClone.add(breadcrumbClone);
        }
        this.breadcrumbs = breadcrumbsClone;
        Map<String, String> tagsRef = scope.tags;
        ConcurrentHashMap<String, @NotNull String> tagsClone = new ConcurrentHashMap<String, String>();
        for (Map.Entry entry : tagsRef.entrySet()) {
            if (entry == null) continue;
            tagsClone.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.tags = tagsClone;
        Map<String, Object> extraRef = scope.extra;
        ConcurrentHashMap<String, @NotNull Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> item : extraRef.entrySet()) {
            if (item == null) continue;
            concurrentHashMap.put(item.getKey(), item.getValue());
        }
        this.extra = concurrentHashMap;
        this.contexts = new Contexts(scope.contexts);
        this.attachments = new CopyOnWriteArrayList<Attachment>(scope.attachments);
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Nullable
    public String getTransactionName() {
        ITransaction tx = this.transaction;
        return tx != null ? tx.getName() : this.transactionName;
    }

    public void setTransaction(@NotNull String transaction) {
        if (transaction != null) {
            ITransaction tx = this.transaction;
            if (tx != null) {
                tx.setName(transaction);
            }
            this.transactionName = transaction;
        } else {
            this.options.getLogger().log(SentryLevel.WARNING, "Transaction cannot be null", new Object[0]);
        }
    }

    @Nullable
    public ISpan getSpan() {
        Span span;
        ITransaction tx = this.transaction;
        if (tx != null && (span = tx.getLatestActiveSpan()) != null) {
            return span;
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransaction(@Nullable ITransaction transaction) {
        Object object = this.transactionLock;
        synchronized (object) {
            this.transaction = transaction;
        }
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    public void setUser(@Nullable User user) {
        this.user = user;
        if (this.options.isEnableScopeSync()) {
            for (IScopeObserver observer : this.options.getScopeObservers()) {
                observer.setUser(user);
            }
        }
    }

    @Nullable
    public Request getRequest() {
        return this.request;
    }

    public void setRequest(@Nullable Request request) {
        this.request = request;
    }

    @NotNull
    List<String> getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(@NotNull List<String> fingerprint) {
        if (fingerprint == null) {
            return;
        }
        this.fingerprint = new ArrayList<String>(fingerprint);
    }

    @NotNull
    Queue<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    @Nullable
    private Breadcrumb executeBeforeBreadcrumb(@NotNull SentryOptions.BeforeBreadcrumbCallback callback, @NotNull Breadcrumb breadcrumb, @Nullable Object hint) {
        block2: {
            try {
                breadcrumb = callback.execute(breadcrumb, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeBreadcrumbCallback callback threw an exception. Exception details will be added to the breadcrumb.", e);
                if (e.getMessage() == null) break block2;
                breadcrumb.setData("sentry:message", e.getMessage());
            }
        }
        return breadcrumb;
    }

    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Object hint) {
        if (breadcrumb == null) {
            return;
        }
        SentryOptions.BeforeBreadcrumbCallback callback = this.options.getBeforeBreadcrumb();
        if (callback != null) {
            breadcrumb = this.executeBeforeBreadcrumb(callback, breadcrumb, hint);
        }
        if (breadcrumb != null) {
            this.breadcrumbs.add(breadcrumb);
            if (this.options.isEnableScopeSync()) {
                for (IScopeObserver observer : this.options.getScopeObservers()) {
                    observer.addBreadcrumb(breadcrumb);
                }
            }
        } else {
            this.options.getLogger().log(SentryLevel.INFO, "Breadcrumb was dropped by beforeBreadcrumb", new Object[0]);
        }
    }

    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        this.addBreadcrumb(breadcrumb, null);
    }

    public void clearBreadcrumbs() {
        this.breadcrumbs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTransaction() {
        Object object = this.transactionLock;
        synchronized (object) {
            this.transaction = null;
        }
        this.transactionName = null;
    }

    @Nullable
    public ITransaction getTransaction() {
        return this.transaction;
    }

    public void clear() {
        this.level = null;
        this.user = null;
        this.request = null;
        this.fingerprint.clear();
        this.clearBreadcrumbs();
        this.tags.clear();
        this.extra.clear();
        this.eventProcessors.clear();
        this.clearTransaction();
        this.clearAttachments();
    }

    @ApiStatus.Internal
    @NotNull
    public Map<String, String> getTags() {
        return CollectionUtils.newConcurrentHashMap(this.tags);
    }

    public void setTag(@NotNull String key, @NotNull String value) {
        this.tags.put(key, value);
        if (this.options.isEnableScopeSync()) {
            for (IScopeObserver observer : this.options.getScopeObservers()) {
                observer.setTag(key, value);
            }
        }
    }

    public void removeTag(@NotNull String key) {
        this.tags.remove(key);
        if (this.options.isEnableScopeSync()) {
            for (IScopeObserver observer : this.options.getScopeObservers()) {
                observer.removeTag(key);
            }
        }
    }

    @NotNull
    Map<String, Object> getExtras() {
        return this.extra;
    }

    public void setExtra(@NotNull String key, @NotNull String value) {
        this.extra.put(key, value);
        if (this.options.isEnableScopeSync()) {
            for (IScopeObserver observer : this.options.getScopeObservers()) {
                observer.setExtra(key, value);
            }
        }
    }

    public void removeExtra(@NotNull String key) {
        this.extra.remove(key);
        if (this.options.isEnableScopeSync()) {
            for (IScopeObserver observer : this.options.getScopeObservers()) {
                observer.removeExtra(key);
            }
        }
    }

    @NotNull
    public Contexts getContexts() {
        return this.contexts;
    }

    public void setContexts(@NotNull String key, @NotNull Object value) {
        this.contexts.put(key, value);
    }

    public void setContexts(@NotNull String key, @NotNull Boolean value) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("value", value);
        this.setContexts(key, map);
    }

    public void setContexts(@NotNull String key, @NotNull String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", value);
        this.setContexts(key, map);
    }

    public void setContexts(@NotNull String key, @NotNull Number value) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("value", value);
        this.setContexts(key, map);
    }

    public void setContexts(@NotNull String key, @NotNull Collection<?> value) {
        HashMap map = new HashMap();
        map.put("value", value);
        this.setContexts(key, map);
    }

    public void setContexts(@NotNull String key, @NotNull Object[] value) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("value", value);
        this.setContexts(key, map);
    }

    public void setContexts(@NotNull String key, @NotNull Character value) {
        HashMap<String, Character> map = new HashMap<String, Character>();
        map.put("value", value);
        this.setContexts(key, map);
    }

    public void removeContexts(@NotNull String key) {
        this.contexts.remove(key);
    }

    @NotNull
    List<Attachment> getAttachments() {
        return new CopyOnWriteArrayList<Attachment>(this.attachments);
    }

    public void addAttachment(@NotNull Attachment attachment) {
        this.attachments.add(attachment);
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    @NotNull
    private Queue<Breadcrumb> createBreadcrumbsList(int maxBreadcrumb) {
        return SynchronizedQueue.synchronizedQueue(new CircularFifoQueue(maxBreadcrumb));
    }

    @NotNull
    List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public void addEventProcessor(@NotNull EventProcessor eventProcessor) {
        this.eventProcessors.add(eventProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Session withSession(@NotNull IWithSession sessionCallback) {
        Session cloneSession = null;
        Object object = this.sessionLock;
        synchronized (object) {
            sessionCallback.accept(this.session);
            if (this.session != null) {
                cloneSession = this.session.clone();
            }
        }
        return cloneSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    SessionPair startSession() {
        SessionPair pair = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.session != null) {
                this.session.end();
            }
            Session previousSession = this.session;
            if (this.options.getRelease() != null) {
                this.session = new Session(this.options.getDistinctId(), this.user, this.options.getEnvironment(), this.options.getRelease());
                Session previousClone = previousSession != null ? previousSession.clone() : null;
                pair = new SessionPair(this.session.clone(), previousClone);
            } else {
                this.options.getLogger().log(SentryLevel.WARNING, "Release is not set on SentryOptions. Session could not be started", new Object[0]);
            }
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Session endSession() {
        Session previousSession = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.session != null) {
                this.session.end();
                previousSession = this.session.clone();
                this.session = null;
            }
        }
        return previousSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void withTransaction(@NotNull IWithTransaction callback) {
        Object object = this.transactionLock;
        synchronized (object) {
            callback.accept(this.transaction);
        }
    }

    @ApiStatus.Internal
    public static interface IWithTransaction {
        public void accept(@Nullable ITransaction var1);
    }

    static final class SessionPair {
        @Nullable
        private final Session previous;
        @NotNull
        private final Session current;

        public SessionPair(@NotNull Session current, @Nullable Session previous) {
            this.current = current;
            this.previous = previous;
        }

        @Nullable
        public Session getPrevious() {
            return this.previous;
        }

        @NotNull
        public Session getCurrent() {
            return this.current;
        }
    }

    static interface IWithSession {
        public void accept(@Nullable Session var1);
    }
}

