/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screen.widget.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.creeperhost.polylib.client.screen.ScreenHelper;
import net.creeperhost.polylib.client.screen.widget.buttons.PolyButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class GuiButtonLarge
extends PolyButton {
    private final Component description;
    private final ItemStack stack;

    public GuiButtonLarge(int x, int y, int width, int height, String buttonText, Component description, ItemStack stack, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.translatable((String)buttonText), onPress, DEFAULT_NARRATION);
        this.visible = true;
        this.active = true;
        this.setMessage((Component)Component.translatable((String)buttonText));
        this.description = description;
        this.stack = stack;
    }

    public GuiButtonLarge(int x, int y, int width, int height, String buttonText, String description, ItemStack stack, Button.OnPress onPress) {
        this(x, y, width, height, buttonText, (Component)Component.literal((String)description), stack, onPress);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        Minecraft mc = Minecraft.getInstance();
        int k = this.getYImage(this.isHovered);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        ScreenHelper.drawContinuousTexturedBox(graphics.pose(), this.getX(), this.getY(), 0, 46 + k * 20, this.width, this.height, 200, 20, 2, 3, 2, 2, 0.0f);
        int color = 0xE0E0E0;
        List newstring = ComponentRenderUtils.wrapComponents((FormattedText)this.description, (int)(this.width - 12), (Font)mc.font);
        int start = this.getY() + 40;
        for (FormattedCharSequence s : newstring) {
            int left = this.getX() + 4;
            graphics.drawString(mc.font, s, left, start += 10, -1, true);
        }
        graphics.drawCenteredString(mc.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + 10, color);
        graphics.renderFakeItem(this.stack, this.getX() + this.width / 2 - 8, this.getY() + 24);
    }

    protected int getYImage(boolean bl) {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (bl) {
            i = 2;
        }
        return i;
    }
}

