/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class LoadingSpinner {
    public static void render(PoseStack poseStack, float partialTicks, int ticks, int x, int y, ItemStack stack) {
        int rotateTickMax = 60;
        int throbTickMax = 20;
        int rotateTicks = ticks % rotateTickMax;
        int throbTicks = ticks % throbTickMax;
        float rotationDegrees = ((float)rotateTicks + partialTicks) * (360.0f / (float)rotateTickMax);
        float scale = 1.0f + (throbTicks >= throbTickMax / 2 ? (float)throbTickMax - ((float)throbTicks + partialTicks) : (float)throbTicks + partialTicks) * (2.0f / (float)throbTickMax);
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.mulPose(new Quaternionf().rotateLocalZ(rotationDegrees));
        LoadingSpinner.drawItem(poseStack, stack, 0, true, null);
        poseStack.popPose();
    }

    public static void drawItem(PoseStack poseStack, ItemStack stack, int hash, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        BakedModel bakedModel = itemRenderer.getModel(stack, null, (LivingEntity)mc.player, hash);
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.mul((Matrix4fc)poseStack.last().pose());
        modelViewStack.scale(1.0f, -1.0f, 1.0f);
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flatLight = !bakedModel.usesBlockLight();
        if (flatLight) {
            Lighting.setupForFlatItems();
        }
        itemRenderer.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.setupFor3DItems();
        }
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        if (renderOverlay) {
            float cooldown;
            Tesselator t = Tesselator.getInstance();
            Font font = mc.font;
            if (stack.getCount() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.getCount()) : text;
                poseStack.pushPose();
                poseStack.translate(9.0 - (double)font.width(s), 1.0, 20.0);
                font.drawInBatch(s, 0.0f, 0.0f, 0xFFFFFF, true, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                bufferSource.endBatch();
                poseStack.popPose();
            }
            if (stack.isBarVisible()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                int barWidth = stack.getBarWidth();
                int barColor = stack.getBarColor();
                LoadingSpinner.draw(poseStack, t, -6, 5, 13, 2, 0, 0, 0, 255);
                LoadingSpinner.draw(poseStack, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
            float f = cooldown = mc.player == null ? 0.0f : mc.player.getCooldowns().getCooldownPercent(stack.getItem(), (float)mc.getFrameTimeNs());
            if (cooldown > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                LoadingSpinner.draw(poseStack, t, -8, Mth.floor((float)(16.0f * (1.0f - cooldown))) - 8, 16, Mth.ceil((float)(16.0f * cooldown)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(PoseStack matrixStack, Tesselator t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width <= 0 || height <= 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f m = matrixStack.last().pose();
        BufferBuilder bufferbuilder = t.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex(m, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(m, (float)x, (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(m, (float)(x + width), (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(m, (float)(x + width), (float)y, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }
}

