/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.render.rendertypes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.SequencedMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;

public class GhostRenderType
extends RenderType {
    private static final Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

    private GhostRenderType(RenderType original) {
        super(String.format("%s_%s_ghost", original.toString(), "polylib"), original.format(), original.mode(), original.bufferSize(), original.affectsCrumbling(), true, () -> {
            original.setupRenderState();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        }, () -> {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            original.clearRenderState();
        });
    }

    public static RenderType remap(RenderType in) {
        if (in instanceof GhostRenderType) {
            return in;
        }
        return remappedTypes.computeIfAbsent(in, GhostRenderType::new);
    }

    public static class GhostBuffers
    extends MultiBufferSource.BufferSource {
        public GhostBuffers(ByteBufferBuilder fallback, SequencedMap<RenderType, ByteBufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        @NotNull
        public VertexConsumer getBuffer(@NotNull RenderType type) {
            return super.getBuffer(GhostRenderType.remap(type));
        }
    }
}

