/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.function.Consumer;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TextInputDialog
extends GuiElement<TextInputDialog> {
    public GuiTextField textField;
    @Nullable
    public Consumer<String> resultCallback;

    public TextInputDialog(ModularGui gui) {
        super(gui.getRoot());
        this.setOpaque(true);
    }

    public TextInputDialog setResultCallback(Consumer<String> resultCallback) {
        this.resultCallback = resultCallback;
        return this;
    }

    public void accept() {
        if (this.resultCallback != null) {
            this.resultCallback.accept(this.textField.getValue());
        }
        this.close();
    }

    public void close() {
        this.getParent().removeChild(this);
    }

    @Override
    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (key == 256) {
            this.close();
        }
        return true;
    }

    public static TextInputDialog simpleDialog(GuiElement<?> parent, Component title) {
        return TextInputDialog.simpleDialog(parent, title, "");
    }

    public static TextInputDialog simpleDialog(GuiElement<?> parent, Component title, String defaultText) {
        TextInputDialog dialog = new TextInputDialog(parent.getModularGui());
        Constraints.bind(GuiRectangle.toolTipBackground(dialog), dialog);
        GuiText titleText = ((GuiText)((GuiText)((GuiText)new GuiText(dialog, title).setWrap(true).constrain(GeoParam.TOP, Constraint.relative(dialog.get(GeoParam.TOP), 5.0))).constrain(GeoParam.LEFT, Constraint.relative(dialog.get(GeoParam.LEFT), 5.0))).constrain(GeoParam.RIGHT, Constraint.relative(dialog.get(GeoParam.RIGHT), -5.0))).autoHeight();
        GuiRectangle textBg = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle(dialog).fill(-1608507360).constrain(GeoParam.TOP, Constraint.relative(titleText.get(GeoParam.BOTTOM), 3.0))).constrain(GeoParam.LEFT, Constraint.relative(dialog.get(GeoParam.LEFT), 5.0))).constrain(GeoParam.RIGHT, Constraint.relative(dialog.get(GeoParam.RIGHT), -5.0))).constrain(GeoParam.HEIGHT, Constraint.literal(14.0));
        dialog.textField = new GuiTextField(textBg).setEnterPressed(dialog::accept);
        Constraints.bind(dialog.textField, textBg, 0.0, 3.0, 0.0, 3.0);
        GuiButton accept = (GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiButton.flatColourButton(dialog, () -> Component.translatable((String)"gui.ok"), hovered -> hovered != false ? -12277180 : -15628271).onPress(dialog::accept).constrain(GeoParam.TOP, Constraint.relative(textBg.get(GeoParam.BOTTOM), 3.0))).constrain(GeoParam.LEFT, Constraint.match(textBg.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.midPoint(textBg.get(GeoParam.LEFT), textBg.get(GeoParam.RIGHT), -1.0))).constrain(GeoParam.HEIGHT, Constraint.literal(14.0));
        GuiButton cancel = (GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiButton.flatColourButton(dialog, () -> Component.translatable((String)"gui.cancel"), hovered -> hovered != false ? -5618620 : -7859951).onPress(dialog::close).constrain(GeoParam.TOP, Constraint.relative(textBg.get(GeoParam.BOTTOM), 3.0))).constrain(GeoParam.LEFT, Constraint.midPoint(textBg.get(GeoParam.LEFT), textBg.get(GeoParam.RIGHT), 1.0))).constrain(GeoParam.RIGHT, Constraint.match(textBg.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, Constraint.literal(14.0));
        ModularGui gui = parent.getModularGui();
        dialog.constrain(GeoParam.TOP, Constraint.midPoint(gui.get(GeoParam.TOP), gui.get(GeoParam.BOTTOM), -20.0));
        dialog.constrain(GeoParam.LEFT, Constraint.midPoint(gui.get(GeoParam.LEFT), gui.get(GeoParam.RIGHT), -100.0));
        dialog.constrain(GeoParam.BOTTOM, Constraint.relative(cancel.get(GeoParam.BOTTOM), 5.0));
        dialog.constrain(GeoParam.WIDTH, Constraint.literal(200.0));
        dialog.textField.setValue(defaultText);
        dialog.textField.setFocus(true);
        return dialog;
    }
}

