/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blue.endless.jankson.impl;

import java.util.Locale;
import net.creeperhost.polylib.blue.endless.jankson.Jankson;
import net.creeperhost.polylib.blue.endless.jankson.JsonPrimitive;
import net.creeperhost.polylib.blue.endless.jankson.api.SyntaxError;
import net.creeperhost.polylib.blue.endless.jankson.impl.ParserContext;

public class StringParserContext
implements ParserContext<JsonPrimitive> {
    private static final String HEX_DIGITS = "0123456789abcdefABCDEF";
    private int quote;
    private boolean escape = false;
    private int unicodeUs = 0;
    private StringBuilder builder = new StringBuilder();
    private boolean complete = false;
    private String unicodeSequence = "";

    public StringParserContext(int quote) {
        this.quote = quote;
    }

    @Override
    public boolean consume(int codePoint, Jankson loader) {
        if (this.escape) {
            if (this.unicodeUs > 0) {
                if (codePoint == 117 || codePoint == 85) {
                    ++this.unicodeUs;
                    return true;
                }
                if (HEX_DIGITS.indexOf(codePoint) != -1) {
                    this.unicodeSequence = this.unicodeSequence + (char)codePoint;
                    if (this.unicodeSequence.length() == 4) {
                        this.emitUnicodeSequence(loader);
                        this.escape = false;
                    }
                    return true;
                }
                this.emitUnicodeSequence(loader);
                this.escape = false;
                return false;
            }
            this.escape = false;
            switch (codePoint) {
                case 98: {
                    this.builder.append('\b');
                    return true;
                }
                case 102: {
                    this.builder.append('\f');
                    return true;
                }
                case 110: {
                    this.builder.append('\n');
                    return true;
                }
                case 10: {
                    return true;
                }
                case 114: {
                    this.builder.append('\r');
                    return true;
                }
                case 116: {
                    this.builder.append('\t');
                    return true;
                }
                case 34: {
                    this.builder.append('\"');
                    return true;
                }
                case 39: {
                    this.builder.append('\'');
                    return true;
                }
                case 92: {
                    this.builder.append('\\');
                    return true;
                }
                case 85: 
                case 117: {
                    this.escape = true;
                    this.unicodeUs = 1;
                    return true;
                }
            }
            this.builder.append((char)codePoint);
            return true;
        }
        if (codePoint == this.quote) {
            this.complete = true;
            return true;
        }
        if (codePoint == 92) {
            this.escape = true;
            return true;
        }
        if (codePoint == 10) {
            this.complete = true;
            return false;
        }
        if (codePoint < 65535) {
            this.builder.append((char)codePoint);
            return true;
        }
        int temp = codePoint - 65536;
        int highSurrogate = (temp >>> 10) + 55296;
        int lowSurrogate = (temp & 0x3FF) + 56320;
        this.builder.append((char)highSurrogate);
        this.builder.append((char)lowSurrogate);
        return true;
    }

    private void emitUnicodeSequence(Jankson loader) {
        if (this.unicodeUs > 1) {
            --this.unicodeUs;
            this.builder.append("\\");
            for (int i = 0; i < this.unicodeUs; ++i) {
                this.builder.append('u');
            }
            while (this.unicodeSequence.length() < 4) {
                this.unicodeSequence = "0" + this.unicodeSequence;
            }
            this.builder.append(this.unicodeSequence.toLowerCase(Locale.ROOT));
        } else {
            char[] chars;
            int sequence = (int)Long.parseLong(this.unicodeSequence, 16);
            for (char ch : chars = Character.toChars(sequence)) {
                this.builder.append(ch);
            }
        }
        this.unicodeUs = 0;
        this.unicodeSequence = "";
        this.escape = false;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public JsonPrimitive getResult() {
        return JsonPrimitive.of(this.builder.toString());
    }

    @Override
    public void eof() throws SyntaxError {
        throw new SyntaxError("Expected to find '" + (char)this.quote + "' to end a String, found EOF instead.");
    }
}

