/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.gui;

import com.flanks255.pocketstorage.PocketStorage;
import com.flanks255.pocketstorage.gui.LockableSlot;
import com.flanks255.pocketstorage.inventory.PSUItemHandler;
import com.flanks255.pocketstorage.items.PSUTier;
import com.flanks255.pocketstorage.network.SlotKeyPacket;
import com.flanks255.pocketstorage.util.PSUtils;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PSUContainer
extends AbstractContainerMenu {
    public PSUItemHandler handler;
    private final Inventory playerInv;
    private final UUID uuid;

    public static PSUContainer fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        CompoundTag nbt = data.readNbt();
        UUID uuidIn = data.readUUID();
        PSUTier tier = PSUTier.values()[data.readInt()];
        PSUItemHandler handler = new PSUItemHandler(tier);
        handler.deserializeNBT((HolderLookup.Provider)playerInventory.player.registryAccess(), nbt);
        return new PSUContainer(windowId, playerInventory, uuidIn, handler);
    }

    public PSUContainer(int windowId, Inventory playerInventory, UUID uuidIn, PSUItemHandler handlerIn) {
        super((MenuType)PocketStorage.PSUCONTAINER.get(), windowId);
        this.uuid = uuidIn;
        this.playerInv = playerInventory;
        this.handler = handlerIn;
        this.addPlayerSlots(playerInventory);
    }

    public void clicked(int slot, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        if (slot >= 0) {
            this.getSlot((int)slot).container.setChanged();
        }
        super.clicked(slot, dragType, clickTypeIn, player);
    }

    public void networkSlotKeyPress(int slot, SlotKeyPacket.Key key, boolean ctrl) {
        ItemStack tmp;
        if (slot >= 0 && slot <= this.handler.getSlots() && key == SlotKeyPacket.Key.DROP && !(tmp = this.handler.extractItem(slot, ctrl ? 64 : 1, false)).isEmpty()) {
            this.playerInv.player.drop(tmp, false);
        }
    }

    public void networkSlotClick(int slot, boolean shift, boolean ctrl, boolean rightClick) {
        if (slot >= 0 && slot <= this.handler.getSlots()) {
            if (!this.getCarried().isEmpty()) {
                ItemStack tmp;
                ItemStack incoming = this.getCarried();
                if (incoming.has(DataComponents.CUSTOM_DATA) && this.playerInv.player.level().isClientSide()) {
                    this.playerInv.player.sendSystemMessage((Component)Component.translatable((String)"pocketstorage.util.no_data_items"));
                    return;
                }
                if (rightClick) {
                    ItemStack single = incoming.split(1);
                    ItemStack remainder = this.handler.insertItem(slot, single, false);
                    if (!remainder.isEmpty()) {
                        incoming.grow(1);
                    }
                    this.setCarried(incoming);
                } else if (!ctrl) {
                    this.setCarried(this.handler.insertItem(slot, incoming, false));
                } else if (incoming.getCount() < incoming.getMaxStackSize() && ItemStack.isSameItem((ItemStack)incoming, (ItemStack)this.handler.getStackInSlot(slot)) && !(tmp = this.handler.extractItem(slot, 1, false)).isEmpty()) {
                    incoming.setCount(incoming.getCount() + 1);
                    this.setCarried(incoming);
                }
            } else {
                int extract;
                int n = extract = ctrl ? 1 : 64;
                if (rightClick) {
                    extract = Math.min(this.handler.getStackInSlot(slot).getCount() / 2, 32);
                }
                ItemStack tmp = this.handler.extractItem(slot, extract, false);
                if (!shift) {
                    if (!tmp.isEmpty()) {
                        this.setCarried(tmp);
                    }
                } else if (!tmp.isEmpty()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)this.playerInv.player, (ItemStack)tmp);
                }
            }
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack remainder = this.handler.insertItemSlotless(slot.getItem(), true, true);
            if (!remainder.isEmpty()) {
                slot.set(remainder);
            } else {
                slot.set(ItemStack.EMPTY);
            }
        }
        return ItemStack.EMPTY;
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int originX = 7;
        int originY = 97;
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            Optional<UUID> uuidOptional = PSUtils.getUUID((ItemStack)playerInventory.items.get(col));
            boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
            this.addSlot(new LockableSlot((Container)playerInventory, col, x + 1, y + 1, lockMe));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                int index = col + row * 9 + 9;
                Optional<UUID> uuidOptional = PSUtils.getUUID((ItemStack)playerInventory.items.get(index));
                boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
                this.addSlot(new LockableSlot((Container)playerInventory, index, x + 1, y + 1, lockMe));
            }
        }
    }
}

