/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.crafting;

import com.flanks255.pocketstorage.PocketStorage;
import com.flanks255.pocketstorage.items.PocketStorageUnit;
import com.mojang.serialization.MapCodec;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class UpgradeRecipe
extends ShapedRecipe {
    public UpgradeRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack recipeOutput) {
        super(group, category, pattern, recipeOutput);
    }

    public UpgradeRecipe(ShapedRecipe shapedRecipe) {
        super(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput input, @Nonnull HolderLookup.Provider provider) {
        ItemStack craftingResult = super.assemble(input, provider);
        ItemStack dataSource = ItemStack.EMPTY;
        if (!craftingResult.isEmpty()) {
            for (int i = 0; i < input.size(); ++i) {
                ItemStack item = input.getItem(i);
                if (item.isEmpty() || !(item.getItem() instanceof PocketStorageUnit)) continue;
                dataSource = item;
                break;
            }
            if (!dataSource.isEmpty()) {
                if (dataSource.has((DataComponentType)PocketStorage.PSU_UUID.get())) {
                    craftingResult.set((DataComponentType)PocketStorage.PSU_UUID.get(), (Object)((UUID)dataSource.get((DataComponentType)PocketStorage.PSU_UUID.get())));
                } else if (dataSource.has(DataComponents.CUSTOM_DATA) && ((CustomData)dataSource.get(DataComponents.CUSTOM_DATA)).contains("UUID")) {
                    craftingResult.set((DataComponentType)PocketStorage.PSU_UUID.get(), (Object)((CustomData)dataSource.get(DataComponents.CUSTOM_DATA)).copyTag().getUUID("UUID"));
                }
            }
        }
        return craftingResult;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)PocketStorage.UPGRADE_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeRecipe> {
        private static final MapCodec<UpgradeRecipe> CODEC = ShapedRecipe.Serializer.CODEC.xmap(UpgradeRecipe::new, UpgradeRecipe::new);
        private static final StreamCodec<RegistryFriendlyByteBuf, UpgradeRecipe> STREAM_CODEC = RecipeSerializer.SHAPED_RECIPE.streamCodec().map(UpgradeRecipe::new, UpgradeRecipe::new);

        @Nonnull
        public MapCodec<UpgradeRecipe> codec() {
            return CODEC;
        }

        @Nonnull
        public StreamCodec<RegistryFriendlyByteBuf, UpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

