/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModFluidTagsProvider
extends FluidTagsProvider {
    public ModFluidTagsProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(generatorIn.getPackOutput(), lookupProvider, "pneumaticcraft", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.createTag(PneumaticCraftTags.Fluids.CRUDE_OIL, ModFluids.OIL);
        this.createTag(PneumaticCraftTags.Fluids.ETCHING_ACID, ModFluids.ETCHING_ACID);
        this.createTag(PneumaticCraftTags.Fluids.PLASTIC, ModFluids.PLASTIC);
        this.createTag(PneumaticCraftTags.Fluids.LUBRICANT, ModFluids.LUBRICANT);
        this.createTag(PneumaticCraftTags.Fluids.DIESEL, ModFluids.DIESEL);
        this.createTag(PneumaticCraftTags.Fluids.KEROSENE, ModFluids.KEROSENE);
        this.createTag(PneumaticCraftTags.Fluids.GASOLINE, ModFluids.GASOLINE);
        this.createTag(PneumaticCraftTags.Fluids.LPG, ModFluids.LPG);
        this.createTag(PneumaticCraftTags.Fluids.YEAST_CULTURE, ModFluids.YEAST_CULTURE);
        this.createTag(PneumaticCraftTags.Fluids.ETHANOL, ModFluids.ETHANOL);
        this.createTag(PneumaticCraftTags.Fluids.PLANT_OIL, ModFluids.VEGETABLE_OIL);
        this.createTag(PneumaticCraftTags.Fluids.BIODIESEL, ModFluids.BIODIESEL);
        this.createTag(PneumaticCraftTags.Fluids.EXPERIENCE, ModFluids.MEMORY_ESSENCE);
        this.createAndAppend(PneumaticCraftTags.Fluids.CRUDE_OIL, PneumaticCraftTags.Fluids.SEISMIC, new Supplier[0]);
    }

    public String getName() {
        return "PneumaticCraft Fluid Tags";
    }

    @SafeVarargs
    private <T> T[] resolveAll(IntFunction<T[]> creator, Supplier<? extends T> ... suppliers) {
        return Arrays.stream(suppliers).map(Supplier::get).toArray(creator);
    }

    @SafeVarargs
    private void createTag(TagKey<Fluid> tag, Supplier<? extends Fluid> ... blocks) {
        this.tag(tag).add((Object[])this.resolveAll(Fluid[]::new, blocks));
    }

    @SafeVarargs
    private void appendToTag(TagKey<Fluid> tag, TagKey<Fluid> ... toAppend) {
        this.tag(tag).addTags(toAppend);
    }

    @SafeVarargs
    private void createAndAppend(TagKey<Fluid> tag, TagKey<Fluid> to, Supplier<? extends Fluid> ... fluids) {
        this.createTag(tag, fluids);
        this.appendToTag(to, tag);
    }
}

