/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.chunkloading;

import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammableControllerBlockEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.util.chunkloading.ForcedChunks;
import me.desht.pneumaticcraft.common.util.chunkloading.PlayerLogoutTracker;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.common.world.chunk.TicketController;

public class DynamicChunkLoader {
    private final TicketController ticketController;
    private final Either<DroneEntity, BlockPos> subject;
    private final Supplier<UUID> playerIdGetter;
    private final Predicate<ChunkPos> loadChecker;
    private final Set<ChunkPos> loadedChunks = new HashSet<ChunkPos>();

    private DynamicChunkLoader(TicketController ticketController, Either<DroneEntity, BlockPos> subject, Supplier<UUID> playerIdGetter, Predicate<ChunkPos> loadChecker) {
        this.ticketController = ticketController;
        this.subject = subject;
        this.playerIdGetter = playerIdGetter;
        this.loadChecker = loadChecker;
    }

    public static DynamicChunkLoader forDrone(DroneEntity drone) {
        return new DynamicChunkLoader(ForcedChunks.INSTANCE.getDroneController(), (Either<DroneEntity, BlockPos>)Either.left((Object)drone), drone::getOwnerUUID, drone::shouldLoadChunk);
    }

    public static DynamicChunkLoader forProgrammableController(ProgrammableControllerBlockEntity pc) {
        return new DynamicChunkLoader(ForcedChunks.INSTANCE.getPcController(), (Either<DroneEntity, BlockPos>)Either.right((Object)pc.getBlockPos()), pc::getOwnerUUID, pc::shouldLoadChunk);
    }

    public void updateLoadedChunks(ServerLevel level, ChunkPos origin) {
        for (int cx = origin.x - 1; cx <= origin.x + 1; ++cx) {
            for (int cz = origin.z - 1; cz <= origin.z + 1; ++cz) {
                ChunkPos cp = new ChunkPos(cx, cz);
                if (!this.shouldLoadChunk(level.getServer(), cp)) continue;
                this.loadedChunks.add(cp);
            }
        }
        Iterator<ChunkPos> iter = this.loadedChunks.iterator();
        while (iter.hasNext()) {
            ChunkPos cp = iter.next();
            boolean shouldLoad = this.shouldLoadChunk(level.getServer(), cp);
            this.setChunkLoaded(level, cp, shouldLoad);
            if (shouldLoad) continue;
            iter.remove();
        }
        Log.debug("updated chunks for {} - {} loaded", this.playerIdGetter.get(), this.loadedChunks.size());
    }

    public void unloadAll(ServerLevel level) {
        Log.debug("unloading chunks for {}", this.playerIdGetter.get());
        this.loadedChunks.forEach(cp -> this.setChunkLoaded(level, (ChunkPos)cp, false));
        this.loadedChunks.clear();
    }

    private boolean shouldLoadChunk(MinecraftServer server, ChunkPos cp) {
        return !PlayerLogoutTracker.INSTANCE.isPlayerLoggedOutTooLong(server, this.playerIdGetter.get()) && this.loadChecker.test(cp);
    }

    private void setChunkLoaded(ServerLevel level, ChunkPos cp, boolean loaded) {
        this.subject.map(drone -> this.ticketController.forceChunk(level, (Entity)drone, cp.x, cp.z, loaded, true), blockPos -> this.ticketController.forceChunk(level, blockPos, cp.x, cp.z, loaded, true));
    }
}

