/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.upgrades;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.SavedUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.items.IItemHandler;

public class UpgradableItemUtils {
    public static final int UPGRADE_INV_SIZE = 9;

    public static void addUpgradeInformation(ItemStack iStack, List<Component> textList, TooltipFlag flag) {
        Map<PNCUpgrade, Integer> upgrades = UpgradableItemUtils.getUpgrades(iStack);
        if (upgrades.isEmpty()) {
            if (!ApplicableUpgradesDB.getInstance().getApplicableUpgrades(iStack.getItem()).isEmpty()) {
                textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.upgrades.empty", new Object[0]).withStyle(ChatFormatting.DARK_GREEN));
            }
        } else {
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.upgrades.not_empty", new Object[0]).withStyle(ChatFormatting.GREEN));
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            upgrades.forEach((upgrade, count) -> {
                ItemStack upgradeStack = upgrade.getItemStack((int)count);
                if (!UpgradableItemUtils.isUpgradeBlacklisted(iStack.getItem(), upgradeStack)) {
                    stacks.add(upgradeStack);
                }
            });
            PneumaticCraftUtils.summariseItemStacks(textList, stacks, Component.literal((String)"\u2022 ").withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    public static void setUpgrades(ItemStack stack, IItemHandler handler) {
        stack.set(ModDataComponents.ITEM_UPGRADES, (Object)SavedUpgrades.fromItemHandler(handler, t -> ApplicableUpgradesDB.getInstance().getMaxUpgrades(stack.getItem(), (PNCUpgrade)t)));
        PNCCapabilities.getAirHandler(stack).ifPresent(h -> {
            if (h.getPressure() > h.maxPressure()) {
                int maxAir = (int)((float)h.getVolume() * h.maxPressure());
                h.addAir(maxAir - h.getAir());
            }
        });
    }

    public static Map<PNCUpgrade, Integer> getUpgrades(ItemStack stack) {
        return ((SavedUpgrades)stack.getOrDefault(ModDataComponents.ITEM_UPGRADES, (Object)SavedUpgrades.EMPTY)).getUpgradeMap();
    }

    public static int getUpgradeCount(ItemStack stack, PNCUpgrade upgrade) {
        return ((SavedUpgrades)stack.getOrDefault(ModDataComponents.ITEM_UPGRADES, (Object)SavedUpgrades.EMPTY)).getUpgradeCount(upgrade);
    }

    public static IntList getUpgradeList(ItemStack stack, PNCUpgrade ... upgradeList) {
        IntArrayList res = new IntArrayList();
        Map<PNCUpgrade, Integer> map = UpgradableItemUtils.getUpgrades(stack);
        for (PNCUpgrade upgrade : upgradeList) {
            res.add(map.getOrDefault(upgrade, 0).intValue());
        }
        return IntLists.unmodifiable((IntList)res);
    }

    public static boolean hasCreativeUpgrade(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.CREATIVE.get()) > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isUpgradeBlacklisted(Item containerItem, ItemStack upgradeStack) {
        if (!(containerItem instanceof IChargeableContainerProvider)) return false;
        IChargeableContainerProvider p = (IChargeableContainerProvider)containerItem;
        if (p.getUpgradeBlacklistTag().map(arg_0 -> ((ItemStack)upgradeStack).is(arg_0)).orElse(false) == false) return false;
        return true;
    }
}

