/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModHoeHandlers;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.RadiationSourceCheck;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.Mek2PNCHeatAdapter;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.PNC2MekHeatAdapter;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.PaxelHandler;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.RadiationShieldingProvider;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.radiation.capability.IRadiationShielding;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jline.utils.Log;

public class MekanismIntegration {
    public static final BlockCapability<IHeatHandler, Direction> CAPABILITY_HEAT_HANDLER = BlockCapability.createSided((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"heat_handler"), IHeatHandler.class);
    public static final ItemCapability<IRadiationShielding, Void> CAPABILITY_RADIATION_SHIELDING = ItemCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"radiation_shielding"), IRadiationShielding.class);

    static void mekSetup() {
        RadiationSourceCheck.INSTANCE.registerRadiationSource((registryAccess, dmgSource) -> dmgSource == IRadiationManager.INSTANCE.getRadiationDamageSource(registryAccess));
    }

    static void registerCaps(RegisterCapabilitiesEvent event) {
        for (Supplier supplier : List.of(ModItems.PNEUMATIC_HELMET, ModItems.PNEUMATIC_CHESTPLATE, ModItems.PNEUMATIC_LEGGINGS, ModItems.PNEUMATIC_BOOTS)) {
            event.registerItem(CAPABILITY_RADIATION_SHIELDING, (arg_0, arg_1) -> MekanismIntegration.lambda$registerCaps$1((Supplier)supplier, arg_0, arg_1), new ItemLike[]{(ItemLike)supplier.get()});
        }
        ModBlockEntityTypes.streamBlockEntities().filter(be -> be instanceof IHeatExchangingTE).forEach(be -> event.registerBlockEntity(CAPABILITY_HEAT_HANDLER, be.getType(), PNC2MekHeatAdapter::maybe));
        MekanismIntegration.registerMekanismBlockEntityHeat(event, "fuelwood_heater");
        MekanismIntegration.registerMekanismBlockEntityHeat(event, "resistive_heater");
        MekanismIntegration.registerMekanismBlockEntityHeat(event, "basic_thermodynamic_conductor");
        MekanismIntegration.registerMekanismBlockEntityHeat(event, "advanced_thermodynamic_conductor");
        MekanismIntegration.registerMekanismBlockEntityHeat(event, "elite_thermodynamic_conductor");
        MekanismIntegration.registerMekanismBlockEntityHeat(event, "ultimate_thermodynamic_conductor");
    }

    static void registerMekanismBlockEntityHeat(RegisterCapabilitiesEvent event, String id) {
        BlockEntityType type = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)id));
        if (type != null) {
            event.registerBlockEntity(PNCCapabilities.HEAT_EXCHANGER_BLOCK, type, Mek2PNCHeatAdapter::maybe);
        } else {
            Log.warn((Object[])new Object[]{"unknown Mekanism block entity type: {}", id});
        }
    }

    static void registerPaxelHandler(RegisterEvent event) {
        event.register(ModHoeHandlers.HOE_HANDLERS_DEFERRED.getRegistryKey(), PneumaticRegistry.RL("mekanism_paxels"), PaxelHandler::new);
    }

    private static /* synthetic */ IRadiationShielding lambda$registerCaps$1(Supplier item, ItemStack stack, Void ctx) {
        return new RadiationShieldingProvider(stack, ((PneumaticArmorItem)item.get()).getType());
    }
}

