/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.registry;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.FuelQualityRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRecipeTypes {
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"pneumaticcraft");
    public static final Supplier<PneumaticCraftRecipeType<AmadronRecipe>> AMADRON = ModRecipeTypes.register("amadron", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<AssemblyRecipe>> ASSEMBLY_LASER = ModRecipeTypes.register("assembly_laser", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<AssemblyRecipe>> ASSEMBLY_DRILL = ModRecipeTypes.register("assembly_drill", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<AssemblyRecipe>> ASSEMBLY_DRILL_LASER = ModRecipeTypes.register("assembly_drill_laser", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<HeatPropertiesRecipe>> BLOCK_HEAT_PROPERTIES = ModRecipeTypes.register("heat_properties", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<ExplosionCraftingRecipe>> EXPLOSION_CRAFTING = ModRecipeTypes.register("explosion_crafting", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<FluidMixerRecipe>> FLUID_MIXER = ModRecipeTypes.register("fluid_mixer", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<FuelQualityRecipe>> FUEL_QUALITY = ModRecipeTypes.register("fuel_quality", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<HeatFrameCoolingRecipe>> HEAT_FRAME_COOLING = ModRecipeTypes.register("heat_frame_cooling", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<PressureChamberRecipe>> PRESSURE_CHAMBER = ModRecipeTypes.register("pressure_chamber", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<RefineryRecipe>> REFINERY = ModRecipeTypes.register("refinery", PneumaticCraftRecipeType::new);
    public static final Supplier<PneumaticCraftRecipeType<ThermoPlantRecipe>> THERMO_PLANT = ModRecipeTypes.register("thermo_plant", PneumaticCraftRecipeType::new);

    private static <T extends PneumaticCraftRecipeType<?>> Supplier<T> register(String name, Function<String, T> factory) {
        return RECIPE_TYPES.register(name, () -> (PneumaticCraftRecipeType)factory.apply(name));
    }

    public static <T extends PneumaticCraftRecipe> Collection<RecipeHolder<T>> getRecipes(Level level, Supplier<PneumaticCraftRecipeType<T>> sup) {
        return sup.get().allRecipeHolders(level);
    }
}

