/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.AbstractAssemblyIOUnitBlock;
import me.desht.pneumaticcraft.common.block.AdvancedAirCompressorBlock;
import me.desht.pneumaticcraft.common.block.AdvancedLiquidCompressorBlock;
import me.desht.pneumaticcraft.common.block.AerialInterfaceBlock;
import me.desht.pneumaticcraft.common.block.AirCannonBlock;
import me.desht.pneumaticcraft.common.block.AirCompressorBlock;
import me.desht.pneumaticcraft.common.block.AphorismTileBlock;
import me.desht.pneumaticcraft.common.block.AssemblyControllerBlock;
import me.desht.pneumaticcraft.common.block.AssemblyDrillBlock;
import me.desht.pneumaticcraft.common.block.AssemblyLaserBlock;
import me.desht.pneumaticcraft.common.block.AssemblyPlatformBlock;
import me.desht.pneumaticcraft.common.block.ChargingStationBlock;
import me.desht.pneumaticcraft.common.block.CompressedIronBlock;
import me.desht.pneumaticcraft.common.block.CreativeCompressedIronBlock;
import me.desht.pneumaticcraft.common.block.CreativeCompressorBlock;
import me.desht.pneumaticcraft.common.block.DisplayTableBlock;
import me.desht.pneumaticcraft.common.block.DrillPipeBlock;
import me.desht.pneumaticcraft.common.block.DroneRedstoneEmitterBlock;
import me.desht.pneumaticcraft.common.block.ElectrostaticCompressorBlock;
import me.desht.pneumaticcraft.common.block.ElevatorBaseBlock;
import me.desht.pneumaticcraft.common.block.ElevatorCallerBlock;
import me.desht.pneumaticcraft.common.block.ElevatorFrameBlock;
import me.desht.pneumaticcraft.common.block.EmptySpawnerBlock;
import me.desht.pneumaticcraft.common.block.EtchingTankBlock;
import me.desht.pneumaticcraft.common.block.FluidEtchingAcidBlock;
import me.desht.pneumaticcraft.common.block.FluidMixerBlock;
import me.desht.pneumaticcraft.common.block.FluidTankBlock;
import me.desht.pneumaticcraft.common.block.FluxCompressorBlock;
import me.desht.pneumaticcraft.common.block.GasLiftBlock;
import me.desht.pneumaticcraft.common.block.HeatPipeBlock;
import me.desht.pneumaticcraft.common.block.HeatSinkBlock;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.block.KeroseneLampBlock;
import me.desht.pneumaticcraft.common.block.KeroseneLampLightBlock;
import me.desht.pneumaticcraft.common.block.LiquidCompressorBlock;
import me.desht.pneumaticcraft.common.block.LiquidHopperBlock;
import me.desht.pneumaticcraft.common.block.ManualCompressorBlock;
import me.desht.pneumaticcraft.common.block.OmnidirectionalHopperBlock;
import me.desht.pneumaticcraft.common.block.PlasticBrickBlock;
import me.desht.pneumaticcraft.common.block.PneumaticDoorBaseBlock;
import me.desht.pneumaticcraft.common.block.PneumaticDoorBlock;
import me.desht.pneumaticcraft.common.block.PneumaticDynamoBlock;
import me.desht.pneumaticcraft.common.block.PressureChamberGlassBlock;
import me.desht.pneumaticcraft.common.block.PressureChamberInterfaceBlock;
import me.desht.pneumaticcraft.common.block.PressureChamberValveBlock;
import me.desht.pneumaticcraft.common.block.PressureChamberWallBlock;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.PressurizedSpawnerBlock;
import me.desht.pneumaticcraft.common.block.ProgrammableControllerBlock;
import me.desht.pneumaticcraft.common.block.ProgrammerBlock;
import me.desht.pneumaticcraft.common.block.RefineryControllerBlock;
import me.desht.pneumaticcraft.common.block.RefineryOutputBlock;
import me.desht.pneumaticcraft.common.block.ReinforcedChestBlock;
import me.desht.pneumaticcraft.common.block.SecurityStationBlock;
import me.desht.pneumaticcraft.common.block.SentryTurretBlock;
import me.desht.pneumaticcraft.common.block.SmartChestBlock;
import me.desht.pneumaticcraft.common.block.SmoothPlasticBrickBlock;
import me.desht.pneumaticcraft.common.block.SolarCompressorBlock;
import me.desht.pneumaticcraft.common.block.SpawnerExtractorBlock;
import me.desht.pneumaticcraft.common.block.TagWorkbenchBlock;
import me.desht.pneumaticcraft.common.block.ThermalCompressorBlock;
import me.desht.pneumaticcraft.common.block.ThermalLaggingBlock;
import me.desht.pneumaticcraft.common.block.ThermopneumaticProcessingPlantBlock;
import me.desht.pneumaticcraft.common.block.TubeJunctionBlock;
import me.desht.pneumaticcraft.common.block.UVLightBoxBlock;
import me.desht.pneumaticcraft.common.block.UniversalSensorBlock;
import me.desht.pneumaticcraft.common.block.VacuumPumpBlock;
import me.desht.pneumaticcraft.common.block.VacuumTrapBlock;
import me.desht.pneumaticcraft.common.block.VortexTubeBlock;
import me.desht.pneumaticcraft.common.block.WallLampBlock;
import me.desht.pneumaticcraft.common.block.entity.tube.AdvancedPressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.tube.ReinforcedPressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.DroneInterfaceBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"pneumaticcraft");
    public static final DeferredRegister<Item> ITEMS = ModItems.ITEMS;
    public static final DeferredBlock<PressureTubeBlock> PRESSURE_TUBE = ModBlocks.register("pressure_tube", props -> new PressureTubeBlock((BlockBehaviour.Properties)props, PressureTubeBlockEntity::new), ModBlocks.camoProps());
    public static final DeferredBlock<PressureTubeBlock> REINFORCED_PRESSURE_TUBE = ModBlocks.register("reinforced_pressure_tube", props -> new PressureTubeBlock((BlockBehaviour.Properties)props, ReinforcedPressureTubeBlockEntity::new), ModBlocks.camoProps());
    public static final DeferredBlock<PressureTubeBlock> ADVANCED_PRESSURE_TUBE = ModBlocks.register("advanced_pressure_tube", props -> new PressureTubeBlock((BlockBehaviour.Properties)props, AdvancedPressureTubeBlockEntity::new), ModBlocks.camoProps());
    public static final DeferredBlock<AirCannonBlock> AIR_CANNON = ModBlocks.register("air_cannon", AirCannonBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<PressureChamberWallBlock> PRESSURE_CHAMBER_WALL = ModBlocks.register("pressure_chamber_wall", PressureChamberWallBlock::new, IBlockPressureChamber.pressureChamberBlockProps());
    public static final DeferredBlock<PressureChamberGlassBlock> PRESSURE_CHAMBER_GLASS = ModBlocks.register("pressure_chamber_glass", PressureChamberGlassBlock::new, IBlockPressureChamber.pressureChamberBlockProps().noOcclusion());
    public static final DeferredBlock<PressureChamberValveBlock> PRESSURE_CHAMBER_VALVE = ModBlocks.register("pressure_chamber_valve", PressureChamberValveBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<PressureChamberInterfaceBlock> PRESSURE_CHAMBER_INTERFACE = ModBlocks.register("pressure_chamber_interface", PressureChamberInterfaceBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<ChargingStationBlock> CHARGING_STATION = ModBlocks.register("charging_station", ChargingStationBlock::new, ModBlocks.defaultProps(), block -> () -> new ChargingStationBlock.ItemBlockChargingStation((Block)block.get()));
    public static final DeferredBlock<DrillPipeBlock> DRILL_PIPE = ModBlocks.register("drill_pipe", DrillPipeBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<ElevatorBaseBlock> ELEVATOR_BASE = ModBlocks.register("elevator_base", ElevatorBaseBlock::new, ModBlocks.camoProps());
    public static final DeferredBlock<ElevatorFrameBlock> ELEVATOR_FRAME = ModBlocks.register("elevator_frame", ElevatorFrameBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<VacuumPumpBlock> VACUUM_PUMP = ModBlocks.register("vacuum_pump", VacuumPumpBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<PneumaticDoorBaseBlock> PNEUMATIC_DOOR_BASE = ModBlocks.register("pneumatic_door_base", PneumaticDoorBaseBlock::new, ModBlocks.camoProps());
    public static final DeferredBlock<PneumaticDoorBlock> PNEUMATIC_DOOR = ModBlocks.register("pneumatic_door", PneumaticDoorBlock::new, ModBlocks.defaultProps(), block -> () -> new PneumaticDoorBlock.ItemBlockPneumaticDoor((Block)block.get()));
    public static final DeferredBlock<AssemblyPlatformBlock> ASSEMBLY_PLATFORM = ModBlocks.register("assembly_platform", AssemblyPlatformBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<AbstractAssemblyIOUnitBlock> ASSEMBLY_IO_UNIT_IMPORT = ModBlocks.register("assembly_io_unit_import", AbstractAssemblyIOUnitBlock.Import::new, ModBlocks.defaultProps());
    public static final DeferredBlock<AbstractAssemblyIOUnitBlock> ASSEMBLY_IO_UNIT_EXPORT = ModBlocks.register("assembly_io_unit_export", AbstractAssemblyIOUnitBlock.Export::new, ModBlocks.defaultProps());
    public static final DeferredBlock<AssemblyDrillBlock> ASSEMBLY_DRILL = ModBlocks.register("assembly_drill", AssemblyDrillBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<AssemblyLaserBlock> ASSEMBLY_LASER = ModBlocks.register("assembly_laser", AssemblyLaserBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<AssemblyControllerBlock> ASSEMBLY_CONTROLLER = ModBlocks.register("assembly_controller", AssemblyControllerBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<CompressedIronBlock> COMPRESSED_IRON_BLOCK = ModBlocks.register("compressed_iron_block", CompressedIronBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<UVLightBoxBlock> UV_LIGHT_BOX = ModBlocks.register("uv_light_box", UVLightBoxBlock::new, ModBlocks.defaultProps().lightLevel(state -> (Boolean)state.getValue((Property)UVLightBoxBlock.LIT) != false ? 15 : 0));
    public static final DeferredBlock<SecurityStationBlock> SECURITY_STATION = ModBlocks.register("security_station", SecurityStationBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<UniversalSensorBlock> UNIVERSAL_SENSOR = ModBlocks.register("universal_sensor", UniversalSensorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<AerialInterfaceBlock> AERIAL_INTERFACE = ModBlocks.register("aerial_interface", AerialInterfaceBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<ElectrostaticCompressorBlock> ELECTROSTATIC_COMPRESSOR = ModBlocks.register("electrostatic_compressor", ElectrostaticCompressorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<AphorismTileBlock> APHORISM_TILE = ModBlocks.register("aphorism_tile", AphorismTileBlock::new, ModBlocks.defaultProps().mapColor(MapColor.QUARTZ).strength(1.5f, 4.0f).noCollission(), block -> () -> new AphorismTileBlock.ItemBlockAphorismTile((AphorismTileBlock)block.get()));
    public static final DeferredBlock<OmnidirectionalHopperBlock> OMNIDIRECTIONAL_HOPPER = ModBlocks.register("omnidirectional_hopper", OmnidirectionalHopperBlock::new, ModBlocks.defaultProps(), block -> () -> new OmnidirectionalHopperBlock.ItemBlockOmnidirectionalHopper((Block)block.get()));
    public static final DeferredBlock<ElevatorCallerBlock> ELEVATOR_CALLER = ModBlocks.register("elevator_caller", ElevatorCallerBlock::new, ModBlocks.camoProps());
    public static final DeferredBlock<ProgrammerBlock> PROGRAMMER = ModBlocks.register("programmer", ProgrammerBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<CreativeCompressorBlock> CREATIVE_COMPRESSOR = ModBlocks.register("creative_compressor", CreativeCompressorBlock::new, ModBlocks.defaultProps(), block -> () -> new CreativeCompressorBlock.ItemBlockCreativeCompressor((Block)block.get()));
    public static final DeferredBlock<CreativeCompressedIronBlock> CREATIVE_COMPRESSED_IRON_BLOCK = ModBlocks.register("creative_compressed_iron_block", CreativeCompressedIronBlock::new, ModBlocks.defaultProps(), block -> () -> new CreativeCompressedIronBlock.ItemBlockCreativeCompressedIron((CreativeCompressedIronBlock)block.get()));
    public static final DeferredBlock<LiquidCompressorBlock> LIQUID_COMPRESSOR = ModBlocks.register("liquid_compressor", LiquidCompressorBlock::new, ModBlocks.defaultProps().noOcclusion());
    public static final DeferredBlock<AdvancedLiquidCompressorBlock> ADVANCED_LIQUID_COMPRESSOR = ModBlocks.register("advanced_liquid_compressor", AdvancedLiquidCompressorBlock::new, ModBlocks.defaultProps().noOcclusion());
    public static final DeferredBlock<AirCompressorBlock> AIR_COMPRESSOR = ModBlocks.register("air_compressor", AirCompressorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<AdvancedAirCompressorBlock> ADVANCED_AIR_COMPRESSOR = ModBlocks.register("advanced_air_compressor", AdvancedAirCompressorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<SolarCompressorBlock> SOLAR_COMPRESSOR = ModBlocks.register("solar_compressor", SolarCompressorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<LiquidHopperBlock> LIQUID_HOPPER = ModBlocks.register("liquid_hopper", LiquidHopperBlock::new, ModBlocks.defaultProps(), block -> () -> new LiquidHopperBlock.ItemBlockLiquidHopper((Block)block.get()));
    public static final DeferredBlock<ManualCompressorBlock> MANUAL_COMPRESSOR = ModBlocks.register("manual_compressor", ManualCompressorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<DroneRedstoneEmitterBlock> DRONE_REDSTONE_EMITTER = ModBlocks.registerNoItem("drone_redstone_emitter", DroneRedstoneEmitterBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AIR));
    public static final DeferredBlock<HeatSinkBlock> HEAT_SINK = ModBlocks.register("heat_sink", HeatSinkBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<VortexTubeBlock> VORTEX_TUBE = ModBlocks.register("vortex_tube", VortexTubeBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<ProgrammableControllerBlock> PROGRAMMABLE_CONTROLLER = ModBlocks.register("programmable_controller", ProgrammableControllerBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<GasLiftBlock> GAS_LIFT = ModBlocks.register("gas_lift", GasLiftBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<RefineryControllerBlock> REFINERY = ModBlocks.register("refinery", RefineryControllerBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<RefineryOutputBlock> REFINERY_OUTPUT = ModBlocks.register("refinery_output", RefineryOutputBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<ThermopneumaticProcessingPlantBlock> THERMOPNEUMATIC_PROCESSING_PLANT = ModBlocks.register("thermopneumatic_processing_plant", ThermopneumaticProcessingPlantBlock::new, ModBlocks.defaultProps().noOcclusion());
    public static final DeferredBlock<KeroseneLampBlock> KEROSENE_LAMP = ModBlocks.register("kerosene_lamp", KeroseneLampBlock::new, ModBlocks.defaultProps().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0), block -> () -> new KeroseneLampBlock.ItemBlockKeroseneLamp((Block)block.get()));
    public static final DeferredBlock<KeroseneLampLightBlock> KEROSENE_LAMP_LIGHT = ModBlocks.registerNoItem("kerosene_lamp_light", KeroseneLampLightBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AIR).lightLevel(blockstate -> 15));
    public static final DeferredBlock<SentryTurretBlock> SENTRY_TURRET = ModBlocks.register("sentry_turret", SentryTurretBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<FluxCompressorBlock> FLUX_COMPRESSOR = ModBlocks.register("flux_compressor", FluxCompressorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<PneumaticDynamoBlock> PNEUMATIC_DYNAMO = ModBlocks.register("pneumatic_dynamo", PneumaticDynamoBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<ThermalCompressorBlock> THERMAL_COMPRESSOR = ModBlocks.register("thermal_compressor", ThermalCompressorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<HeatPipeBlock> HEAT_PIPE = ModBlocks.register("heat_pipe", HeatPipeBlock::new, ModBlocks.defaultProps().noOcclusion().forceSolidOn());
    public static final DeferredBlock<EtchingTankBlock> ETCHING_TANK = ModBlocks.register("etching_tank", EtchingTankBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<FluidTankBlock> TANK_SMALL = ModBlocks.register("small_tank", props -> new FluidTankBlock((BlockBehaviour.Properties)props, FluidTankBlock.Size.SMALL), ModBlocks.defaultProps(), block -> () -> new FluidTankBlock.ItemBlockFluidTank((Block)block.get()));
    public static final DeferredBlock<FluidTankBlock> TANK_MEDIUM = ModBlocks.register("medium_tank", props -> new FluidTankBlock((BlockBehaviour.Properties)props, FluidTankBlock.Size.MEDIUM), ModBlocks.defaultProps(), block -> () -> new FluidTankBlock.ItemBlockFluidTank((Block)block.get()));
    public static final DeferredBlock<FluidTankBlock> TANK_LARGE = ModBlocks.register("large_tank", props -> new FluidTankBlock((BlockBehaviour.Properties)props, FluidTankBlock.Size.LARGE), ModBlocks.defaultProps(), block -> () -> new FluidTankBlock.ItemBlockFluidTank((Block)block.get()));
    public static final DeferredBlock<FluidTankBlock> TANK_HUGE = ModBlocks.register("huge_tank", props -> new FluidTankBlock((BlockBehaviour.Properties)props, FluidTankBlock.Size.HUGE), ModBlocks.defaultProps(), block -> () -> new FluidTankBlock.ItemBlockFluidTank((Block)block.get()));
    public static final DeferredBlock<ReinforcedChestBlock> REINFORCED_CHEST = ModBlocks.register("reinforced_chest", ReinforcedChestBlock::new, ModBlocks.reinforcedStoneProps(), block -> () -> new ReinforcedChestBlock.ItemBlockReinforcedChest((ReinforcedChestBlock)block.get()));
    public static final DeferredBlock<SmartChestBlock> SMART_CHEST = ModBlocks.register("smart_chest", SmartChestBlock::new, ModBlocks.reinforcedStoneProps(), block -> () -> new SmartChestBlock.ItemBlockBlockSmartChest((Block)block.get()));
    public static final DeferredBlock<TagWorkbenchBlock> TAG_WORKBENCH = ModBlocks.register("tag_workbench", TagWorkbenchBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<DisplayTableBlock> DISPLAY_TABLE = ModBlocks.register("display_table", DisplayTableBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<DisplayTableBlock.Shelf> DISPLAY_SHELF = ModBlocks.register("display_shelf", DisplayTableBlock.Shelf::new, ModBlocks.defaultProps());
    public static final DeferredBlock<DroneInterfaceBlock> DRONE_INTERFACE = ModBlocks.register("drone_interface", DroneInterfaceBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<ThermalLaggingBlock> THERMAL_LAGGING = ModBlocks.register("thermal_lagging", ThermalLaggingBlock::new, ModBlocks.defaultProps().noOcclusion().noCollission());
    public static final DeferredBlock<FluidMixerBlock> FLUID_MIXER = ModBlocks.register("fluid_mixer", FluidMixerBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<VacuumTrapBlock> VACUUM_TRAP = ModBlocks.register("vacuum_trap", VacuumTrapBlock::new, ModBlocks.defaultProps(), block -> () -> new VacuumTrapBlock.ItemBlockVacuumTrap((VacuumTrapBlock)block.get()));
    public static final DeferredBlock<SpawnerExtractorBlock> SPAWNER_EXTRACTOR = ModBlocks.register("spawner_extractor", SpawnerExtractorBlock::new, ModBlocks.defaultProps());
    public static final DeferredBlock<EmptySpawnerBlock> EMPTY_SPAWNER = ModBlocks.register("empty_spawner", EmptySpawnerBlock::new, ModBlocks.defaultProps().noOcclusion());
    public static final DeferredBlock<PressurizedSpawnerBlock> PRESSURIZED_SPAWNER = ModBlocks.register("pressurized_spawner", PressurizedSpawnerBlock::new, ModBlocks.defaultProps().noOcclusion());
    public static final DeferredBlock<TubeJunctionBlock> TUBE_JUNCTION = ModBlocks.register("tube_junction", TubeJunctionBlock::new, ModBlocks.defaultProps());
    public static final List<DeferredBlock<PlasticBrickBlock>> PLASTIC_BRICKS = new ArrayList<DeferredBlock<PlasticBrickBlock>>();
    public static final List<DeferredBlock<SmoothPlasticBrickBlock>> SMOOTH_PLASTIC_BRICKS = new ArrayList<DeferredBlock<SmoothPlasticBrickBlock>>();
    public static final List<DeferredBlock<WallLampBlock>> WALL_LAMPS = new ArrayList<DeferredBlock<WallLampBlock>>();
    public static final List<DeferredBlock<WallLampBlock>> WALL_LAMPS_INVERTED = new ArrayList<DeferredBlock<WallLampBlock>>();
    public static final DeferredBlock<Block> REINFORCED_STONE;
    public static final DeferredBlock<Block> REINFORCED_BRICKS;
    public static final DeferredBlock<Block> REINFORCED_BRICK_TILE;
    public static final DeferredBlock<Block> REINFORCED_BRICK_STAIRS;
    public static final DeferredBlock<Block> REINFORCED_BRICK_SLAB;
    public static final DeferredBlock<Block> REINFORCED_STONE_SLAB;
    public static final DeferredBlock<Block> REINFORCED_BRICK_PILLAR;
    public static final DeferredBlock<Block> REINFORCED_BRICK_WALL;
    public static final DeferredBlock<Block> COMPRESSED_STONE;
    public static final DeferredBlock<Block> COMPRESSED_BRICKS;
    public static final DeferredBlock<Block> COMPRESSED_BRICK_TILE;
    public static final DeferredBlock<Block> COMPRESSED_BRICK_STAIRS;
    public static final DeferredBlock<Block> COMPRESSED_BRICK_SLAB;
    public static final DeferredBlock<Block> COMPRESSED_STONE_SLAB;
    public static final DeferredBlock<Block> COMPRESSED_BRICK_PILLAR;
    public static final DeferredBlock<Block> COMPRESSED_BRICK_WALL;
    public static final DeferredBlock<FluidEtchingAcidBlock> ETCHING_ACID;
    public static final DeferredBlock<LiquidBlock> PLASTIC;
    public static final DeferredBlock<LiquidBlock> LUBRICANT;
    public static final DeferredBlock<LiquidBlock> OIL;
    public static final DeferredBlock<LiquidBlock> DIESEL;
    public static final DeferredBlock<LiquidBlock> KEROSENE;
    public static final DeferredBlock<LiquidBlock> GASOLINE;
    public static final DeferredBlock<LiquidBlock> LPG;
    public static final DeferredBlock<LiquidBlock> MEMORY_ESSENCE;
    public static final DeferredBlock<LiquidBlock> YEAST_CULTURE;
    public static final DeferredBlock<LiquidBlock> ETHANOL;
    public static final DeferredBlock<LiquidBlock> VEGETABLE_OIL;
    public static final DeferredBlock<LiquidBlock> BIODIESEL;

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, ? extends T> sup, BlockBehaviour.Properties props) {
        return ModBlocks.register(name, sup, props, ModBlocks::itemDefault);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, ? extends T> sup, BlockBehaviour.Properties props, Function<DeferredBlock<T>, Supplier<? extends Item>> itemCreator) {
        DeferredBlock<? extends T> ret = ModBlocks.registerNoItem(name, sup, props);
        ITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> DeferredBlock<T> registerNoItem(String name, Function<BlockBehaviour.Properties, ? extends T> sup, BlockBehaviour.Properties props) {
        return BLOCKS.registerBlock(name, sup, props);
    }

    private static Supplier<BlockItem> itemDefault(DeferredBlock<? extends Block> blockSupplier) {
        return ModBlocks.item(blockSupplier);
    }

    private static Supplier<BlockItem> item(DeferredBlock<? extends Block> blockSupplier) {
        return () -> new BlockItem((Block)blockSupplier.get(), ModItems.defaultProps());
    }

    public static BlockBehaviour.Properties defaultProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 10.0f).sound(SoundType.METAL);
    }

    public static BlockBehaviour.Properties camoProps() {
        return ModBlocks.defaultProps().noOcclusion();
    }

    public static BlockBehaviour.Properties reinforcedStoneProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(3.0f, 1200.0f).sound(SoundType.STONE);
    }

    private static BlockBehaviour.Properties fluidProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.WATER).noCollission().strength(100.0f).noLootTable().replaceable();
    }

    public static DeferredBlock<PlasticBrickBlock> plasticBrick(DyeColor color) {
        return PLASTIC_BRICKS.get(color.getId());
    }

    public static DeferredBlock<SmoothPlasticBrickBlock> smoothPlasticBrick(DyeColor color) {
        return SMOOTH_PLASTIC_BRICKS.get(color.getId());
    }

    public static DeferredBlock<WallLampBlock> wallLamp(DyeColor color, boolean inverted) {
        return inverted ? WALL_LAMPS_INVERTED.get(color.getId()) : WALL_LAMPS.get(color.getId());
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            PLASTIC_BRICKS.add(ModBlocks.register("plastic_brick_" + color.getName(), props -> new PlasticBrickBlock((BlockBehaviour.Properties)props, color), ModBlocks.defaultProps().sound(SoundType.WOOD).strength(2.0f), block -> () -> new PlasticBrickBlock.ItemPlasticBrick((PlasticBrickBlock)block.get())));
            SMOOTH_PLASTIC_BRICKS.add(ModBlocks.register("smooth_plastic_brick_" + color.getName(), props -> new SmoothPlasticBrickBlock((BlockBehaviour.Properties)props, color), ModBlocks.defaultProps().sound(SoundType.WOOD).strength(2.0f).speedFactor(1.35f), block -> () -> new SmoothPlasticBrickBlock.SmoothPlasticBrickItem((SmoothPlasticBrickBlock)block.get())));
            WALL_LAMPS.add(ModBlocks.register("wall_lamp_" + color.getName(), props -> new WallLampBlock((BlockBehaviour.Properties)props, color, false), WallLampBlock.wallLampProperties(), block -> () -> new WallLampBlock.ItemWallLamp((WallLampBlock)block.get())));
            WALL_LAMPS_INVERTED.add(ModBlocks.register("wall_lamp_inverted_" + color.getName(), props -> new WallLampBlock((BlockBehaviour.Properties)props, color, true), WallLampBlock.wallLampProperties(), block -> () -> new WallLampBlock.ItemWallLamp((WallLampBlock)block.get())));
        }
        REINFORCED_STONE = ModBlocks.register("reinforced_stone", Block::new, ModBlocks.reinforcedStoneProps());
        REINFORCED_BRICKS = ModBlocks.register("reinforced_bricks", Block::new, ModBlocks.reinforcedStoneProps());
        REINFORCED_BRICK_TILE = ModBlocks.register("reinforced_brick_tile", Block::new, ModBlocks.reinforcedStoneProps());
        REINFORCED_BRICK_STAIRS = ModBlocks.register("reinforced_brick_stairs", props -> new StairBlock(((Block)REINFORCED_BRICKS.get()).defaultBlockState(), props), ModBlocks.reinforcedStoneProps());
        REINFORCED_BRICK_SLAB = ModBlocks.register("reinforced_brick_slab", SlabBlock::new, ModBlocks.reinforcedStoneProps());
        REINFORCED_STONE_SLAB = ModBlocks.register("reinforced_stone_slab", SlabBlock::new, ModBlocks.reinforcedStoneProps());
        REINFORCED_BRICK_PILLAR = ModBlocks.register("reinforced_brick_pillar", RotatedPillarBlock::new, ModBlocks.reinforcedStoneProps());
        REINFORCED_BRICK_WALL = ModBlocks.register("reinforced_brick_wall", WallBlock::new, ModBlocks.reinforcedStoneProps());
        COMPRESSED_STONE = ModBlocks.register("compressed_stone", Block::new, ModBlocks.reinforcedStoneProps());
        COMPRESSED_BRICKS = ModBlocks.register("compressed_bricks", Block::new, ModBlocks.reinforcedStoneProps());
        COMPRESSED_BRICK_TILE = ModBlocks.register("compressed_brick_tile", Block::new, ModBlocks.reinforcedStoneProps());
        COMPRESSED_BRICK_STAIRS = ModBlocks.register("compressed_brick_stairs", props -> new StairBlock(((Block)COMPRESSED_BRICKS.get()).defaultBlockState(), props), ModBlocks.reinforcedStoneProps());
        COMPRESSED_BRICK_SLAB = ModBlocks.register("compressed_brick_slab", SlabBlock::new, ModBlocks.reinforcedStoneProps());
        COMPRESSED_STONE_SLAB = ModBlocks.register("compressed_stone_slab", SlabBlock::new, ModBlocks.reinforcedStoneProps());
        COMPRESSED_BRICK_PILLAR = ModBlocks.register("compressed_brick_pillar", RotatedPillarBlock::new, ModBlocks.reinforcedStoneProps());
        COMPRESSED_BRICK_WALL = ModBlocks.register("compressed_brick_wall", WallBlock::new, ModBlocks.reinforcedStoneProps());
        ETCHING_ACID = ModBlocks.registerNoItem("etching_acid", FluidEtchingAcidBlock::new, ModBlocks.fluidProps());
        PLASTIC = ModBlocks.registerNoItem("plastic", props -> new LiquidBlock(ModFluids.PLASTIC.get(), props), ModBlocks.fluidProps());
        LUBRICANT = ModBlocks.registerNoItem("lubricant", props -> new LiquidBlock(ModFluids.LUBRICANT.get(), props), ModBlocks.fluidProps());
        OIL = ModBlocks.registerNoItem("oil", props -> new LiquidBlock(ModFluids.OIL.get(), props.mapColor(DyeColor.BLACK)), ModBlocks.fluidProps());
        DIESEL = ModBlocks.registerNoItem("diesel", props -> new LiquidBlock(ModFluids.DIESEL.get(), props), ModBlocks.fluidProps());
        KEROSENE = ModBlocks.registerNoItem("kerosene", props -> new LiquidBlock(ModFluids.KEROSENE.get(), props), ModBlocks.fluidProps());
        GASOLINE = ModBlocks.registerNoItem("gasoline", props -> new LiquidBlock(ModFluids.GASOLINE.get(), props), ModBlocks.fluidProps());
        LPG = ModBlocks.registerNoItem("lpg", props -> new LiquidBlock(ModFluids.LPG.get(), props), ModBlocks.fluidProps());
        MEMORY_ESSENCE = ModBlocks.registerNoItem("memory_essence", props -> new LiquidBlock(ModFluids.MEMORY_ESSENCE.get(), props), ModBlocks.fluidProps());
        YEAST_CULTURE = ModBlocks.registerNoItem("yeast_culture", props -> new LiquidBlock(ModFluids.YEAST_CULTURE.get(), props), ModBlocks.fluidProps());
        ETHANOL = ModBlocks.registerNoItem("ethanol", props -> new LiquidBlock(ModFluids.ETHANOL.get(), props), ModBlocks.fluidProps());
        VEGETABLE_OIL = ModBlocks.registerNoItem("vegetable_oil", props -> new LiquidBlock(ModFluids.VEGETABLE_OIL.get(), props), ModBlocks.fluidProps());
        BIODIESEL = ModBlocks.registerNoItem("biodiesel", props -> new LiquidBlock(ModFluids.BIODIESEL.get(), props), ModBlocks.fluidProps());
    }
}

