/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import java.util.List;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.item.DroneItem;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DroneUpgradeCrafting
extends ShapelessRecipe {
    public static final List<Predicate<ItemStack>> ITEM_PREDICATES = List.of(DroneItem::isBasicDrone, stack -> stack.getItem() == ModItems.PRINTED_CIRCUIT_BOARD.get());

    public DroneUpgradeCrafting(CraftingBookCategory category) {
        super("", category, new ItemStack((ItemLike)ModItems.DRONE.get()), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PRINTED_CIRCUIT_BOARD.get()}), Ingredient.of(PneumaticCraftTags.Items.BASIC_DRONES)}));
    }

    public boolean matches(CraftingInput container, Level level) {
        return ModCraftingHelper.allPresent(container, ITEM_PREDICATES);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        List<ItemStack> items = ModCraftingHelper.findItems(inv, ITEM_PREDICATES);
        if (items.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)Util.make((Object)new ItemStack((ItemLike)ModItems.DRONE.get()), drone -> drone.applyComponents(((ItemStack)items.getFirst()).getComponents()));
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w * h >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.DRONE_UPGRADE_CRAFTING.get();
    }
}

