/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Calendar;
import me.desht.pneumaticcraft.common.registry.ModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record AirParticleData(float alpha) implements ParticleOptions
{
    private final float alpha;
    public static final AirParticleData NORMAL = new AirParticleData(0.1f);
    public static final AirParticleData DENSE = new AirParticleData(0.3f);
    static final MapCodec<AirParticleData> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.FLOAT.fieldOf("alpha").forGetter(AirParticleData::alpha)).apply((Applicative)builder, AirParticleData::new));
    public static final StreamCodec<FriendlyByteBuf, AirParticleData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, AirParticleData::alpha, AirParticleData::new);
    private static boolean checkedDate;
    private static boolean useAlt;

    public ParticleType<?> getType() {
        return this.useAltParticles() ? ModParticleTypes.AIR_PARTICLE_2.get() : ModParticleTypes.AIR_PARTICLE.get();
    }

    public float alpha() {
        return useAlt ? this.alpha * 2.0f : this.alpha;
    }

    private boolean useAltParticles() {
        if (!checkedDate) {
            Calendar calendar = Calendar.getInstance();
            useAlt = calendar.get(2) == 3 && calendar.get(5) == 1;
            checkedDate = true;
        }
        return useAlt;
    }
}

