/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.entity.utility.SmartChestBlockEntity;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSyncSmartChest(BlockPos pos, int lastSlot, List<SmartChestBlockEntity.FilterSlot> filter) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketSyncSmartChest> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("sync_smart_chest"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSyncSmartChest> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketSyncSmartChest::pos, (StreamCodec)ByteBufCodecs.VAR_INT, PacketSyncSmartChest::lastSlot, (StreamCodec)SmartChestBlockEntity.FilterSlot.STREAM_CODEC.apply(ByteBufCodecs.list()), PacketSyncSmartChest::filter, PacketSyncSmartChest::new);

    public static PacketSyncSmartChest forBlockEntity(SmartChestBlockEntity te) {
        return new PacketSyncSmartChest(te.getBlockPos(), te.getLastSlot(), te.getFilter());
    }

    public CustomPacketPayload.Type<PacketSyncSmartChest> type() {
        return TYPE;
    }

    public static void handle(PacketSyncSmartChest message, IPayloadContext ctx) {
        PacketUtil.getBlockEntity(ctx.player(), message.pos(), SmartChestBlockEntity.class).ifPresent(te -> {
            te.setLastSlot(message.lastSlot());
            te.setFilter(message.filter());
        });
    }
}

