/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketPlayMovingSound(MovingSounds.Sound sound, MovingSoundFocus source) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketPlayMovingSound> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("play_moving_sound"));
    public static final StreamCodec<FriendlyByteBuf, PacketPlayMovingSound> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(MovingSounds.Sound.class), PacketPlayMovingSound::sound, MovingSoundFocus.STREAM_CODEC, PacketPlayMovingSound::source, PacketPlayMovingSound::new);

    public CustomPacketPayload.Type<PacketPlayMovingSound> type() {
        return TYPE;
    }

    public static void handle(PacketPlayMovingSound message, IPayloadContext ctx) {
        if (message.source() != null) {
            message.source().handle(message.sound());
        }
    }

    public record MovingSoundFocus(Either<Integer, BlockPos> entityOrPos) {
        public static final StreamCodec<FriendlyByteBuf, MovingSoundFocus> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)ByteBufCodecs.INT, (StreamCodec)BlockPos.STREAM_CODEC), MovingSoundFocus::entityOrPos, MovingSoundFocus::new);

        public static MovingSoundFocus of(Entity e) {
            return new MovingSoundFocus((Either<Integer, BlockPos>)Either.left((Object)e.getId()));
        }

        public static MovingSoundFocus of(int id) {
            return new MovingSoundFocus((Either<Integer, BlockPos>)Either.left((Object)id));
        }

        public static MovingSoundFocus of(BlockPos pos) {
            return new MovingSoundFocus((Either<Integer, BlockPos>)Either.right((Object)pos));
        }

        public static MovingSoundFocus of(BlockEntity te) {
            return new MovingSoundFocus((Either<Integer, BlockPos>)Either.right((Object)te.getBlockPos()));
        }

        public void handle(MovingSounds.Sound sound) {
            this.entityOrPos.ifLeft(id -> {
                Entity e = ClientUtils.getClientLevel().getEntity(id.intValue());
                if (e != null) {
                    MovingSounds.playMovingSound(sound, e, new Object[0]);
                }
            }).ifRight(pos -> MovingSounds.playMovingSound(sound, pos, new Object[0]));
        }
    }
}

