/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.IGPSToolSync;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketChangeGPSToolCoordinate(BlockPos pos, InteractionHand hand, String variable, int index, boolean activeIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketChangeGPSToolCoordinate> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("change_gps_tool_coord"));
    public static final StreamCodec<FriendlyByteBuf, PacketChangeGPSToolCoordinate> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketChangeGPSToolCoordinate::pos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), PacketChangeGPSToolCoordinate::hand, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketChangeGPSToolCoordinate::variable, (StreamCodec)ByteBufCodecs.VAR_INT, PacketChangeGPSToolCoordinate::index, (StreamCodec)ByteBufCodecs.BOOL, PacketChangeGPSToolCoordinate::activeIndex, PacketChangeGPSToolCoordinate::new);

    public CustomPacketPayload.Type<PacketChangeGPSToolCoordinate> type() {
        return TYPE;
    }

    public static void handle(PacketChangeGPSToolCoordinate message, IPayloadContext ctx) {
        ItemStack stack = ctx.player().getItemInHand(message.hand);
        Item item = stack.getItem();
        if (item instanceof IGPSToolSync) {
            IGPSToolSync sync = (IGPSToolSync)item;
            sync.syncFromClient(ctx.player(), stack, message.index, message.pos, message.variable, message.activeIndex);
        }
    }
}

