/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.MinigunMagazineMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.item.minigun.StandardGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.minigun.MinigunPlayerTracker;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketMinigunStop;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class MinigunItem
extends PressurizableItem
implements IChargeableContainerProvider,
IFOVModifierItem,
IInventoryItem,
IShiftScrollable {
    public static final int MAGAZINE_SIZE = 4;
    public static final int NOT_LOCKED = -1;

    public MinigunItem() {
        super(ModItems.toolProps().component(ModDataComponents.MINIGUN_LOCKED_SLOT, (Object)-1), 30000, 3000);
    }

    @Nonnull
    public MagazineHandler getMagazine(ItemStack stack) {
        Validate.isTrue((boolean)(stack.getItem() instanceof MinigunItem));
        return new MagazineHandler(stack);
    }

    public void onEquipmentChange(ServerPlayer player, ItemStack stack, boolean equipping) {
        if (equipping) {
            stack.set(ModDataComponents.OWNER_ENTITY_ID, (Object)player.getId());
        } else {
            stack.remove(ModDataComponents.OWNER_ENTITY_ID);
            Minigun minigun = this.getMinigun(stack, (Player)player);
            if (minigun.getMinigunSpeed() > 0.0f || minigun.isMinigunActivated()) {
                NetworkHandler.sendToPlayer(new PacketMinigunStop(stack), player);
            }
            minigun.setMinigunSpeed(0.0f);
            minigun.setMinigunActivated(false);
            minigun.setMinigunTriggerTimeOut(0);
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean currentItem) {
        super.inventoryTick(stack, world, entity, slot, currentItem);
        Player player = (Player)entity;
        Minigun minigun = null;
        if (currentItem) {
            minigun = this.getMinigun(stack, player);
            minigun.tick(player.getX(), player.getY(), player.getZ());
        }
        if (!world.isClientSide && slot >= 0 && slot <= 8) {
            if (minigun == null) {
                minigun = this.getMinigun(stack, player);
            }
            this.handleAmmoRepair(stack, world, minigun);
        }
    }

    private void handleAmmoRepair(ItemStack stack, Level world, Minigun minigun) {
        if (minigun.getPlayer().containerMenu instanceof MinigunMagazineMenu) {
            return;
        }
        int itemLife = minigun.getUpgrades(ModUpgrades.ITEM_LIFE.get());
        if (itemLife > 0) {
            MagazineHandler handler = this.getMagazine(stack);
            boolean repaired = false;
            float pressure = minigun.getAirCapability().orElseThrow(RuntimeException::new).getPressure();
            if (world.getGameTime() % (200L - (long)itemLife * 35L) == 0L) {
                for (int i = 0; i < handler.getSlots() && pressure > 0.25f; ++i) {
                    ItemStack ammo = handler.getStackInSlot(i);
                    if (!(ammo.getItem() instanceof AbstractGunAmmoItem) || ammo.getDamageValue() <= 0) continue;
                    ammo.setDamageValue(ammo.getDamageValue() - 1);
                    if (!minigun.getPlayer().isCreative()) {
                        minigun.getAirCapability().ifPresent(h -> h.addAir(-(100 * itemLife)));
                    }
                    pressure = minigun.getAirCapability().orElseThrow(RuntimeException::new).getPressure();
                    repaired = true;
                }
            }
            if (repaired) {
                handler.save();
            }
        }
    }

    private Minigun getMinigun(ItemStack stack, Player player, ItemStack ammo) {
        boolean isCreative = UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.CREATIVE.get()) > 0;
        return new ItemMinigunImpl(player, stack).setAmmoStack(ammo).setAirHandler((IAirHandler)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM), isCreative ? 0 : 20).setWorld(player.level()).setInfiniteAmmo(isCreative);
    }

    @NotNull
    public Minigun getMinigun(ItemStack stack, Player player) {
        return this.getMinigun(stack, player, this.getMagazine(stack).getAmmo());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, final InteractionHand handIn) {
        final ItemStack stack = player.getItemInHand(handIn);
        if (player.isShiftKeyDown()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (stack.getCount() == 1) {
                    sp.openMenu(new MenuProvider(){

                        public Component getDisplayName() {
                            return stack.getHoverName();
                        }

                        public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                            return new MinigunMagazineMenu(i, playerInventory, handIn);
                        }
                    }, buf -> AbstractPneumaticCraftMenu.putHand((FriendlyByteBuf)buf, handIn));
                }
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        MagazineHandler magazineHandler = this.getMagazine(stack);
        ItemStack ammo = magazineHandler.getAmmo();
        if (!ammo.isEmpty()) {
            player.startUsingItem(handIn);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        if (player.level().isClientSide) {
            player.playSound(SoundEvents.COMPARATOR_CLICK, 1.0f, 1.0f);
            player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.minigun.outOfAmmo"), true);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public void onUseTick(Level pLevel, LivingEntity entity, ItemStack stack, int pRemainingUseDuration) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MagazineHandler magazineHandler = this.getMagazine(stack);
        ItemStack ammo = magazineHandler.getAmmo();
        if (!ammo.isEmpty()) {
            boolean usedUpAmmo;
            int prevDamage = ammo.getDamageValue();
            Minigun minigun = this.getMinigun(stack, player, ammo);
            boolean bl = usedUpAmmo = minigun.tryFireMinigun(null) && minigun.getUpgrades(ModUpgrades.ITEM_LIFE.get()) == 0;
            if (usedUpAmmo) {
                ammo.setCount(0);
            }
            if (usedUpAmmo || ammo.getDamageValue() != prevDamage) {
                magazineHandler.save();
            }
        } else {
            if (player.level().isClientSide) {
                player.playSound(SoundEvents.COMPARATOR_CLICK, 1.0f, 1.0f);
                player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.minigun.outOfAmmo"), true);
            }
            player.releaseUsingItem();
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        return super.finishUsingItem(stack, worldIn, entityLiving);
    }

    @Override
    public float getFOVModifier(ItemStack stack, Player player, EquipmentSlot slot) {
        Minigun minigun = this.getMinigun(stack, player);
        int trackers = minigun.getUpgrades(ModUpgrades.ENTITY_TRACKER.get());
        if (!minigun.isMinigunActivated() || trackers == 0) {
            return 1.0f;
        }
        return 1.0f - (float)trackers * minigun.getMinigunSpeed() / 2.0f;
    }

    @Override
    public void getStacksInItem(ItemStack stack, List<ItemStack> curStacks) {
        MagazineHandler handler = this.getMagazine(stack);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            curStacks.add(handler.getStackInSlot(i));
        }
    }

    @Override
    public Component getInventoryHeader() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.loaded", new Object[0]).withStyle(ChatFormatting.GREEN);
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, ModMenuTypes.CHARGING_MINIGUN.get());
    }

    @Override
    public void onShiftScrolled(Player player, boolean forward, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof MinigunItem) {
            MagazineHandler handler = this.getMagazine(stack);
            int newSlot = Math.max(0, MinigunItem.getLockedSlot(stack));
            for (int i = 0; i < 3; ++i) {
                if ((newSlot += forward ? 1 : -1) < 0) {
                    newSlot = 3;
                } else if (newSlot >= 4) {
                    newSlot = 0;
                }
                ItemStack ammoStack = handler.getStackInSlot(newSlot);
                Item item = ammoStack.getItem();
                if (!(item instanceof AbstractGunAmmoItem)) continue;
                AbstractGunAmmoItem ammo = (AbstractGunAmmoItem)item;
                stack.set(ModDataComponents.MINIGUN_LOCKED_SLOT, (Object)newSlot);
                if (player.level().isClientSide) continue;
                if (ammo instanceof StandardGunAmmoItem) {
                    ItemStack potion = StandardGunAmmoItem.getPotionStack(ammoStack);
                    if (!potion.isEmpty()) {
                        int col = ((PotionContents)potion.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor();
                        player.displayClientMessage((Component)potion.getDisplayName().copy().withStyle(Style.EMPTY.withColor(col)), true);
                    } else {
                        player.displayClientMessage((Component)Component.literal((String)" "), true);
                    }
                } else {
                    player.displayClientMessage((Component)Component.literal((String)" "), true);
                }
                return;
            }
        }
    }

    public static int getLockedSlot(ItemStack stack) {
        int slot = (Integer)stack.getOrDefault(ModDataComponents.MINIGUN_LOCKED_SLOT, (Object)-1);
        return slot >= 0 && slot < 4 ? slot : -1;
    }

    @Override
    public Optional<TagKey<Item>> getUpgradeBlacklistTag() {
        return Optional.of(PneumaticCraftTags.Items.MINIGUN_UPGRADE_BLACKLIST);
    }

    public static class MagazineHandler
    extends BaseItemStackHandler {
        private final ItemStack gunStack;

        MagazineHandler(ItemStack gunStack) {
            super(4);
            this.gunStack = gunStack;
            this.loadContainerContents((ItemContainerContents)gunStack.getOrDefault(ModDataComponents.MINGUN_MAGAZINE, (Object)ItemContainerContents.EMPTY));
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || itemStack.getItem() instanceof AbstractGunAmmoItem;
        }

        public ItemStack getAmmo() {
            int slot = MinigunItem.getLockedSlot(this.gunStack);
            if (slot >= 0 && slot < this.getSlots()) {
                return this.getStackInSlot(slot);
            }
            for (int i = 0; i < 4; ++i) {
                if (!(this.getStackInSlot(i).getItem() instanceof AbstractGunAmmoItem)) continue;
                return this.getStackInSlot(i);
            }
            return ItemStack.EMPTY;
        }

        public void save() {
            this.gunStack.set(ModDataComponents.MINGUN_MAGAZINE, (Object)this.toContainerContents());
        }
    }

    private static class ItemMinigunImpl
    extends Minigun {
        private final ItemStack minigunStack;
        private final MinigunPlayerTracker tracker;

        ItemMinigunImpl(Player player, ItemStack stack) {
            super(player, false);
            this.tracker = MinigunPlayerTracker.getInstance(player);
            this.minigunStack = stack;
        }

        @Override
        public boolean isMinigunActivated() {
            return this.tracker.isActivated();
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            this.tracker.setActivated(activated);
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!ammo.isEmpty()) {
                this.tracker.setAmmoColor(this.getAmmoColor(ammo));
            } else {
                this.tracker.setAmmoColor(0);
            }
        }

        @Override
        public int getAmmoColor() {
            return this.tracker.getAmmoColor();
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            if (!this.player.level().isClientSide) {
                NetworkHandler.sendToAllTracking(new PacketPlaySound(soundName, SoundSource.PLAYERS, this.player.blockPosition(), volume, pitch, false), this.player.level(), this.player.blockPosition());
            }
        }

        @Override
        public Vec3 getMuzzlePosition() {
            float pitch = this.player.getXRot() * ((float)Math.PI / 180);
            float yaw = -(this.player.getYRot() + 13.5f) * ((float)Math.PI / 180);
            float f2 = Mth.cos((float)yaw);
            float f3 = Mth.sin((float)yaw);
            float f4 = Mth.cos((float)pitch);
            float f5 = Mth.sin((float)pitch);
            Vec3 lookVec = new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
            return this.player.getEyePosition(0.0f).add(lookVec.scale((double)2.2f)).subtract(0.0, 0.3, 0.0);
        }

        @Override
        public Vec3 getLookAngle() {
            return this.player.getLookAngle();
        }

        @Override
        public float getParticleScale() {
            return this.player.getId() == ClientUtils.getClientPlayer().getId() && ClientUtils.isFirstPersonCamera() ? 0.4f : 1.0f;
        }

        @Override
        public float getMinigunSpeed() {
            return this.tracker.getRotationSpeed();
        }

        @Override
        public void setMinigunSpeed(float minigunSpeed) {
            this.tracker.setRotationSpeed(minigunSpeed);
        }

        @Override
        public int getMinigunTriggerTimeOut() {
            return this.tracker.getTriggerTimeout();
        }

        @Override
        public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
            this.tracker.setTriggerTimeout(minigunTriggerTimeOut);
        }

        @Override
        public float getMinigunRotation() {
            return this.tracker.getBarrelRotation();
        }

        @Override
        public void setMinigunRotation(float minigunRotation) {
            this.tracker.setBarrelRotation(minigunRotation);
        }

        @Override
        public float getOldMinigunRotation() {
            return this.tracker.getPrevBarrelRotation();
        }

        @Override
        public void setOldMinigunRotation(float oldMinigunRotation) {
            this.tracker.setPrevBarrelRotation(oldMinigunRotation);
        }

        @Override
        public int getUpgrades(PNCUpgrade upgrade) {
            return Math.min(ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.minigunStack.getItem(), upgrade), UpgradableItemUtils.getUpgradeCount(this.minigunStack, upgrade));
        }
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLivingAttack(LivingIncomingDamageEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                MinigunItem minigunItem;
                ItemStack stack;
                Item item;
                Player player = (Player)livingEntity;
                if (event.getSource().getEntity() != null && event.getSource().is(DamageTypes.THORNS) && (item = (stack = player.getMainHandItem()).getItem()) instanceof MinigunItem && (minigunItem = (MinigunItem)item).getMinigun(stack, player).getMinigunSpeed() >= 0.4f) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

