/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.Validate;

public class TagFilterItem
extends Item
implements IFilteringItem {
    public TagFilterItem() {
        super(ModItems.defaultProps().stacksTo(1).component(ModDataComponents.TAG_FILTER_KEYS, List.of()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (context.registries() != null) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.tag_filter.header", new Object[0]).withStyle(ChatFormatting.YELLOW));
            for (TagKey<Item> key : TagFilterItem.getConfiguredTagList(stack)) {
                tooltip.add((Component)Symbols.bullet().append(key.location().toString()).withStyle(ChatFormatting.GOLD));
            }
        }
    }

    public static Set<TagKey<Item>> getConfiguredTagList(ItemStack stack) {
        List tagIds = (List)stack.get(ModDataComponents.TAG_FILTER_KEYS);
        return tagIds != null && !tagIds.isEmpty() ? tagIds.stream().map(r -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)r)).collect(Collectors.toSet()) : Set.of();
    }

    public static void setConfiguredTagList(ItemStack stack, Set<TagKey<Item>> tags) {
        if (tags.isEmpty()) {
            stack.remove(ModDataComponents.TAG_FILTER_KEYS);
        } else {
            stack.set(ModDataComponents.TAG_FILTER_KEYS, tags.stream().map(TagKey::location).toList());
        }
    }

    @Override
    public boolean matchFilter(ItemStack filterStack, ItemStack stack) {
        Validate.isTrue((boolean)(filterStack.getItem() instanceof TagFilterItem), (String)"filtering itemstack is not a tag filter!", (Object[])new Object[0]);
        Set<TagKey<Item>> tags = TagFilterItem.getConfiguredTagList(filterStack);
        return !Sets.intersection(tags, PneumaticCraftUtils.itemTags(stack.getItem())).isEmpty();
    }
}

