/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.desht.pneumaticcraft.api.crafting.recipe.FuelQualityRecipe;
import me.desht.pneumaticcraft.api.fuel.IFuelRegistry;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public enum FuelRegistry implements IFuelRegistry
{
    INSTANCE;

    private static final FuelEntry MISSING_FUEL_ENTRY;
    private final Map<Fluid, FuelEntry> cachedFuels = new ConcurrentHashMap<Fluid, FuelEntry>();
    private final Map<Fluid, FuelEntry> hotFluids = new ConcurrentHashMap<Fluid, FuelEntry>();

    public static FuelRegistry getInstance() {
        return INSTANCE;
    }

    public void registerHotFluid(Fluid fluid, int mLPerBucket, float burnRateMultiplier) {
        this.hotFluids.put(fluid, new FuelEntry(mLPerBucket, burnRateMultiplier));
    }

    @Override
    public int getFuelValue(Level level, Fluid fluid) {
        return this.cachedFuels.computeIfAbsent((Fluid)fluid, (Function<Fluid, FuelEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getFuelValue$0(net.minecraft.world.level.Level net.minecraft.world.level.material.Fluid net.minecraft.world.level.material.Fluid ), (Lnet/minecraft/world/level/material/Fluid;)Lme/desht/pneumaticcraft/common/fluid/FuelRegistry$FuelEntry;)((FuelRegistry)this, (Level)level, (Fluid)fluid)).mLperBucket;
    }

    @Override
    public float getBurnRateMultiplier(Level world, Fluid fluid) {
        return this.cachedFuels.computeIfAbsent((Fluid)fluid, (Function<Fluid, FuelEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBurnRateMultiplier$1(net.minecraft.world.level.Level net.minecraft.world.level.material.Fluid net.minecraft.world.level.material.Fluid ), (Lnet/minecraft/world/level/material/Fluid;)Lme/desht/pneumaticcraft/common/fluid/FuelRegistry$FuelEntry;)((FuelRegistry)this, (Level)world, (Fluid)fluid)).burnRateMultiplier;
    }

    @Override
    public Collection<Fluid> registeredFuels(Level level) {
        HashSet<Fluid> res = new HashSet<Fluid>(this.hotFluids.keySet());
        for (FuelQualityRecipe recipe : ModRecipeTypes.FUEL_QUALITY.get().allRecipes(level)) {
            res.addAll(Arrays.stream(recipe.getFuel().getStacks()).map(FluidStack::getFluid).filter(f -> f.isSource(f.defaultFluidState())).toList());
        }
        return res;
    }

    public void clearCachedFuelFluids() {
        this.cachedFuels.clear();
    }

    private FuelEntry findEntry(Level level, Fluid fluid) {
        FuelEntry fe = this.hotFluids.get(fluid);
        if (fe != null) {
            return fe;
        }
        for (FuelQualityRecipe recipe : ModRecipeTypes.FUEL_QUALITY.get().allRecipes(level)) {
            if (!recipe.matchesFluid(fluid)) continue;
            return new FuelEntry(recipe.getAirPerBucket(), recipe.getBurnRate());
        }
        return MISSING_FUEL_ENTRY;
    }

    private /* synthetic */ FuelEntry lambda$getBurnRateMultiplier$1(Level world, Fluid fluid, Fluid k) {
        return this.findEntry(world, fluid);
    }

    private /* synthetic */ FuelEntry lambda$getFuelValue$0(Level level, Fluid fluid, Fluid k) {
        return this.findEntry(level, fluid);
    }

    static {
        MISSING_FUEL_ENTRY = new FuelEntry(0, 1.0f);
    }

    private record FuelEntry(int mLperBucket, float burnRateMultiplier) {
    }
}

