/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.drone;

import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammableControllerBlockEntity;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ProgrammableControllerEntity
extends AbstractDroneEntity {
    private ProgrammableControllerBlockEntity controller;
    private float propSpeed = 0.0f;

    public ProgrammableControllerEntity(EntityType<ProgrammableControllerEntity> type, Level world) {
        super(type, world);
        this.blocksBuilding = false;
    }

    public void setController(ProgrammableControllerBlockEntity controller) {
        this.controller = controller;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void tick() {
        if (this.level().isClientSide && this.controller != null) {
            BlockEntity te = this.level().getBlockEntity(this.controller.getBlockPos());
            if (te != this.controller) {
                this.discard();
            } else {
                this.propSpeed = this.controller.isIdle ? Math.max(0.0f, this.propSpeed - 0.04f) : Math.min(1.0f, this.propSpeed + 0.04f);
                this.oldPropRotation = this.propRotation;
                this.propRotation += this.propSpeed;
            }
        }
    }

    @Override
    public double getLaserOffsetY() {
        return 0.45;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    @Override
    public BlockPos getDugBlock() {
        return this.controller == null ? null : this.controller.getDugPosition();
    }

    @Override
    public ItemStack getDroneHeldItem() {
        return this.controller == null ? ItemStack.EMPTY : this.controller.heldItem;
    }

    @Override
    public BlockPos getTargetedBlock() {
        return this.controller.getTargetPos();
    }

    @Override
    public Component getOwnerName() {
        return Component.literal((String)this.controller.ownerNameClient);
    }

    @Override
    public String getLabel() {
        return this.controller.label == null ? "<?>" : this.controller.label;
    }

    @Override
    public boolean isTeleportRangeLimited() {
        return true;
    }

    public BlockPos getControllerPos() {
        return this.controller.getBlockPos();
    }

    public ProgrammableControllerBlockEntity getController() {
        return this.controller;
    }
}

