/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.drone;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.IPathfindHandler;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.api.pressure.PressureHelper;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.common.block.DroneRedstoneEmitterBlock;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.drone.DroneRedstoneEmitterBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.BasicAirHandler;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.debug.DroneDebugger;
import me.desht.pneumaticcraft.common.drone.DroneMovementController;
import me.desht.pneumaticcraft.common.drone.DroneRegistry;
import me.desht.pneumaticcraft.common.drone.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.LogisticsManager;
import me.desht.pneumaticcraft.common.drone.ProgWidgetUtils;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.ai.DroneGoToChargingStation;
import me.desht.pneumaticcraft.common.drone.ai.DroneGoToOwner;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetGoToLocation;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLogistics;
import me.desht.pneumaticcraft.common.drone.progwidgets.SavedDroneProgram;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.item.DroneItem;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.DronePacket;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketShowWireframe;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneProgWidgets;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.thirdparty.RadiationSourceCheck;
import me.desht.pneumaticcraft.common.upgrades.IUpgradeHolder;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.SavedUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.upgrades.UpgradeCache;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.chunkloading.DynamicChunkLoader;
import me.desht.pneumaticcraft.common.util.chunkloading.PlayerLogoutTracker;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.mixin.accessors.EntityAccess;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class DroneEntity
extends AbstractDroneEntity
implements IManoMeasurable,
IPneumaticWrenchable,
IEntityWithComplexSpawn,
IHackableEntity<DroneEntity>,
IDroneBase,
FlyingAnimal,
IUpgradeHolder {
    private static final Codec<Map<BlockPos, BlockState>> DISPLACED_LIQUIDS_CODEC = Codec.unboundedMap((Codec)BlockPos.CODEC, (Codec)BlockState.CODEC);
    private static final float LASER_EXTEND_SPEED = 0.05f;
    private static final EntityDataAccessor<Boolean> ACCELERATING = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> PRESSURE = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<String> PROGRAM_KEY = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<BlockPos> DUG_POS = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Boolean> GOING_TO_OWNER = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DRONE_COLOR = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> MINIGUN_ACTIVE = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_MINIGUN = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> AMMO = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> LABEL = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> ACTIVE_WIDGET = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final MutableComponent DEF_DRONE_NAME = Component.literal((String)"Drone");
    private static final HashMap<Component, Integer> LASER_COLOR_MAP = new HashMap();
    private final EntityDroneItemHandler droneItemHandler = new EntityDroneItemHandler(this);
    private final FluidTank fluidTank = new FluidTank(Integer.MAX_VALUE);
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final ItemStackHandler upgradeInventory = new ItemStackHandler(9);
    private final UpgradeCache upgradeCache = new UpgradeCache(this);
    private BasicAirHandler airHandler;
    private final Map<Direction, Integer> emittingRedstoneValues = new EnumMap<Direction, Integer>(Direction.class);
    private float propSpeed;
    private ProgressingLine targetLine;
    private ProgressingLine oldTargetLine;
    public List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private DroneFakePlayer fakePlayer;
    public Component ownerName = DEF_DRONE_NAME;
    private UUID ownerUUID;
    private final DroneGoToChargingStation chargeAI;
    private DroneGoToOwner gotoOwnerAI;
    private final DroneAIManager aiManager = new DroneAIManager(this);
    private double droneSpeed;
    private int healingInterval;
    private int suffocationCounter = 40;
    private boolean isSuffocating;
    private boolean disabledByHacking;
    private boolean standby;
    private boolean allowStandbyPickup;
    private Minigun minigun;
    private int attackCount;
    private BlockPos deployPos;
    private BlockPos digSourcePos;
    private final DroneDebugger debugger = new DroneDebugger(this);
    private int securityUpgradeCount;
    private final Map<BlockPos, BlockState> displacedLiquids = new HashMap<BlockPos, BlockState>();
    private LogisticsManager logisticsManager;
    private ItemEnchantments stackEnchants = ItemEnchantments.EMPTY;
    private boolean carriedEntityAIdisabled;
    private UUID wrenchedBy = null;
    private ChunkPos prevChunkPos = null;
    private DynamicChunkLoader chunkLoader;
    protected Consumer<SemiblockEvent> semiblockEventConsumer = null;
    private static final Set<Block> MC181565_BLOCKS;

    public DroneEntity(EntityType<? extends DroneEntity> type, Level world) {
        super(type, world);
        this.moveControl = new DroneMovementController(this);
        this.chargeAI = new DroneGoToChargingStation(this);
        this.goalSelector.addGoal(1, (Goal)this.chargeAI);
    }

    protected DroneEntity(EntityType<? extends DroneEntity> type, Level world, Player player) {
        this(type, world);
        if (player != null) {
            this.ownerUUID = player.getGameProfile().getId();
            this.ownerName = player.getName();
        } else {
            this.ownerUUID = this.getUUID();
            this.ownerName = DEF_DRONE_NAME;
        }
    }

    public DroneEntity(Level world, Player player) {
        this(ModEntityTypes.DRONE.get(), world, player);
    }

    protected void registerSemiblockEventListener() {
        if (this.semiblockEventConsumer == null) {
            if (this.progWidgets.stream().anyMatch(w -> w instanceof ProgWidgetLogistics)) {
                this.semiblockEventConsumer = this::onSemiblockEvent;
                NeoForge.EVENT_BUS.addListener(this.semiblockEventConsumer);
            }
        } else {
            throw new IllegalStateException("already registered a semiblock event listener!");
        }
    }

    protected void unregisterSemiblockEventListener() {
        if (this.semiblockEventConsumer != null) {
            NeoForge.EVENT_BUS.unregister(this.semiblockEventConsumer);
        }
    }

    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().isClientSide && event.getWorld() == this.getCommandSenderWorld() && event.getSemiblock() instanceof AbstractLogisticsFrameEntity) {
            this.logisticsManager = null;
        }
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        if (!this.level().isClientSide) {
            this.unregisterSemiblockEventListener();
        }
    }

    protected PathNavigation createNavigation(Level worldIn) {
        EntityPathNavigateDrone nav = new EntityPathNavigateDrone(this, worldIn);
        nav.setCanOpenDoors(false);
        nav.setCanFloat(true);
        nav.setCanPassDoors(true);
        return nav;
    }

    public void readFromItemStack(ItemStack droneStack) {
        Validate.isTrue((boolean)(droneStack.getItem() instanceof DroneItem));
        DroneItem droneItem = (DroneItem)droneStack.getItem();
        ((SavedUpgrades)droneStack.getOrDefault(ModDataComponents.ITEM_UPGRADES, (Object)SavedUpgrades.EMPTY)).fillItemHandler(this.upgradeInventory);
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)droneStack));
        enchantments.keySet().removeIf(ench -> !droneStack.isPrimaryItemFor(ench));
        this.stackEnchants = enchantments.toImmutable();
        if (droneItem.canProgram(droneStack)) {
            this.progWidgets = SavedDroneProgram.loadProgWidgets(droneStack);
            ProgWidgetUtils.updatePuzzleConnections(this.progWidgets);
        }
        this.setDroneColor(droneItem.getDroneColor(droneStack).getId());
        this.fluidTank.setCapacity(16000 * (1 + this.getUpgrades(ModUpgrades.INVENTORY.get())));
        FluidStack storedFluid = ((SimpleFluidContent)droneStack.getOrDefault(ModDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy();
        this.fluidTank.setFluid(storedFluid);
        this.droneItemHandler.setUseableSlots(1 + this.getUpgrades(ModUpgrades.INVENTORY.get()));
        int air = ((IAirHandlerItem)droneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM)).getAir();
        this.getAirHandler().addAir(air);
        if (droneStack.has(DataComponents.CUSTOM_NAME)) {
            this.setCustomName((Component)droneStack.get(DataComponents.CUSTOM_NAME));
        }
    }

    private void writeToItemStack(ItemStack droneStack) {
        Item item = droneStack.getItem();
        if (item instanceof DroneItem) {
            DroneItem droneItem = (DroneItem)item;
            if (droneItem.canProgram(droneStack)) {
                SavedDroneProgram.writeToItem(droneStack, this.progWidgets);
            }
            droneStack.set(ModDataComponents.DRONE_COLOR, (Object)this.getDroneColor());
            if (!this.fluidTank.isEmpty()) {
                droneStack.set(ModDataComponents.STORED_FLUID, (Object)SimpleFluidContent.copyOf((FluidStack)this.fluidTank.getFluid()));
            }
            UpgradableItemUtils.setUpgrades(droneStack, (IItemHandler)this.upgradeInventory);
            EnchantmentHelper.setEnchantments((ItemStack)droneStack, (ItemEnchantments)this.stackEnchants);
            ((IAirHandlerItem)droneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM)).addAir(this.getAirHandler().getAir());
            if (this.hasCustomName()) {
                droneStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PRESSURE, (Object)Float.valueOf(0.0f));
        builder.define(ACCELERATING, (Object)false);
        builder.define(PROGRAM_KEY, (Object)"");
        builder.define(DUG_POS, (Object)BlockPos.ZERO);
        builder.define(GOING_TO_OWNER, (Object)false);
        builder.define(DRONE_COLOR, (Object)DyeColor.BLACK.getId());
        builder.define(MINIGUN_ACTIVE, (Object)false);
        builder.define(HAS_MINIGUN, (Object)false);
        builder.define(AMMO, (Object)-256);
        builder.define(LABEL, (Object)"");
        builder.define(ACTIVE_WIDGET, (Object)0);
        builder.define(TARGET_POS, (Object)BlockPos.ZERO);
        builder.define(HELD_ITEM, (Object)ItemStack.EMPTY);
        builder.define(TARGET_ID, (Object)0);
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 75.0);
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeUUID(Objects.requireNonNullElse(this.ownerUUID, this.getUUID()));
        ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.ownerName);
        buffer.writeVarInt(this.getUpgrades(ModUpgrades.SECURITY.get()));
    }

    public void readSpawnData(RegistryFriendlyByteBuf buffer) {
        this.ownerUUID = buffer.readUUID();
        this.ownerName = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer);
        this.securityUpgradeCount = buffer.readVarInt();
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    protected float getSoundVolume() {
        return 0.2f;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_184601_1_) {
        return (SoundEvent)ModSounds.DRONE_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.DRONE_DEATH.get();
    }

    public void tick() {
        boolean enabled;
        if (this.tickCount == 1) {
            this.onFirstTick();
        }
        Level level = this.level();
        boolean bl = enabled = !this.disabledByHacking && this.getAirHandler().getPressure() > 0.01f;
        if (!level.isClientSide) {
            Path path;
            this.entityData.set(PRESSURE, (Object)Float.valueOf((float)((int)(this.getAirHandler().getPressure() * 10.0f)) / 10.0f));
            this.setAccelerating(!this.standby && enabled);
            if (this.isAccelerating()) {
                this.fallDistance = 0.0f;
            }
            if (this.healingInterval != 0 && this.getHealth() < this.getMaxHealth() && this.tickCount % this.healingInterval == 0) {
                this.heal(1.0f);
                this.getAirHandler().addAir(-this.healingInterval);
            }
            if (!this.isSuffocating) {
                this.suffocationCounter = 40;
            }
            this.isSuffocating = false;
            if (this.chunkLoader != null && PlayerLogoutTracker.INSTANCE.isPlayerLoggedOutTooLong(level.getServer(), this.getOwnerUUID())) {
                this.chunkLoader.unloadAll((ServerLevel)level);
            }
            if ((path = this.getNavigation().getPath()) != null) {
                Node target = path.getEndNode();
                if (target != null) {
                    this.setTargetedBlock(new BlockPos(target.x, target.y, target.z));
                } else {
                    this.setTargetedBlock(null);
                }
            } else {
                this.setTargetedBlock(null);
            }
            if (level.getGameTime() % 20L == 0L) {
                this.debugger.updateDebuggingPlayers();
            }
            this.tickFakePlayer();
            if (this.securityUpgradeCount > 1 && this.getHealth() > 0.0f) {
                this.handleFluidDisplacement();
            }
            this.getAirHandler().addAir(-5 * this.getUpgrades(ModUpgrades.CHUNKLOADER.get()));
            this.handleDebugTick();
        } else {
            this.oldLaserExtension = this.laserExtension;
            this.laserExtension = this.getActiveProgramKey().getPath().equals("dig") ? Math.min(1.0f, this.laserExtension + 0.05f) : Math.max(0.0f, this.laserExtension - 0.05f);
            if (this.isAccelerating() && level.random.nextBoolean()) {
                int x = (int)Math.floor(this.getX());
                int y = (int)Math.floor(this.getY() - 1.0);
                int z = (int)Math.floor(this.getZ());
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = null;
                int i = 0;
                while (i < 3 && (state = level.getBlockState(pos)).isAir()) {
                    ++i;
                    --y;
                }
                if (!state.isAir()) {
                    Vec3 vec = new Vec3(this.getY() - (double)y, 0.0, 0.0);
                    vec = vec.yRot((float)((double)this.random.nextFloat() * Math.PI * 2.0));
                    BlockParticleOption data = new BlockParticleOption(ParticleTypes.BLOCK, state);
                    level.addParticle((ParticleOptions)data, this.getX() + vec.x, (double)(y + 1), this.getZ() + vec.z, vec.x, 0.0, vec.z);
                }
            }
        }
        if (this.isAccelerating()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.3));
            this.propSpeed = Math.min(1.0f, this.propSpeed + 0.04f);
            if (!level.isClientSide) {
                this.getAirHandler().addAir(-1);
            }
        } else {
            this.propSpeed = Math.max(0.0f, this.propSpeed - 0.04f);
        }
        this.oldPropRotation = this.propRotation;
        this.propRotation += this.propSpeed;
        super.tick();
        if (this.hasMinigun()) {
            this.getMinigun().setAttackTarget(this.getTarget()).tick(this.getX(), this.getY(), this.getZ());
        }
        if (!level.isClientSide && this.isAlive()) {
            if (enabled) {
                DroneAIManager prevActive = this.getActiveAIManager();
                this.aiManager.onUpdateTasks();
                if (this.getActiveAIManager() != prevActive) {
                    this.getDebugger().getDebuggingPlayers().forEach(p -> NetworkHandler.sendToPlayer(PacketSyncDroneProgWidgets.create(this), p));
                }
            }
            this.handleRedstoneEmission();
        }
    }

    @Override
    public Vec3 getFakePlayerPos() {
        if (this.getDugBlock() != null && this.digSourcePos != null) {
            return Vec3.atCenterOf((Vec3i)this.digSourcePos);
        }
        return this.getDronePos();
    }

    private void tickFakePlayer() {
        FakePlayer fp = this.getFakePlayer();
        fp.setPos(this.position());
        fp.tick();
        if (this.getDugBlock() != null) {
            fp.lookAt(EntityAnchorArgument.Anchor.EYES, Vec3.atCenterOf((Vec3i)this.getDugBlock()));
        }
        if (this.isAlive()) {
            for (int i = 0; i < 4; ++i) {
                fp.gameMode.tick();
            }
        }
    }

    private void handleDebugTick() {
        Path path;
        Collection<ServerPlayer> debuggingPlayers = this.getDebugger().getDebuggingPlayers();
        if (!((Boolean)ConfigHelper.common().drones.droneDebuggerPathParticles.get()).booleanValue() || debuggingPlayers.isEmpty()) {
            return;
        }
        PathNavigation navi = this.getNavigation();
        if (this.level() instanceof ServerLevel && this.level().getGameTime() % 10L == 0L && (path = navi.getPath()) != null) {
            for (int i = path.getNextNodeIndex(); i < path.getNodeCount(); ++i) {
                BlockPos pos = path.getNode(i).asBlockPos();
                BlockPos nextPos = i + 1 != path.getNodeCount() ? path.getNode(i + 1).asBlockPos() : pos;
                BlockPos endPos = nextPos.subtract((Vec3i)pos);
                DroneEntity.spawnDebugParticle(debuggingPlayers, ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
                DroneEntity.spawnDebugParticle(debuggingPlayers, ParticleTypes.END_ROD, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, endPos.getX(), endPos.getY(), endPos.getZ(), 0.1);
            }
            BlockPos pos = navi.getTargetPos();
            if (pos != null && this.getDronePos().distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) > 1.0) {
                DroneEntity.spawnDebugParticle(debuggingPlayers, ParticleTypes.HEART, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static <T extends ParticleOptions> void spawnDebugParticle(Collection<ServerPlayer> players, T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(type, false, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
        players.forEach(player -> player.connection.send((Packet)packet));
    }

    private void onFirstTick() {
        if (!this.level().isClientSide) {
            this.registerSemiblockEventListener();
            double newDroneSpeed = 0.15f + (float)Math.min(10, this.getUpgrades(ModUpgrades.SPEED.get())) * 0.015f;
            if (this.getUpgrades(ModUpgrades.ARMOR.get()) > 6) {
                newDroneSpeed -= (double)(0.01f * (float)(this.getUpgrades(ModUpgrades.ARMOR.get()) - 6));
            }
            this.setDroneSpeed(newDroneSpeed);
            this.healingInterval = this.getUpgrades(ModUpgrades.ITEM_LIFE.get()) > 0 ? 100 / this.getUpgrades(ModUpgrades.ITEM_LIFE.get()) : 0;
            this.securityUpgradeCount = this.getUpgrades(ModUpgrades.SECURITY.get());
            this.setPathfindingMalus(PathType.WATER, this.securityUpgradeCount > 0 ? 0.0f : -1.0f);
            this.energy.setCapacity(100000 + 100000 * this.getUpgrades(ModUpgrades.VOLUME.get()));
            this.setHasMinigun(this.getUpgrades(ModUpgrades.MINIGUN.get()) > 0);
            if (this.getUpgrades(ModUpgrades.CHUNKLOADER.get()) > 0) {
                this.prevChunkPos = this.chunkPosition();
                this.chunkLoader = DynamicChunkLoader.forDrone(this);
                this.chunkLoader.updateLoadedChunks((ServerLevel)this.level(), this.prevChunkPos);
            }
            this.droneItemHandler.setFakePlayerReady();
            this.aiManager.setWidgets(this.progWidgets);
        }
    }

    private void handleRedstoneEmission() {
        block0: {
            Direction d;
            Direction[] directionArray;
            int n;
            int n2;
            if (!this.level().isEmptyBlock(this.blockPosition()) || (n2 = 0) >= (n = (directionArray = DirectionUtil.VALUES).length) || this.getEmittingRedstone(d = directionArray[n2]) <= 0) break block0;
            this.level().setBlockAndUpdate(this.blockPosition(), ((DroneRedstoneEmitterBlock)ModBlocks.DRONE_REDSTONE_EMITTER.get()).defaultBlockState());
            PneumaticCraftUtils.getBlockEntityAt((BlockGetter)this.level(), this.blockPosition(), DroneRedstoneEmitterBlockEntity.class).ifPresent(be -> be.setOwner(this));
        }
    }

    private void handleFluidDisplacement() {
        this.restoreFluidBlocks(true);
        for (int x = (int)this.getX() - 1; x <= (int)(this.getX() + (double)this.getBbWidth()); ++x) {
            for (int y = (int)this.getY() - 1; y <= (int)(this.getY() + (double)this.getBbHeight() + 1.0); ++y) {
                for (int z = (int)this.getZ() - 2; z <= (int)(this.getZ() + (double)this.getBbWidth()); ++z) {
                    if (!PneumaticCraftUtils.isBlockLiquid(this.level().getBlockState(new BlockPos(x, y, z)).getBlock())) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.securityUpgradeCount == 2) {
                        this.displacedLiquids.put(pos, this.level().getBlockState(pos));
                    }
                    this.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
    }

    public void setPos(double x, double y, double z) {
        Level level;
        super.setPos(x, y, z);
        if (this.chunkLoader != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.prevChunkPos != null && !this.chunkPosition().equals((Object)this.prevChunkPos)) {
                this.prevChunkPos = this.chunkPosition();
                this.chunkLoader.updateLoadedChunks(serverLevel, this.prevChunkPos);
            }
        }
    }

    public boolean shouldLoadChunk(ChunkPos cp) {
        return Math.abs(cp.x - this.chunkPosition().x) + Math.abs(cp.z - this.chunkPosition().z) < this.getUpgrades(ModUpgrades.CHUNKLOADER.get());
    }

    public boolean isDescending() {
        return this.getDeltaMovement().y() < 0.0;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return this.securityUpgradeCount == 0;
    }

    @Override
    public BlockPos getTargetedBlock() {
        BlockPos pos = (BlockPos)this.entityData.get(TARGET_POS);
        return pos.equals((Object)BlockPos.ZERO) ? null : pos;
    }

    private void setTargetedBlock(BlockPos pos) {
        this.entityData.set(TARGET_POS, (Object)(pos == null ? BlockPos.ZERO : pos));
    }

    @Override
    public int getLaserColor() {
        Component name = this.hasCustomName() ? this.getCustomName() : this.ownerName;
        return LASER_COLOR_MAP.getOrDefault(name, super.getLaserColor());
    }

    @Override
    public BlockPos getDugBlock() {
        BlockPos pos = (BlockPos)this.entityData.get(DUG_POS);
        return pos.equals((Object)BlockPos.ZERO) ? null : pos;
    }

    @Override
    public ItemStack getDroneHeldItem() {
        return (Boolean)ConfigHelper.common().drones.dronesRenderHeldItem.get() != false ? (ItemStack)this.entityData.get(HELD_ITEM) : ItemStack.EMPTY;
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        this.entityData.set(DUG_POS, (Object)(pos == null ? BlockPos.ZERO : pos));
        if (pos == null) {
            this.digSourcePos = null;
        }
    }

    @Override
    public void setDugBlock(@NotNull BlockPos pos, Direction side) {
        this.setDugBlock(pos);
        this.digSourcePos = pos.relative(side);
    }

    public List<DroneAIManager.WrappedGoal> getRunningTasks() {
        return this.aiManager.getRunningTasks();
    }

    public Goal getRunningTargetAI() {
        return this.aiManager.getTargetAI();
    }

    public void setVariable(String varName, BlockPos pos) {
        this.aiManager.setCoordinate(varName, pos);
    }

    public Optional<BlockPos> getVariable(String varName) {
        return this.aiManager.getCoordinate(this.ownerUUID, varName);
    }

    private ResourceLocation getActiveProgramKey() {
        return ResourceLocation.parse((String)((String)this.entityData.get(PROGRAM_KEY)));
    }

    @Override
    public int getActiveWidgetIndex() {
        return (Integer)this.entityData.get(ACTIVE_WIDGET);
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
        this.entityData.set(PROGRAM_KEY, (Object)widget.getTypeID().toString());
        this.entityData.set(ACTIVE_WIDGET, (Object)this.getActiveAIManager().widgets().indexOf(widget));
    }

    private void setAccelerating(boolean accelerating) {
        this.entityData.set(ACCELERATING, (Object)accelerating);
    }

    @Override
    public boolean isAccelerating() {
        return (Boolean)this.entityData.get(ACCELERATING);
    }

    private void setDroneColor(int color) {
        this.entityData.set(DRONE_COLOR, (Object)color);
    }

    @Override
    public int getDroneColor() {
        return (Integer)this.entityData.get(DRONE_COLOR);
    }

    private void setMinigunActivated(boolean activated) {
        this.entityData.set(MINIGUN_ACTIVE, (Object)activated);
    }

    private boolean isMinigunActivated() {
        return (Boolean)this.entityData.get(MINIGUN_ACTIVE);
    }

    private void setHasMinigun(boolean hasMinigun) {
        this.entityData.set(HAS_MINIGUN, (Object)hasMinigun);
    }

    @Override
    public boolean hasMinigun() {
        return (Boolean)this.entityData.get(HAS_MINIGUN);
    }

    public int getAmmoColor() {
        return (Integer)this.entityData.get(AMMO);
    }

    private void setAmmoColor(ItemStack ammoStack) {
        int n;
        Item item = ammoStack.getItem();
        if (item instanceof AbstractGunAmmoItem) {
            AbstractGunAmmoItem ammo = (AbstractGunAmmoItem)item;
            n = ammo.getAmmoColor(ammoStack);
        } else {
            n = -65536;
        }
        int color = n;
        this.entityData.set(AMMO, (Object)color);
    }

    @Override
    public BlockPos getDeployPos() {
        return this.deployPos;
    }

    public void setDeployPos(BlockPos deployPos) {
        if (this.deployPos != null) {
            throw new IllegalStateException("deployPos has already been set!");
        }
        this.deployPos = deployPos;
    }

    protected int decreaseAirSupply(int par1) {
        return -20;
    }

    public void travel(Vec3 travelVec) {
        if (this.level().isClientSide) {
            LivingEntity targetEntity = this.getTarget();
            if (targetEntity != null && !targetEntity.isAlive()) {
                this.setTarget(null);
                targetEntity = null;
            }
            if (targetEntity != null) {
                if (this.targetLine == null) {
                    this.targetLine = new ProgressingLine(0.0f, this.getBbHeight() / 2.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                if (this.oldTargetLine == null) {
                    this.oldTargetLine = new ProgressingLine(0.0f, this.getBbHeight() / 2.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                this.targetLine.endX = (float)(targetEntity.getX() - this.getX());
                this.targetLine.endY = (float)(targetEntity.getY() + (double)(targetEntity.getBbHeight() / 2.0f) - this.getY());
                this.targetLine.endZ = (float)(targetEntity.getZ() - this.getZ());
                this.oldTargetLine.endX = (float)(targetEntity.xo - this.xo);
                this.oldTargetLine.endY = (float)(targetEntity.yo + (double)(targetEntity.getBbHeight() / 2.0f) - this.yo);
                this.oldTargetLine.endZ = (float)(targetEntity.zo - this.zo);
                this.oldTargetLine.setProgress(this.targetLine.getProgress());
                this.targetLine.incProgressByDistance(0.2f);
                this.noCulling = true;
            } else {
                this.oldTargetLine = null;
                this.targetLine = null;
                this.noCulling = false;
            }
        }
        if (this.getVehicle() == null && this.isAccelerating()) {
            double d3 = this.getDeltaMovement().y;
            super.travel(travelVec);
            this.setDeltaMovement(this.getDeltaMovement().x, d3 * 0.6, this.getDeltaMovement().z);
        } else {
            super.travel(travelVec);
        }
        this.setOnGround(true);
    }

    public ProgressingLine getTargetLine() {
        return this.targetLine;
    }

    public ProgressingLine getOldTargetLine() {
        return this.oldTargetLine;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.getOwnerUUID().equals(player.getUUID())) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        Level level = this.level();
        if (stack.getItem() == ModItems.GPS_TOOL.get()) {
            if (!level.isClientSide) {
                return GPSToolItem.getGPSLocation(player.getUUID(), stack).map(gpsPos -> {
                    this.getNavigation().moveTo((double)gpsPos.getX(), (double)gpsPos.getY(), (double)gpsPos.getZ(), 0.1);
                    return InteractionResult.SUCCESS;
                }).orElse(InteractionResult.PASS);
            }
            return InteractionResult.SUCCESS;
        }
        if (IOHelper.getFluidHandlerForItem(stack).isPresent()) {
            if (player.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            return IOHelper.getFluidHandlerForItem(stack).map(handler -> {
                if (handler.getFluidInTank(0).isEmpty()) {
                    boolean ok = player.level().isClientSide || FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.fluidTank);
                    return ok ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
                return InteractionResult.PASS;
            }).orElseThrow(RuntimeException::new);
        }
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null) {
            if (!level.isClientSide) {
                this.setDroneColor(color.getId());
                if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue() && !player.isCreative()) {
                    stack.shrink(1);
                    if (stack.getCount() <= 0) {
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean shouldDropAsItem() {
        return true;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (this.shouldDropAsItem()) {
            this.wrenchedBy = player.getUUID();
            this.overload("wrenched", new Object[0]);
            return true;
        }
        return false;
    }

    private void restoreFluidBlocks(boolean distCheck) {
        Iterator<Map.Entry<BlockPos, BlockState>> iter = this.displacedLiquids.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<BlockPos, BlockState> entry = iter.next();
            BlockPos pos = entry.getKey();
            if (distCheck && !(pos.distToCenterSqr(this.getX(), this.getY(), this.getZ()) > 1.0)) continue;
            if (this.level().isEmptyBlock(pos) || PneumaticCraftUtils.isBlockLiquid(this.level().getBlockState(pos).getBlock())) {
                this.level().setBlock(pos, entry.getValue(), 3);
            }
            iter.remove();
        }
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        Entity entity = super.changeDimension(transition);
        if (entity != null) {
            this.restoreFluidBlocks(false);
        }
        return entity;
    }

    protected void dropEquipment() {
        boolean wrenchedByOwner = this.wrenchedBy != null && this.wrenchedBy.equals(this.ownerUUID);
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            ItemStack stack = this.droneItemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (wrenchedByOwner || !EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
                this.spawnAtLocation(stack, 0.0f);
            }
            this.droneItemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        for (Entity e : this.getPassengers()) {
            if (!(e instanceof Mob)) continue;
            Mob mob = (Mob)e;
            mob.setNoAi(this.carriedEntityAIdisabled);
        }
        this.restoreFluidBlocks(false);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.chunkLoader != null) {
                this.chunkLoader.unloadAll(serverLevel);
            }
            if (this.getDugBlock() != null) {
                this.getFakePlayer().gameMode.handleBlockBreakAction(this.getDugBlock(), ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.UP, 0, 0);
            }
        }
        if (this.shouldDropAsItem()) {
            ItemStack stack = new ItemStack((ItemLike)this.getDroneItem());
            this.writeToItemStack(stack);
            this.spawnAtLocation(stack, 0.0f);
            if (!this.level().isClientSide) {
                this.reportDroneDeath(this.getOwner(), damageSource);
            }
        }
        this.setCustomName((Component)Component.empty());
    }

    private void reportDroneDeath(Player owner, DamageSource damageSource) {
        if (owner != null) {
            int x = (int)Math.floor(this.getX());
            int y = (int)Math.floor(this.getY());
            int z = (int)Math.floor(this.getZ());
            String dim = this.level().dimension().location().toString();
            MutableComponent msg = this.hasCustomName() ? Component.translatable((String)"pneumaticcraft.death.drone.named", (Object[])new Object[]{Objects.requireNonNull(this.getCustomName()).getString(), dim, x, y, z}) : Component.translatable((String)"pneumaticcraft.death.drone", (Object[])new Object[]{dim, x, y, z});
            owner.displayClientMessage((Component)msg.withStyle(ChatFormatting.GOLD), false);
            if (!damageSource.is(DamageTypes.GENERIC_KILL)) {
                owner.displayClientMessage((Component)Component.literal((String)" - ").append(damageSource.getLocalizedDeathMessage((LivingEntity)this)).withStyle(ChatFormatting.GRAY), false);
            }
        }
    }

    private Item getDroneItem() {
        return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.ENTITY_TYPE, this.getType()).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).orElseThrow();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (this.level().isClientSide) {
            if (TARGET_ID.equals(key)) {
                Entity e;
                int id = (Integer)this.entityData.get(TARGET_ID);
                if (id > 0 && (e = this.getCommandSenderWorld().getEntity(id)) instanceof LivingEntity) {
                    this.setTarget((LivingEntity)e);
                }
                if (this.targetLine != null && this.oldTargetLine != null) {
                    this.targetLine.setProgress(0.0f);
                    this.oldTargetLine.setProgress(0.0f);
                }
            } else if (PRESSURE.equals(key)) {
                int newAir = (int)(((Float)this.entityData.get(PRESSURE)).floatValue() * (float)this.getAirHandler().getVolume());
                this.getAirHandler().addAir(newAir - this.getAirHandler().getAir());
            }
        }
        super.onSyncedDataUpdated(key);
    }

    public void setTarget(LivingEntity entity) {
        super.setTarget(entity);
        if (!this.level().isClientSide) {
            this.entityData.set(TARGET_ID, (Object)(entity == null ? 0 : entity.getId()));
        }
    }

    public boolean startRiding(Entity entity, boolean force) {
        return this.canDroneBePickedUp() && super.startRiding(entity, force);
    }

    public BasicAirHandler getAirHandler() {
        if (this.airHandler == null) {
            int vol = PressureHelper.getUpgradedVolume(12000, this.getUpgrades(ModUpgrades.VOLUME.get()));
            ItemStack stack = new ItemStack((ItemLike)this.getDroneItem());
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)this.stackEnchants);
            vol = ItemRegistry.getInstance().getModifiedVolume(stack, vol);
            this.airHandler = new BasicAirHandler(vol){

                @Override
                public void addAir(int amount) {
                    if (amount > 0 || DroneEntity.this.getUpgrades(ModUpgrades.CREATIVE.get()) == 0) {
                        super.addAir(amount);
                    }
                }
            };
        }
        return this.airHandler;
    }

    @Override
    public void printManometerMessage(Player player, List<Component> curInfo) {
        if (this.hasCustomName()) {
            curInfo.add((Component)this.getDroneName().copy().withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        } else {
            curInfo.add((Component)this.getDroneName().copy().withStyle(ChatFormatting.AQUA));
        }
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.entityTracker.info.tamed", this.getOwnerName().getString()));
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(this.getAirHandler().getPressure(), 2)));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("pneumaticcraft:progWidgets", ProgWidgetUtils.putWidgetsToNBT((HolderLookup.Provider)this.registryAccess(), this.progWidgets));
        tag.put("airHandler", (Tag)this.getAirHandler().serializeNBT());
        tag.putFloat("propSpeed", this.propSpeed);
        if (this.disabledByHacking) {
            tag.putBoolean("disabledByHacking", true);
        }
        if (this.gotoOwnerAI != null) {
            tag.putBoolean("hackedByOwner", true);
        }
        if (this.standby) {
            tag.putBoolean("standby", true);
        }
        if (this.allowStandbyPickup) {
            tag.putBoolean("allowStandbyPickup", true);
        }
        if (this.carriedEntityAIdisabled) {
            tag.putBoolean("carriedEntityAIdisabled", true);
        }
        tag.putInt("color", this.getDroneColor());
        tag.put("variables", (Tag)this.aiManager.writeToNBT(new CompoundTag()));
        if (this.deployPos != null) {
            tag.put("deployPos", NbtUtils.writeBlockPos((BlockPos)this.deployPos));
        }
        ItemStackHandler tmpHandler = PneumaticCraftUtils.copyItemHandler((IItemHandler)this.droneItemHandler, new ItemStackHandler(this.droneItemHandler.getSlots()));
        tag.put("Inventory", (Tag)tmpHandler.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        tag.put("upgrades", (Tag)this.upgradeInventory.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        this.fluidTank.writeToNBT((HolderLookup.Provider)this.registryAccess(), tag);
        tag.putString("owner", this.ownerName.getString());
        if (this.ownerUUID != null) {
            tag.putLong("ownerUUID_M", this.ownerUUID.getMostSignificantBits());
            tag.putLong("ownerUUID_L", this.ownerUUID.getLeastSignificantBits());
        }
        if (!this.stackEnchants.isEmpty()) {
            ItemEnchantments.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.stackEnchants).ifSuccess(t -> tag.put("stackEnchants", t));
        }
        if (!this.displacedLiquids.isEmpty()) {
            DISPLACED_LIQUIDS_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.displacedLiquids).ifSuccess(t -> tag.put("displacedLiquids", t));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.progWidgets = ProgWidgetUtils.getWidgetsFromNBT((HolderLookup.Provider)this.registryAccess(), (Tag)tag.getList("pneumaticcraft:progWidgets", 10));
        ProgWidgetUtils.updatePuzzleConnections(this.progWidgets);
        this.propSpeed = tag.getFloat("propSpeed");
        this.disabledByHacking = tag.getBoolean("disabledByHacking");
        this.setGoingToOwner(tag.getBoolean("hackedByOwner"));
        this.setDroneColor(tag.getInt("color"));
        this.aiManager.readFromNBT(tag.getCompound("variables"));
        this.standby = tag.getBoolean("standby");
        this.allowStandbyPickup = tag.getBoolean("allowStandbyPickup");
        this.upgradeInventory.deserializeNBT((HolderLookup.Provider)this.registryAccess(), tag.getCompound("upgrades"));
        this.upgradeCache.invalidateCache();
        this.getAirHandler().deserializeNBT(tag.getCompound("airHandler"));
        this.carriedEntityAIdisabled = tag.getBoolean("carriedEntityAIdisabled");
        this.deployPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"deployPos").orElse(null);
        ItemStackHandler tmpInv = new ItemStackHandler();
        tmpInv.deserializeNBT((HolderLookup.Provider)this.registryAccess(), tag.getCompound("Inventory"));
        this.droneItemHandler.setUseableSlots(1 + this.getUpgrades(ModUpgrades.INVENTORY.get()));
        PneumaticCraftUtils.copyItemHandler((IItemHandler)tmpInv, this.droneItemHandler);
        this.fluidTank.setCapacity(16000 * (1 + this.getUpgrades(ModUpgrades.INVENTORY.get())));
        this.fluidTank.readFromNBT((HolderLookup.Provider)this.registryAccess(), tag);
        this.energy.setCapacity(100000 + 100000 * this.getUpgrades(ModUpgrades.VOLUME.get()));
        if (tag.contains("owner")) {
            this.ownerName = Component.literal((String)tag.getString("owner"));
        }
        if (tag.contains("ownerUUID_M")) {
            this.ownerUUID = new UUID(tag.getLong("ownerUUID_M"), tag.getLong("ownerUUID_L"));
        }
        this.stackEnchants = ItemEnchantments.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("stackEnchants")).result().orElse(ItemEnchantments.EMPTY);
        this.displacedLiquids.clear();
        DISPLACED_LIQUIDS_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("displacedLiquids")).ifSuccess(this.displacedLiquids::putAll);
    }

    @Override
    public Component getOwnerName() {
        return this.ownerName;
    }

    @Override
    public UUID getOwnerUUID() {
        if (this.ownerUUID == null) {
            Log.warning("Drone with owner '{}' has no UUID! Substituting the Drone's UUID ({}).", this.ownerName, this.getUUID());
            Log.warning("If you use any protection mods, the drone might not be able to operate in protected areas.", new Object[0]);
            this.ownerUUID = this.getUUID();
        }
        return this.ownerUUID;
    }

    @Override
    public int getUpgrades(PNCUpgrade upgrade) {
        return this.upgradeCache.getUpgrades(upgrade);
    }

    @Override
    public FakePlayer getFakePlayer() {
        if (this.fakePlayer == null && !this.level().isClientSide) {
            this.fakePlayer = new DroneFakePlayer((ServerLevel)this.level(), new GameProfile(this.getOwnerUUID(), this.ownerName.getString()), this);
        }
        return this.fakePlayer;
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunDrone(this.level().isClientSide ? null : this.getFakePlayer()).setWorld(this.level()).setAirHandler((IAirHandler)this.getCapability(PNCCapabilities.AIR_HANDLER_ENTITY), 200).setInfiniteAmmo(this.getUpgrades(ModUpgrades.CREATIVE.get()) > 0);
        }
        return this.minigun;
    }

    public boolean doHurtTarget(Entity entity) {
        LivingEntity livingEntity;
        this.getFakePlayer().attack(entity);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isAlive() && livingEntity.getLastHurtByMob() == this.getFakePlayer()) {
            livingEntity.setLastHurtByMob((LivingEntity)this);
        }
        this.getAirHandler().addAir(-200);
        return true;
    }

    public int getArmorValue() {
        return this.getUpgrades(ModUpgrades.ARMOR.get());
    }

    public boolean hurt(DamageSource source, float damage) {
        if (source.is(DamageTypes.IN_WALL) && this.suffocationCounter > 0) {
            --this.suffocationCounter;
        }
        return super.hurt(source, damage);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.is(DamageTypes.IN_WALL)) {
            return this.suffocationCounter > 0 || (Boolean)ConfigHelper.common().drones.enableDroneSuffocation.get() == false;
        }
        if (RadiationSourceCheck.INSTANCE.isRadiation(this.level().registryAccess(), source)) {
            return true;
        }
        Entity e = source.getEntity();
        if (e != null && !this.level().isClientSide && e.getId() == this.getFakePlayer().getId()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.droneItemHandler;
    }

    @Override
    public int getEmittingRedstone(Direction side) {
        return this.emittingRedstoneValues.getOrDefault(side, 0);
    }

    @Override
    public void setEmittingRedstone(Direction side, int value) {
        if (this.emittingRedstoneValues.getOrDefault(side, 0) != value) {
            this.emittingRedstoneValues.put(side, value);
            BlockPos pos = new BlockPos((int)Math.floor(this.getX() + (double)(this.getBbWidth() / 2.0f)), (int)Math.floor(this.getY()), (int)Math.floor(this.getZ() + (double)(this.getBbWidth() / 2.0f)));
            BlockState state = this.level().getBlockState(pos);
            this.level().sendBlockUpdated(pos, state, state, 3);
        }
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        if (this.level().isEmptyBlock(pos)) {
            return true;
        }
        BlockState state = this.level().getBlockState(pos);
        Block block = state.getBlock();
        if (PneumaticCraftUtils.isBlockLiquid(block)) {
            return this.securityUpgradeCount > 0;
        }
        if (DroneEntity.checkMC181565kludge(block)) {
            return false;
        }
        if (state.isPathfindable(PathComputationType.LAND)) {
            return true;
        }
        if (DroneRegistry.getInstance().pathfindableBlocks.containsKey(block)) {
            IPathfindHandler pathfindHandler = DroneRegistry.getInstance().pathfindableBlocks.get(block);
            return pathfindHandler == null || pathfindHandler.canPathfindThrough(this.level(), pos);
        }
        return false;
    }

    private static boolean checkMC181565kludge(Block block) {
        return MC181565_BLOCKS.contains(block);
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
        NetworkHandler.sendToAllTracking((CustomPacketPayload)PacketShowWireframe.forDrone(this, pos), (Entity)this);
    }

    @Override
    public ResourceLocation getHackableId() {
        return PneumaticRegistry.RL("drone");
    }

    @Override
    @NotNull
    public Class<DroneEntity> getHackableClass() {
        return DroneEntity.class;
    }

    @Override
    public boolean canHack(Entity entity, Player player) {
        if (!IHackableEntity.super.canHack(entity, player)) {
            return false;
        }
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
        return handler.upgradeUsable(CommonUpgradeHandlers.hackHandler, false) && handler.getUpgradeCount(EquipmentSlot.HEAD, ModUpgrades.ENTITY_TRACKER.get()) >= 1;
    }

    @Override
    public void addHackInfo(DroneEntity entity, List<Component> curInfo, Player player) {
        if (this.ownerUUID.equals(player.getUUID())) {
            if (this.isGoingToOwner()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.resumeTasks", new Object[0]));
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.callBack", new Object[0]));
            }
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.disable", new Object[0]));
        }
    }

    @Override
    public void addPostHackInfo(DroneEntity entity, List<Component> curInfo, Player player) {
        if (this.ownerUUID.equals(player.getUUID())) {
            if (this.isGoingToOwner()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.calledBack", new Object[0]));
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.resumedTasks", new Object[0]));
            }
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.disabled", new Object[0]));
        }
    }

    @Override
    public int getHackTime(DroneEntity entity, Player player) {
        return this.ownerUUID.equals(player.getUUID()) ? 20 : 100;
    }

    @Override
    public void onHackFinished(DroneEntity entity, Player player) {
        if (!this.level().isClientSide && player.getUUID().equals(this.ownerUUID)) {
            this.setGoingToOwner(this.gotoOwnerAI == null);
        } else {
            this.disabledByHacking = true;
        }
    }

    private void setGoingToOwner(boolean state) {
        if (!this.level().isClientSide) {
            if (state && this.gotoOwnerAI == null) {
                this.gotoOwnerAI = new DroneGoToOwner(this);
                this.goalSelector.addGoal(2, (Goal)this.gotoOwnerAI);
                this.entityData.set(GOING_TO_OWNER, (Object)true);
                this.setActiveProgram(new ProgWidgetGoToLocation());
            } else if (!state && this.gotoOwnerAI != null) {
                this.goalSelector.removeGoal((Goal)this.gotoOwnerAI);
                this.gotoOwnerAI = null;
                this.entityData.set(GOING_TO_OWNER, (Object)false);
            }
        }
    }

    private boolean isGoingToOwner() {
        return (Boolean)this.entityData.get(GOING_TO_OWNER);
    }

    @Override
    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public IEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    @Override
    public Player getOwner() {
        MinecraftServer server = this.level().getServer();
        return server != null ? server.getPlayerList().getPlayer(this.ownerUUID) : null;
    }

    public void setStandby(boolean standby, boolean allowPickup) {
        this.standby = standby;
        this.allowStandbyPickup = allowPickup;
    }

    @Override
    public Level getDroneLevel() {
        return this.level();
    }

    @Override
    public Vec3 getDronePos() {
        return this.position();
    }

    @Override
    public BlockPos getControllerPos() {
        return BlockPos.ZERO;
    }

    @Override
    public void dropItem(ItemStack stack) {
        this.spawnAtLocation(stack, 0.0f);
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public GoalSelector getTargetAI() {
        return this.targetSelector;
    }

    @Override
    public boolean isProgramApplicable(ProgWidgetType<?> widgetType) {
        return true;
    }

    @Override
    public void setName(Component string) {
        this.setCustomName(string);
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        if (entity == null) {
            for (Entity e : this.getCarryingEntities()) {
                e.stopRiding();
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.setNoAi(this.carriedEntityAIdisabled);
                }
                this.checkForMinecartKludge(e);
            }
        } else if (entity.startRiding((Entity)this) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            this.carriedEntityAIdisabled = mob.isNoAi();
            mob.setNoAi(true);
        }
    }

    private boolean canDroneBePickedUp() {
        return (Boolean)ConfigHelper.common().drones.dronesCanBePickedUp.get() != false || this.standby && this.allowStandbyPickup;
    }

    private void checkForMinecartKludge(Entity e) {
        double y = e.getY();
        if (this.canDroneBePickedUp() && (e instanceof AbstractMinecart || e instanceof Boat)) {
            y -= 2.0;
            BlockPos pos = e.blockPosition();
            if (this.level().getBlockState(pos).isRedstoneConductor((BlockGetter)this.level(), pos)) {
                y += 1.0;
            }
            if (e instanceof AbstractMinecart) {
                ((EntityAccess)e).setBoardingCooldown(0);
            }
        }
        if (y != e.getY()) {
            e.setPos(e.getX(), y, e.getZ());
        }
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return this.getPassengers();
    }

    @Override
    public boolean isAIOverridden() {
        return this.chargeAI.isExecuting || this.gotoOwnerAI != null;
    }

    @Override
    public void onItemPickupEvent(ItemEntity curPickingUpEntity, int stackSize) {
        this.take((Entity)curPickingUpEntity, stackSize);
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return (IPathNavigator)this.getNavigation();
    }

    public void tryFireMinigun(LivingEntity target) {
        int slot = this.getSlotForAmmo();
        if (slot >= 0) {
            ItemStack ammo = this.droneItemHandler.getStackInSlot(slot);
            if (this.getMinigun().setAmmoStack(ammo).tryFireMinigun((Entity)target)) {
                this.droneItemHandler.setStackInSlot(slot, ItemStack.EMPTY);
            }
        }
    }

    public int getSlotForAmmo() {
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            if (!(this.droneItemHandler.getStackInSlot(i).getItem() instanceof AbstractGunAmmoItem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        this.kill();
        Player owner = this.getOwner();
        if (owner != null) {
            owner.displayClientMessage((Component)Component.literal((String)" - ").append((Component)Component.translatable((String)("pneumaticcraft.death.drone.overload." + msgKey), (Object[])params)).withStyle(ChatFormatting.GRAY), false);
        }
    }

    @Override
    public DroneAIManager getAIManager() {
        return this.aiManager;
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    @Override
    public void playSound(SoundEvent soundEvent, SoundSource category, float volume, float pitch) {
        this.level().playSound(null, this.blockPosition(), soundEvent, category, volume, pitch);
    }

    @Override
    public void addAirToDrone(int air) {
        this.getAirHandler().addAir(air);
    }

    @Override
    public void updateLabel() {
        this.entityData.set(LABEL, (Object)(this.getAIManager() != null ? this.getAIManager().getLabel() : "Main"));
    }

    @Override
    public String getLabel() {
        return (String)this.entityData.get(LABEL);
    }

    @Override
    public boolean isTeleportRangeLimited() {
        return true;
    }

    @Override
    public Component getDroneName() {
        return this.getName();
    }

    @Override
    public DroneDebugger getDebugger() {
        return this.debugger;
    }

    @Override
    public void storeTrackerData(ItemStack stack) {
        stack.set(ModDataComponents.DRONE_DEBUG_TARGET, (Object)DronePacket.DroneTarget.forEntityId(this.getId()));
    }

    @Override
    public IItemHandler getUpgradeHandler() {
        return this.upgradeInventory;
    }

    @Override
    public void onUpgradesChanged() {
        this.energy.setCapacity(100000 + 100000 * this.getUpgrades(ModUpgrades.VOLUME.get()));
    }

    @Override
    public boolean isDroneStillValid() {
        return this.isAlive();
    }

    @Override
    public boolean canMoveIntoFluid(Fluid fluid) {
        if (fluid.getFluidType().getTemperature() > 373) {
            return false;
        }
        return !this.canDrownInFluidType(fluid.getFluidType());
    }

    @Override
    public DroneItemHandler getDroneItemHandler() {
        return this.droneItemHandler;
    }

    public boolean addProgram(BlockPos clickPos, Direction facing, BlockPos placePos, ItemStack droneStack, List<IProgWidget> progWidgets) {
        return false;
    }

    public void incAttackCount() {
        ++this.attackCount;
    }

    public int getAttackCount() {
        return this.attackCount;
    }

    @Override
    public void resetAttackCount() {
        this.attackCount = 0;
    }

    @Override
    public float getDronePressure() {
        return this.getAirHandler().getPressure();
    }

    @Override
    public DronePacket.DroneTarget getPacketTarget() {
        return DronePacket.DroneTarget.forEntityId(this.getId());
    }

    public void setDroneSpeed(double droneSpeed) {
        this.droneSpeed = droneSpeed;
    }

    public double getDroneSpeed() {
        return this.droneSpeed;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    static {
        LASER_COLOR_MAP.put((Component)Component.literal((String)"aureylian"), 16738740);
        LASER_COLOR_MAP.put((Component)Component.literal((String)"loneztar"), 41120);
        LASER_COLOR_MAP.put((Component)Component.literal((String)"jadedcat"), 10494192);
        LASER_COLOR_MAP.put((Component)Component.literal((String)"desht"), 0xFF6000);
        MC181565_BLOCKS = Set.of(Blocks.AMETHYST_CLUSTER, Blocks.CANDLE, Blocks.LILY_PAD, Blocks.BIG_DRIPLEAF, Blocks.POINTED_DRIPSTONE, Blocks.TURTLE_EGG, Blocks.AZALEA, Blocks.HONEY_BLOCK);
    }

    private class EntityDroneItemHandler
    extends DroneItemHandler {
        EntityDroneItemHandler(IDrone holder) {
            super(holder, 1);
        }

        @Override
        public void copyItemToFakePlayer(int slot) {
            super.copyItemToFakePlayer(slot);
            if (this.isFakePlayerReady() && slot == DroneEntity.this.getFakePlayer().getInventory().selected && ((Boolean)ConfigHelper.common().drones.dronesRenderHeldItem.get()).booleanValue()) {
                DroneEntity.this.entityData.set(HELD_ITEM, (Object)this.getStackInSlot(slot));
            }
        }
    }

    public class MinigunDrone
    extends Minigun {
        MinigunDrone(FakePlayer fakePlayer) {
            super((Player)fakePlayer, true);
        }

        @Override
        public PacketPlayMovingSound.MovingSoundFocus getSoundSource() {
            return PacketPlayMovingSound.MovingSoundFocus.of((Entity)DroneEntity.this);
        }

        @Override
        public boolean isMinigunActivated() {
            return DroneEntity.this.isMinigunActivated();
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            if (!this.world.isClientSide) {
                DroneEntity.this.setMinigunActivated(activated);
            }
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!this.world.isClientSide) {
                DroneEntity.this.setAmmoColor(ammo);
            }
        }

        @Override
        public int getAmmoColor() {
            return DroneEntity.this.getAmmoColor();
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            this.world.playSound(null, DroneEntity.this.blockPosition(), soundName, SoundSource.NEUTRAL, volume, pitch);
        }

        @Override
        public Vec3 getMuzzlePosition() {
            Vec3 centre = DroneEntity.this.position();
            LivingEntity target = DroneEntity.this.minigun.getAttackTarget();
            if (target == null) {
                return null;
            }
            Vec3 offset = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(centre).normalize().scale(0.6);
            return centre.add(offset);
        }

        @Override
        public Vec3 getLookAngle() {
            return Vec3.directionFromRotation((float)this.minigunPitch, (float)this.minigunYaw).normalize();
        }

        @Override
        public float getParticleScale() {
            return 1.0f;
        }

        @Override
        public boolean isValid() {
            return DroneEntity.this.isAlive();
        }
    }
}

