/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneEntityAIPickupItems;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemPickupWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetPickupItem
extends ProgWidgetAreaItemBase
implements IItemPickupWidget {
    public static final MapCodec<ProgWidgetPickupItem> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetPickupItem.baseParts(builder).and((App)Codec.BOOL.optionalFieldOf("can_steal", (Object)false).forGetter(ProgWidgetPickupItem::canSteal)).apply((Applicative)builder, ProgWidgetPickupItem::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetPickupItem> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetPickupItem::canSteal, ProgWidgetPickupItem::new);
    private boolean canSteal;

    private ProgWidgetPickupItem(ProgWidget.PositionFields pos, boolean canSteal) {
        super(pos);
        this.canSteal = canSteal;
    }

    public ProgWidgetPickupItem() {
        this(ProgWidget.PositionFields.DEFAULT, false);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetPickupItem(this.getPosition(), this.canSteal);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_PICK_ITEM;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.PICKUP_ITEM.get();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneEntityAIPickupItems(drone, (ProgWidgetAreaItemBase)widget);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.PINK;
    }

    @Override
    public boolean canSteal() {
        return this.canSteal;
    }

    @Override
    public void setCanSteal(boolean canSteal) {
        this.canSteal = canSteal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetPickupItem that = (ProgWidgetPickupItem)o;
        return this.baseEquals(that) && this.canSteal == that.canSteal;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.canSteal);
    }
}

