/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneCondition;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ProgWidgetDroneConditionEntity
extends ProgWidgetDroneCondition
implements IEntityProvider {
    public static final MapCodec<ProgWidgetDroneConditionEntity> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetDroneConditionEntity.droneConditionParts(builder).apply((Applicative)builder, ProgWidgetDroneConditionEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetDroneConditionEntity> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetDroneCondition.DroneConditionFields.STREAM_CODEC, ProgWidgetDroneCondition::droneConditionFields, ProgWidgetDroneConditionEntity::new);
    private EntityFilterPair<ProgWidgetDroneConditionEntity> entityFilters;

    public ProgWidgetDroneConditionEntity() {
    }

    public ProgWidgetDroneConditionEntity(ProgWidget.PositionFields pos, ProgWidgetDroneCondition.DroneConditionFields cond) {
        super(pos, cond);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetDroneConditionEntity(this.getPosition(), this.droneConditionFields());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.DRONE_CONDITION_ENTITY.get();
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        EntityFilterPair.addErrors(this, curInfo);
    }

    @Override
    public int getEntityFilterPosition() {
        return 0;
    }

    @Override
    protected int getCount(IDrone d, IProgWidget widget) {
        int count = 0;
        for (Entity e : IDroneBase.asDrone(d).getPassengers()) {
            if (!((IEntityProvider)((Object)widget)).isEntityValid(e)) continue;
            ++count;
        }
        this.maybeRecordMeasuredVal(d, count);
        return count;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_DRONE_ENTITY;
    }

    @Override
    public List<Entity> getValidEntities(Level world) {
        return new ArrayList<Entity>();
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetDroneConditionEntity>(this);
        }
        return this.entityFilters.isEntityValid(entity);
    }
}

