/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.ICustomBlockInteract;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.registry.PNCRegistries;
import me.desht.pneumaticcraft.common.drone.ai.DroneAICustomBlockInteract;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetCustomBlockInteract
extends ProgWidgetInventoryBase {
    public static final MapCodec<ProgWidgetCustomBlockInteract> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetCustomBlockInteract.invParts(builder).apply((Applicative)builder, ProgWidgetCustomBlockInteract::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetCustomBlockInteract> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetCustomBlockInteract::new);
    private ICustomBlockInteract interactor;
    private ProgWidgetType<?> customType = null;

    public ProgWidgetCustomBlockInteract(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields invBaseFields) {
        super(pos, invBaseFields);
    }

    public ProgWidgetCustomBlockInteract() {
        super(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return (IProgWidget)Util.make((Object)new ProgWidgetCustomBlockInteract(this.getPosition(), this.invBaseFields().copy()), w -> w.setInteractor(this.interactor));
    }

    public ProgWidgetCustomBlockInteract setInteractor(ICustomBlockInteract interactor) {
        this.interactor = interactor;
        return this;
    }

    @Override
    public ProgWidgetType<?> getType() {
        if (this.customType == null) {
            this.customType = (ProgWidgetType)PNCRegistries.PROG_WIDGETS_REGISTRY.get(PneumaticRegistry.RL(this.interactor.getID()));
            Objects.requireNonNull(this.customType);
        }
        return this.customType;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.interactor.getTexture();
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAICustomBlockInteract(drone, (ProgWidgetInventoryBase)widget, this.interactor);
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get());
    }

    @Override
    public DyeColor getColor() {
        return this.interactor.getColor();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetCustomBlockInteract that = (ProgWidgetCustomBlockInteract)o;
        return this.baseEquals(that) && Objects.equals(this.customType, that.customType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.customType);
    }
}

