/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.misc.IVariableProvider;
import me.desht.pneumaticcraft.api.registry.PNCRegistries;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTooBigException;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ProgWidgetArea
extends ProgWidget
implements IAreaProvider,
IVariableWidget {
    public static final MapCodec<ProgWidgetArea> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetArea.baseParts(builder).and(builder.group((App)BlockPos.CODEC.optionalFieldOf("pos1").forGetter(p -> p.getPos(0)), (App)BlockPos.CODEC.optionalFieldOf("pos2").forGetter(p -> p.getPos(1)), (App)AreaType.CODEC.fieldOf("area_type").forGetter(p -> p.areaType), (App)Codec.STRING.optionalFieldOf("var1", (Object)"").forGetter(p -> p.getVarName(0)), (App)Codec.STRING.optionalFieldOf("var2", (Object)"").forGetter(p -> p.getVarName(1)))).apply((Applicative)builder, ProgWidgetArea::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetArea> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), p -> p.getPos(0), (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), p -> p.getPos(1), AreaType.STREAM_CODEC, p -> p.areaType, (StreamCodec)ByteBufCodecs.STRING_UTF8, p -> p.getVarName(0), (StreamCodec)ByteBufCodecs.STRING_UTF8, p -> p.getVarName(1), ProgWidgetArea::new);
    private DroneAIManager aiManager;
    private final BlockPos[] pos = new BlockPos[]{null, null};
    private final String[] varNames = new String[]{"", ""};
    private AreaType areaType = new AreaTypeBox();
    private IVariableProvider variableProvider;
    private UUID playerID;

    public ProgWidgetArea() {
        this(ProgWidget.PositionFields.DEFAULT, Optional.empty(), Optional.empty(), new AreaTypeBox(), "", "");
    }

    private ProgWidgetArea(ProgWidget.PositionFields pos, Optional<BlockPos> pos1, Optional<BlockPos> pos2, AreaType areaType, String varName1, String varName2) {
        super(pos);
        this.setPos(0, pos1.orElse(null));
        this.setPos(1, pos2.orElse(null));
        this.areaType = areaType;
        this.setVarName(0, varName1);
        this.setVarName(1, varName2);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetArea(this.getPosition(), this.getPos(0), this.getPos(1), this.areaType.copy(), this.getVarName(0), this.getVarName(1));
    }

    public static List<? extends AreaType> getAllAreaTypes() {
        return PNCRegistries.AREA_TYPE_SERIALIZER_REGISTRY.stream().map(AreaTypeSerializer::createDefaultInstance).toList();
    }

    public static ProgWidgetArea fromPosition(BlockPos p1) {
        return ProgWidgetArea.fromPositions(p1, p1);
    }

    public static ProgWidgetArea fromPosition(BlockPos p1, int expand) {
        return ProgWidgetArea.fromPosition(p1, expand, expand, expand);
    }

    public static ProgWidgetArea fromPosition(BlockPos p1, int expandX, int expandY, int expandZ) {
        int x = expandX / 2;
        int y = expandY / 2;
        int z = expandZ / 2;
        return ProgWidgetArea.fromPositions(p1.offset(-x, -y, -z), p1.offset(x, y, z));
    }

    public static ProgWidgetArea fromPositions(BlockPos p1, BlockPos p2) {
        return new ProgWidgetArea(ProgWidget.PositionFields.DEFAULT, Optional.ofNullable(p1), Optional.ofNullable(p2), new AreaTypeBox(), "", "");
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        ArrayList<Component> res = new ArrayList<Component>();
        if (this.varNames[0].isEmpty() && this.varNames[1].isEmpty() && PneumaticCraftUtils.isValidPos(this.pos[0]) && this.pos[0].equals((Object)this.pos[1])) {
            res.add((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.pos[0])));
        } else {
            if (!this.varNames[0].isEmpty()) {
                res.add((Component)Component.literal((String)("\"" + this.varNames[0] + "\"")));
            } else if (PneumaticCraftUtils.isValidPos(this.pos[0])) {
                res.add((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.pos[0])));
            }
            if (!this.varNames[1].isEmpty() && !this.varNames[1].equals(this.varNames[0])) {
                res.add((Component)Component.literal((String)("\"" + this.varNames[1] + "\"")));
            } else if (PneumaticCraftUtils.isValidPos(this.pos[1]) && !this.pos[1].equals((Object)this.pos[0])) {
                res.add((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.pos[1])));
            }
            if (res.size() == 2) {
                ProgWidgetArea.addAreaTypeInfo(this.areaType, res);
            }
        }
        return res;
    }

    public static void addAreaTypeInfo(AreaType areaType, List<Component> res) {
        MutableComponent c = PneumaticCraftUtils.xlate(areaType.getTranslationKey(), new Object[0]);
        ArrayList<AreaTypeWidget> widgets = new ArrayList<AreaTypeWidget>();
        areaType.addUIWidgets(widgets);
        widgets.forEach(w -> c.append("/").append(w.getDisplayName()));
        res.add((Component)c);
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.AREA.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.varNames[0].isEmpty() && this.varNames[0].equals(this.varNames[1])) {
            curTooltip.add((Component)Component.literal((String)String.format("Var \"%s\"", this.varNames[0])).withStyle(ChatFormatting.YELLOW));
        } else if (PneumaticCraftUtils.isValidPos(this.pos[0]) && this.pos[0].equals((Object)this.pos[1])) {
            curTooltip.add((Component)Component.literal((String)"P1: ").append((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.pos[0])).withStyle(ChatFormatting.YELLOW)));
        } else {
            int n = curTooltip.size();
            for (int i = 0; i < 2; ++i) {
                String text;
                String string = this.varNames[i].isEmpty() ? (this.pos[i] == null ? null : PneumaticCraftUtils.posToString(this.pos[i])) : (text = String.format("Var \"%s\"", this.varNames[i]));
                if (text == null) continue;
                curTooltip.add((Component)Component.literal((String)("P" + (i + 1) + ": ")).append((Component)Component.literal((String)text).withStyle(ChatFormatting.YELLOW)));
            }
            if (curTooltip.size() - n == 2) {
                this.addAreaTypeTooltip(curTooltip);
            }
        }
    }

    public void addAreaTypeTooltip(List<Component> curTooltip) {
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.type", new Object[0]).append((Component)PneumaticCraftUtils.xlate(this.areaType.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.YELLOW)));
        ArrayList<AreaTypeWidget> widgets = new ArrayList<AreaTypeWidget>();
        this.areaType.addUIWidgets(widgets);
        for (AreaTypeWidget widget : widgets) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate(widget.getTranslationKey(), new Object[0]).append(" ").append((Component)widget.getDisplayName().copy().withStyle(ChatFormatting.YELLOW)));
        }
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.varNames[0].isEmpty() && this.varNames[1].isEmpty() && this.pos[0] == null && this.pos[1] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        if (!(this.areaType instanceof AreaTypeBox)) {
            IProgWidget p = this;
            while ((p = p.getParent()) != null) {
                ProgWidgetType<?> type = p.getType();
                if (type != ModProgWidgetTypes.ENTITY_ATTACK.get() && type != ModProgWidgetTypes.ENTITY_IMPORT.get() && type != ModProgWidgetTypes.ENTITY_RIGHT_CLICK.get() && type != ModProgWidgetTypes.CONDITION_ENTITY.get() && type != ModProgWidgetTypes.PICKUP_ITEM.get()) continue;
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.onlyAreaTypeBox", PneumaticCraftUtils.xlate(p.getTranslationKey(), new Object[0])));
                break;
            }
        }
    }

    private BlockPos[] getAreaPoints() {
        BlockPos[] points = new BlockPos[2];
        for (int i = 0; i < 2; ++i) {
            points[i] = this.varNames[i].isEmpty() ? this.pos[i] : (this.variableProvider != null ? (BlockPos)this.variableProvider.getCoordinate(this.playerID, this.varNames[i]).orElse(null) : null);
        }
        if (points[0] == null && points[1] == null) {
            return new BlockPos[]{null, null};
        }
        if (points[0] == null) {
            return new BlockPos[]{points[1], null};
        }
        if (points[1] == null) {
            return new BlockPos[]{points[0], null};
        }
        return points;
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgetTypes.AREA.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_AREA;
    }

    @Override
    public Set<BlockPos> getArea(Set<BlockPos> area) {
        this.getArea(area, this.areaType);
        return area;
    }

    public void getArea(Set<BlockPos> area, AreaType areaType) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].getX(), areaPoints[1].getX());
            minY = Math.min(areaPoints[0].getY(), areaPoints[1].getY());
            minZ = Math.min(areaPoints[0].getZ(), areaPoints[1].getZ());
            maxX = Math.max(areaPoints[0].getX(), areaPoints[1].getX());
            maxY = Math.max(areaPoints[0].getY(), areaPoints[1].getY());
            maxZ = Math.max(areaPoints[0].getZ(), areaPoints[1].getZ());
        } else {
            minX = maxX = areaPoints[0].getX();
            minY = maxY = areaPoints[0].getY();
            minZ = maxZ = areaPoints[0].getZ();
        }
        BlockPos p1 = areaPoints[0];
        BlockPos p2 = areaPoints[1] != null ? areaPoints[1] : p1;
        int size = (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
        int maxSize = (Integer)ConfigHelper.common().general.maxProgrammingArea.get();
        if (size > maxSize && this.aiManager != null) {
            IDrone drone = this.aiManager.getDrone();
            Log.warning("Drone @ {} (DIM {}) was killed due to excessively large area ({} > {}). See 'maxProgrammingArea' in config.", drone.getDronePos().toString(), drone.getDroneLevel().dimension().location(), size, maxSize);
            drone.overload("areaTooLarge", maxSize);
            return;
        }
        Consumer<BlockPos> addFunc = p -> {
            if (area.add((BlockPos)p) && area.size() > maxSize) {
                throw new AreaTooBigException();
            }
        };
        try {
            areaType.addArea(addFunc, p1, p2, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (AreaTooBigException areaTooBigException) {
            // empty catch block
        }
    }

    private AABB getAABB() {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return null;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].getX(), areaPoints[1].getX());
            minY = Math.min(areaPoints[0].getY(), areaPoints[1].getY());
            minZ = Math.min(areaPoints[0].getZ(), areaPoints[1].getZ());
            maxX = Math.max(areaPoints[0].getX(), areaPoints[1].getX());
            maxY = Math.max(areaPoints[0].getY(), areaPoints[1].getY());
            maxZ = Math.max(areaPoints[0].getZ(), areaPoints[1].getZ());
        } else {
            minX = maxX = areaPoints[0].getX();
            minY = maxY = areaPoints[0].getY();
            minZ = maxZ = areaPoints[0].getZ();
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    List<Entity> getEntitiesWithinArea(Level world, Predicate<? super Entity> predicate) {
        AABB aabb = this.getAABB();
        return aabb != null ? world.getEntities((Entity)null, aabb, predicate) : new ArrayList<Entity>();
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GREEN;
    }

    public void setPos(int index, BlockPos newPos) {
        this.pos[index] = newPos;
    }

    public Optional<BlockPos> getPos(int index) {
        return this.pos[index] == null ? Optional.empty() : Optional.of(this.pos[index].immutable());
    }

    public String getVarName(int index) {
        return this.varNames[index];
    }

    public void setVarName(int index, String varName) {
        this.varNames[index] = varName;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
        this.variableProvider = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.varNames[0]);
        variables.add(this.varNames[1]);
    }

    public void setVariableProvider(IVariableProvider provider, UUID playerID) {
        this.variableProvider = provider;
        this.playerID = playerID;
    }

    public void updateFrom(ProgWidgetArea otherArea) {
        this.setPos(0, otherArea.getPos(0).orElse(null));
        this.setPos(1, otherArea.getPos(1).orElse(null));
        this.areaType = otherArea.areaType.copy();
        this.setVarName(0, otherArea.getVarName(0));
        this.setVarName(1, otherArea.getVarName(1));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetArea that = (ProgWidgetArea)o;
        return Objects.equals(this.getPosition(), that.getPosition()) && Objects.deepEquals(this.pos, that.pos) && Objects.deepEquals(this.varNames, that.varNames) && Objects.equals(this.areaType, that.areaType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPosition(), Arrays.hashCode(this.pos), Arrays.hashCode(this.varNames), this.areaType);
    }
}

