/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class DroneGoToOwner
extends Goal {
    private final DroneEntity drone;

    public DroneGoToOwner(DroneEntity drone) {
        this.drone = drone;
    }

    public boolean canUse() {
        ServerPlayer owner = this.getOnlineOwner();
        if (owner == null) {
            return false;
        }
        Vec3 lookVec = owner.getLookAngle().scale(2.0);
        double x = owner.getX() + lookVec.x;
        double z = owner.getZ() + lookVec.z;
        return this.drone.distanceToSqr((Entity)owner) > 6.0 && this.drone.getNavigation().moveTo(x, owner.getY(), z, this.drone.getDroneSpeed());
    }

    public boolean canContinueToUse() {
        ServerPlayer owner = this.getOnlineOwner();
        return owner != null && !this.drone.getNavigation().isDone() && this.drone.distanceToSqr((Entity)owner) > 6.0;
    }

    private ServerPlayer getOnlineOwner() {
        if (this.drone.level().getServer() == null) {
            return null;
        }
        return this.drone.level().getServer().getPlayerList().getPlayer(this.drone.getOwnerUUID());
    }
}

