/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIImportExportBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DroneAIEnergyImport
extends DroneAIImportExportBase<ProgWidgetInventoryBase> {
    public DroneAIEnergyImport(IDrone drone, ProgWidgetInventoryBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.importEnergy(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.importEnergy(pos, true);
    }

    private boolean importEnergy(BlockPos pos, boolean simulate) {
        boolean didWork = false;
        if (this.droneIsFull()) {
            this.abort();
        } else {
            Direction face;
            BlockEntity te = this.drone.getDroneLevel().getBlockEntity(pos);
            if (te == null) {
                return false;
            }
            Direction[] directionArray = DirectionUtil.VALUES;
            int n = directionArray.length;
            for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(face = directionArray[i]) && (didWork = this.tryImportFromSide(te, face, simulate))); ++i) {
            }
        }
        return didWork;
    }

    private boolean tryImportFromSide(BlockEntity te, Direction face, boolean simulate) {
        return IOHelper.getEnergyStorageForBlock(te, face).map(tileHandler -> {
            int toExtract = tileHandler.extractEnergy(this.useCount() ? this.getRemainingCount() : Integer.MAX_VALUE, true);
            int toTransfer = this.insertToDrone(toExtract, true);
            if (toTransfer > 0) {
                if (!simulate) {
                    this.decreaseCount(toTransfer);
                    tileHandler.extractEnergy(toTransfer, false);
                    this.insertToDrone(toTransfer, false);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int insertToDrone(int maxTransfer, boolean simulate) {
        return this.drone.getEnergyStorage().receiveEnergy(maxTransfer, simulate);
    }

    private boolean droneIsFull() {
        return this.drone.getEnergyStorage().getEnergyStored() >= this.drone.getEnergyStorage().getMaxEnergyStored();
    }
}

