/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.debug;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.debug.DroneDebugEntry;
import me.desht.pneumaticcraft.api.drone.debug.IDroneDebugger;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneProgWidgets;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DroneDebugger
implements IDroneDebugger {
    private final IDroneBase drone;
    private final DroneDebugList debugList = new DroneDebugList();
    private final Set<ServerPlayer> debuggingPlayers = new HashSet<ServerPlayer>();

    public DroneDebugger(IDroneBase drone) {
        this.drone = drone;
    }

    @Override
    public DroneDebugEntry getDebugEntry(int widgetID) {
        return this.debugList.get(widgetID);
    }

    @Override
    public void addEntry(String message) {
        this.addEntry(message, null);
    }

    @Override
    public void addEntry(String message, BlockPos pos) {
        DroneDebugEntry entry = DroneDebugEntry.create(message, pos, this.getActiveWidgetIndex());
        this.addEntry(entry);
        PacketSendDroneDebugEntry packet = PacketSendDroneDebugEntry.create(this.drone, entry);
        for (ServerPlayer player : this.debuggingPlayers) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    @Override
    public void addEntry(DroneDebugEntry entry) {
        this.debugList.addEntry(entry);
    }

    @Override
    public void trackAsDebugged(ServerPlayer player) {
        NetworkHandler.sendToPlayer(PacketSyncDroneProgWidgets.create(this.drone), player);
        for (DroneDebugEntry entry : this.debugList.getAll()) {
            NetworkHandler.sendToPlayer(PacketSendDroneDebugEntry.create(this.drone, entry), player);
        }
        this.debuggingPlayers.add(player);
    }

    public void updateDebuggingPlayers() {
        this.debuggingPlayers.removeIf(player -> !player.isAlive() || !PneumaticArmorItem.isPlayerDebuggingDrone((Player)player, this.drone));
    }

    @Override
    public Collection<ServerPlayer> getDebuggingPlayers() {
        return this.debuggingPlayers;
    }

    private int getActiveWidgetIndex() {
        return this.drone.getActiveWidgetIndex();
    }

    private class DroneDebugList {
        private final Int2ObjectMap<DroneDebugEntry> debugEntries = new Int2ObjectOpenHashMap();

        private DroneDebugList() {
        }

        void addEntry(DroneDebugEntry entry) {
            this.debugEntries.put(DroneDebugger.this.getActiveWidgetIndex(), (Object)entry);
        }

        public Collection<DroneDebugEntry> getAll() {
            return this.debugEntries.values();
        }

        public DroneDebugEntry get(int widgetId) {
            return (DroneDebugEntry)this.debugEntries.get(widgetId);
        }

        public DroneDebugEntry getCurrent() {
            return (DroneDebugEntry)this.debugEntries.get(DroneDebugger.this.getActiveWidgetIndex());
        }
    }
}

