/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.compressor;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.PneumaticDynamoMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class PneumaticDynamoBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<PneumaticDynamoBlockEntity>,
IMinWorkingPressure,
MenuProvider,
IHeatExchangingTE {
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private int airPerTick;
    private boolean isEnabled;
    @GuiSynced
    private final RedstoneController<PneumaticDynamoBlockEntity> rsController = new RedstoneController<PneumaticDynamoBlockEntity>(this);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();

    public PneumaticDynamoBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.PNEUMATIC_DYNAMO.get(), pos, state, PressureTier.TIER_TWO, 10000, 4);
    }

    public int getEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void tickServer() {
        BlockEntity receiver;
        boolean newEnabled;
        super.tickServer();
        Level level = this.nonNullLevel();
        if (level.getGameTime() % 20L == 0L) {
            int efficiency = Math.max(1, (Integer)ConfigHelper.common().machines.pneumaticDynamoEfficiency.get());
            this.airPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * 100.0f / (float)efficiency);
            this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * (float)this.getEfficiency() / 100.0f);
        }
        if (this.rsController.shouldRun() && this.getPressure() > this.getMinWorkingPressure() && this.energy.getMaxEnergyStored() - this.energy.getEnergyStored() >= this.rfPerTick) {
            this.addAir(-this.airPerTick);
            this.heatExchanger.addHeat((double)this.airPerTick / 100.0);
            this.energy.receiveEnergy(this.rfPerTick, false);
            newEnabled = true;
        } else {
            newEnabled = false;
        }
        if ((level.getGameTime() & 0xFL) == 0L && newEnabled != this.isEnabled) {
            this.isEnabled = newEnabled;
            BlockState state = level.getBlockState(this.worldPosition);
            level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)PNCBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(this.isEnabled)));
        }
        if ((receiver = this.getCachedNeighbor(this.getRotation())) != null) {
            IOHelper.getEnergyStorageForBlock(receiver, this.getRotation().getOpposite()).ifPresent(neighborStorage -> {
                int extracted = this.energy.extractEnergy(this.rfPerTick * 2, true);
                int energyPushed = neighborStorage.receiveEnergy(extracted, true);
                if (energyPushed > 0) {
                    neighborStorage.receiveEnergy(this.energy.extractEnergy(energyPushed, false), false);
                }
            });
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public RedstoneController<PneumaticDynamoBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation().getOpposite();
    }

    @Override
    public float getMinWorkingPressure() {
        return 15.0f;
    }

    public int getRFRate() {
        return this.rfPerTick;
    }

    public int getAirRate() {
        return this.airPerTick;
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public IEnergyStorage getEnergyHandler(@Nullable Direction dir) {
        return dir == this.getRotation() || dir == null ? this.energy : null;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.energy.writeToNBT(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.energy.readFromNBT(tag);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return new PneumaticDynamoMenu(windowId, playerInventory, this.getBlockPos());
    }

    @Override
    @Nullable
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }
}

