/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.hopper.AbstractHopperBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.hopper.OmnidirectionalHopperBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OmnidirectionalHopperBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.ITintableBlock,
PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_SHAPE = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = Shapes.or((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape BOWL_SHAPE = Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape OUTPUT_DOWN_SHAPE = Shapes.or((VoxelShape)Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), (VoxelShape)Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)4.0, (double)9.5));
    public static final Map<Direction, VoxelShape> INPUT_SHAPES = (Map)Util.make(new EnumMap(Direction.class), map -> {
        map.put(Direction.UP, Shapes.join((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)BOWL_SHAPE, (BooleanOp)BooleanOp.ONLY_FIRST));
        map.put(Direction.NORTH, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.UP), 270));
        map.put(Direction.DOWN, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.UP), 180));
        map.put(Direction.SOUTH, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.UP), 90));
        map.put(Direction.WEST, VoxelShapeUtils.rotateY((VoxelShape)map.get(Direction.NORTH), 270));
        map.put(Direction.EAST, VoxelShapeUtils.rotateY((VoxelShape)map.get(Direction.NORTH), 90));
    });
    private static final Map<Direction, VoxelShape> INPUT_SHAPES_INTERACT = (Map)Util.make(new EnumMap(Direction.class), map -> {
        map.put(Direction.UP, INPUT_MIDDLE_SHAPE);
        map.put(Direction.DOWN, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.UP), 180));
        map.put(Direction.NORTH, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.UP), 270));
        map.put(Direction.SOUTH, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.UP), 90));
        map.put(Direction.WEST, VoxelShapeUtils.rotateY((VoxelShape)map.get(Direction.NORTH), 270));
        map.put(Direction.EAST, VoxelShapeUtils.rotateY((VoxelShape)map.get(Direction.NORTH), 90));
    });
    private static final Map<Direction, VoxelShape> OUTPUT_SHAPES = (Map)Util.make(new EnumMap(Direction.class), map -> {
        map.put(Direction.DOWN, OUTPUT_DOWN_SHAPE);
        map.put(Direction.UP, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.DOWN), 180));
        map.put(Direction.NORTH, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.DOWN), 90));
        map.put(Direction.SOUTH, VoxelShapeUtils.rotateX((VoxelShape)map.get(Direction.DOWN), 270));
        map.put(Direction.WEST, VoxelShapeUtils.rotateY((VoxelShape)map.get(Direction.NORTH), 270));
        map.put(Direction.EAST, VoxelShapeUtils.rotateY((VoxelShape)map.get(Direction.NORTH), 90));
    });
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[36];
    private static final VoxelShape[] INTERACTION_SHAPE_CACHE = new VoxelShape[36];
    public static final EnumProperty<Direction> INPUT_FACING = EnumProperty.create((String)"input", Direction.class);

    public OmnidirectionalHopperBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getCachedShape(state, SHAPE_CACHE, INPUT_SHAPES);
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCachedShape(state, INTERACTION_SHAPE_CACHE, INPUT_SHAPES_INTERACT);
    }

    private VoxelShape getCachedShape(BlockState state, VoxelShape[] cache, Map<Direction, VoxelShape> inputMap) {
        int idx = ((Direction)state.getValue(INPUT_FACING)).get3DDataValue() + ((Direction)state.getValue((Property)this.directionProperty())).get3DDataValue() * 6;
        if (cache[idx] == null) {
            cache[idx] = Shapes.join((VoxelShape)inputMap.get(state.getValue(INPUT_FACING)), (VoxelShape)OUTPUT_SHAPES.get(state.getValue((Property)this.directionProperty())), (BooleanOp)BooleanOp.OR);
        }
        return cache[idx];
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{INPUT_FACING});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return state == null ? null : (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getClickedFace().getOpposite())).setValue(INPUT_FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    private Direction getInputDirection(Level world, BlockPos pos) {
        return (Direction)world.getBlockState(pos).getValue(INPUT_FACING);
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction face, InteractionHand hand) {
        BlockState state = world.getBlockState(pos);
        if (player != null && player.isShiftKeyDown()) {
            Direction outputDir = this.getRotation(state);
            if ((outputDir = Direction.from3DDataValue((int)(outputDir.get3DDataValue() + 1))) == this.getInputDirection(world, pos)) {
                outputDir = Direction.from3DDataValue((int)(outputDir.get3DDataValue() + 1));
            }
            this.setRotation(world, pos, outputDir);
        } else {
            Direction inputDir = (Direction)state.getValue(INPUT_FACING);
            if ((inputDir = Direction.from3DDataValue((int)(inputDir.get3DDataValue() + 1))) == this.getRotation((BlockGetter)world, pos)) {
                inputDir = Direction.from3DDataValue((int)(inputDir.get3DDataValue() + 1));
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(INPUT_FACING, (Comparable)inputDir));
        }
        PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, AbstractHopperBlockEntity.class).ifPresent(AbstractHopperBlockEntity::onBlockRotated);
        return true;
    }

    @Override
    public int getTintColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        if (world != null && pos != null) {
            switch (tintIndex) {
                case 0: {
                    return PneumaticCraftUtils.getBlockEntityAt((BlockGetter)world, pos, AbstractHopperBlockEntity.class).filter(te -> te.isCreative).map(te -> -2406705).orElse(-13949145);
                }
                case 1: {
                    return -6250336;
                }
            }
        }
        return -1;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new OmnidirectionalHopperBlockEntity(pPos, pState);
    }

    public static class ItemBlockOmnidirectionalHopper
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockOmnidirectionalHopper(Block block) {
            super(block, ModItems.defaultProps());
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            int n = UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.CREATIVE.get());
            return n > 0 ? -2406705 : -13949145;
        }
    }
}

