/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.AerialInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class AerialInterfaceBlock
extends AbstractPneumaticCraftBlock
implements IBlockComparatorSupport,
PneumaticCraftEntityBlock {
    public AerialInterfaceBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean reversePlacementRotation() {
        return true;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        world.getBlockEntity(pos, ModBlockEntityTypes.AERIAL_INTERFACE.get()).ifPresent(teAI -> {
            if (entity instanceof Player && !(entity instanceof FakePlayer)) {
                teAI.setPlayerId(entity.getUUID());
            }
        });
        super.setPlacedBy(world, pos, state, entity, stack);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.getBlockEntity(pos, ModBlockEntityTypes.AERIAL_INTERFACE.get()).map(teAI -> teAI.getRedstoneController().shouldEmit() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new AerialInterfaceBlockEntity(pPos, pState);
    }
}

