/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker.BlockTrackHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.ProgressBarRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.InputEvent;

public class RenderBlockTarget {
    private static final int SERVER_REQUEST_INTERVAL = 30;
    private static final float STAT_SCALE = 0.02f;
    private static final int START_ACQUIRE_TIME = 50;
    private static final int FINISH_ACQUIRE_TIME = 120;
    private static final int REMOVE_NOW_TIME = -1;
    private static final int MARK_FOR_REMOVAL_TIME = -100;
    private static final int LOST_TARGET_TIME = -30;
    private final Level world;
    private final BlockPos pos;
    private final int posHash;
    private final IGuiAnimatedStat stat;
    private final Player player;
    private final BlockTrackerClientHandler blockTracker;
    private int ticksExisted = 0;
    private int hackTime;
    private BlockEntity te;
    private int nEntries;

    public RenderBlockTarget(Level world, Player player, BlockPos pos, BlockEntity te, BlockTrackerClientHandler blockTracker) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.posHash = Math.abs(pos.hashCode());
        this.te = te;
        this.blockTracker = blockTracker;
        BlockState state = world.getBlockState(pos);
        ItemStack stack = state.getBlock().getCloneItemStack(state, Minecraft.getInstance().hitResult, (LevelReader)world, pos, player);
        Component title = stack.isEmpty() ? PneumaticCraftUtils.xlate(world.getBlockState(pos).getBlock().getDescriptionId(), new Object[0]) : stack.getHoverName();
        this.stat = new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(stack), 20, -20, HUDHandler.getInstance().getStatOverlayColor(), null, false);
        this.stat.setMinimumContractedDimensions(0, 0);
        this.stat.setMinimumExpandedDimensions(16, 16);
        this.stat.setAutoLineWrap(false);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setTileEntity(BlockEntity te) {
        this.te = te;
    }

    public boolean isTargetStillValid() {
        return this.nEntries > 0;
    }

    public void tick() {
        if (!this.world.isLoaded(this.pos)) {
            return;
        }
        int incr = CommonArmorHandler.getHandlerForPlayer(this.player).getSpeedFromUpgrades(EquipmentSlot.HEAD);
        int prevTicks = this.ticksExisted;
        this.ticksExisted += incr;
        if (prevTicks < 0 && this.ticksExisted >= 0) {
            this.ticksExisted = -1;
        }
        if (this.te != null && this.te.isRemoved()) {
            this.te = null;
        }
        this.stat.tickWidget();
        List<IBlockTrackEntry> applicableTrackEntries = BlockTrackHandler.getInstance().getEntriesForCoordinate(this.world, this.pos, this.te);
        this.nEntries = applicableTrackEntries.size();
        this.maybeUpdateFromServer(applicableTrackEntries);
        if (!this.world.isEmptyBlock(this.pos)) {
            ArrayList<Component> textList = new ArrayList<Component>();
            if (this.ticksExisted > 120) {
                this.stat.closeStat();
                if (applicableTrackEntries.stream().anyMatch(entry -> this.blockTracker.countBlockTrackersOfType((IBlockTrackEntry)entry) <= entry.spamThreshold())) {
                    this.stat.openStat();
                }
                if (this.isPlayerLookingAtTarget()) {
                    this.stat.openStat();
                    applicableTrackEntries.forEach(e -> e.addInformation(this.world, this.pos, this.te, this.isPlayerLookingAtTarget() ? this.blockTracker.getFocusedFace() : null, textList));
                }
            } else if (this.ticksExisted < -30) {
                this.stat.closeStat();
            }
            this.stat.setText(textList);
        }
        if (this.hackTime > 0) {
            IHackableBlock hackableBlock = HackManager.getHackableForBlock(this.world, this.pos, this.player);
            this.hackTime = hackableBlock != null ? ++this.hackTime : 0;
        }
    }

    public void checkValidity(int rangeSq) {
        if (this.ticksExisted > 0 && (this.player.distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) > (double)rangeSq || !this.isTargetStillValid())) {
            this.ticksExisted = -100;
        }
    }

    private void maybeUpdateFromServer(List<IBlockTrackEntry> applicableTrackEntries) {
        int searchInterval;
        if (this.te == null) {
            return;
        }
        boolean searching = CommonArmorHandler.getHandlerForPlayer().upgradeUsable(CommonUpgradeHandlers.searchHandler, true);
        boolean focused = this.isPlayerLookingAtTarget();
        int n = searchInterval = focused ? 30 : 60;
        if ((focused || searching) && this.world.getGameTime() % (long)searchInterval == (long)(this.posHash % searchInterval)) {
            Set<BlockPos> posSet = applicableTrackEntries.stream().flatMap(entry -> entry.getServerUpdatePositions(this.te).stream()).collect(Collectors.toSet());
            posSet.forEach(pos -> NetworkHandler.sendToServer(new PacketDescriptionPacketRequest((BlockPos)pos)));
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        matrixStack.pushPose();
        double x = (double)this.pos.getX() + 0.5;
        double y = (double)this.pos.getY() + 0.5;
        double z = (double)this.pos.getZ() + 0.5;
        matrixStack.translate(x, y, z);
        if (!this.world.isEmptyBlock(this.pos)) {
            this.renderBlockHighlight(matrixStack, buffer, this.world, this.pos, partialTicks);
        }
        RenderUtils.rotateToPlayerFacing(matrixStack);
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks) / 1.2f;
        if (this.ticksExisted > 50 && this.ticksExisted <= 120) {
            ProgressBarRenderer.render3d(matrixStack, buffer, 0.0f, 0.4f, 1.8f, 0.7f, 0.0f, targetAcquireProgress, -788529408, -805241088);
        }
        matrixStack.scale(0.02f, 0.02f, 0.02f);
        if (!this.world.isEmptyBlock(this.pos)) {
            if (this.ticksExisted > 120) {
                if (this.isPlayerLookingAtTarget()) {
                    float mul = ClientUtils.getStatSizeMultiplier(Mth.sqrt((float)((float)ClientUtils.getClientPlayer().distanceToSqr(x, y, z))));
                    matrixStack.scale(mul, mul, mul);
                    this.stat.renderStat(matrixStack, buffer, partialTicks);
                }
            } else if (this.ticksExisted > 50) {
                RenderUtils.renderString3d((Component)Component.translatable((String)"pneumaticcraft.entityTracker.info.acquiring"), 0.0f, 0.0f, -3092272, matrixStack, buffer, false, true);
                RenderUtils.renderString3d((Component)Component.literal((String)((int)targetAcquireProgress + "%")), 37.0f, 24.0f, -3092272, matrixStack, buffer, false, true);
            } else if (this.ticksExisted < -30) {
                matrixStack.scale(1.5f, 1.5f, 1.5f);
                this.stat.renderStat(matrixStack, buffer, partialTicks);
                RenderUtils.renderString3d((Component)Component.translatable((String)"pneumaticcraft.blockTracker.info.lostTarget"), 0.0f, (float)(-this.ticksExisted) / 2.5f, -65536, matrixStack, buffer, false, true);
            }
        }
        matrixStack.popPose();
    }

    private void renderBlockHighlight(PoseStack matrixStack, MultiBufferSource buffer, Level world, BlockPos pos, float partialTicks) {
        BlockState state = world.getBlockState(pos);
        VoxelShape shape = state.getShape((BlockGetter)world, pos);
        if (shape.isEmpty()) {
            return;
        }
        float progress = ((float)(world.getGameTime() & 0x1FL) + partialTicks) / 32.0f;
        float cycle = Mth.sin((float)((float)((double)progress * Math.PI)));
        float shrink = (shape == Shapes.block() ? 0.05f : 0.0f) + cycle / 60.0f;
        AABB aabb = shape.bounds().deflate((double)shrink);
        float alpha = this.blockTracker.getFocusedPos() != null ? (this.blockTracker.getFocusedPos().equals((Object)pos) ? 0.75f : 0.15f) : 0.5f;
        matrixStack.pushPose();
        matrixStack.translate(-0.5, -0.5, -0.5);
        RenderType type = RenderUtils.renderFrame(matrixStack, buffer, aabb, 0.015625f, 0.25f, 0.75f, 0.75f, alpha, 0xF000F0, new Direction[0]);
        RenderUtils.finishBuffer(buffer, type);
        matrixStack.popPose();
    }

    private boolean isInitialized() {
        return this.ticksExisted >= 120;
    }

    private boolean isPlayerLookingAtTarget() {
        return this.pos.equals((Object)this.blockTracker.getFocusedPos());
    }

    public void hack() {
        IHackableBlock block;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (block = HackManager.getHackableForBlock(this.world, this.pos, this.player)) != null && (this.hackTime == 0 || this.hackTime > block.getHackTime((BlockGetter)this.world, this.pos, this.player))) {
            NetworkHandler.sendToServer(new PacketHackingBlockStart(this.pos));
        }
    }

    public void onHackConfirmedByServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(InputEvent.MouseScrollingEvent event) {
        return this.isInitialized() && this.isPlayerLookingAtTarget() && this.stat.mouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY());
    }

    public void updateColor(int color) {
        this.stat.setBackgroundColor(color);
    }

    public Component getTitle() {
        return this.stat.getTitle();
    }

    public boolean shouldRemoveNow() {
        return this.ticksExisted == -1;
    }

    public void markValid() {
        this.ticksExisted = Math.abs(this.ticksExisted);
    }
}

