/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.common.entity.projectile.VortexEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Matrix4f;

public class RenderEntityVortex
extends EntityRenderer<VortexEntity> {
    private static final int CIRCLE_POINTS = 20;
    private static final float TEX_SCALE = 0.07f;
    private static final double RADIUS = 0.5;

    public RenderEntityVortex(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public ResourceLocation getTextureLocation(VortexEntity entity) {
        return Textures.VORTEX_ENTITY;
    }

    public void render(VortexEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (!entity.hasRenderOffsetX()) {
            entity.setRenderOffsetX(this.calculateXoffset());
        }
        matrixStackIn.pushPose();
        VertexConsumer builder = bufferIn.getBuffer(ModRenderTypes.getTextureRenderColored(this.getTextureLocation(entity)));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot())));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        float incr = 0.31415927f;
        float angleRads = 0.0f;
        while ((double)angleRads < Math.PI * 2) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5 * (double)Mth.sin((float)angleRads), 0.5 * (double)Mth.cos((float)angleRads), 0.0);
            this.renderGust(matrixStackIn, builder, entity.getRenderOffsetX(), packedLightIn);
            matrixStackIn.popPose();
            angleRads += incr;
        }
        matrixStackIn.popPose();
    }

    private float calculateXoffset() {
        LocalPlayer player = Minecraft.getInstance().player;
        HumanoidArm hs = player.getMainArm();
        if (player.getMainHandItem().getItem() != ModItems.VORTEX_CANNON.get()) {
            hs = hs.getOpposite();
        }
        return hs == HumanoidArm.RIGHT ? -4.0f : 16.0f;
    }

    private void renderGust(PoseStack matrixStackIn, VertexConsumer wr, float xOffset, int packedLightIn) {
        float u1 = 0.0f;
        float u2 = 1.0f;
        float v1 = 0.0f;
        float v2 = 1.0f;
        matrixStackIn.scale(0.07f, 0.07f, 0.07f);
        matrixStackIn.translate(xOffset, 0.0f, 0.0f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
        Matrix4f posMat = matrixStackIn.last().pose();
        wr.addVertex(posMat, -7.0f, -2.0f, -2.0f).setColor(1.0f, 1.0f, 1.0f, 0.5f).setUv(u1, v1).setLight(packedLightIn);
        wr.addVertex(posMat, -7.0f, -2.0f, 2.0f).setColor(1.0f, 1.0f, 1.0f, 0.5f).setUv(u2, v1).setLight(packedLightIn);
        wr.addVertex(posMat, -7.0f, 2.0f, 2.0f).setColor(1.0f, 1.0f, 1.0f, 0.5f).setUv(u2, v2).setLight(packedLightIn);
        wr.addVertex(posMat, -7.0f, 2.0f, -2.0f).setColor(1.0f, 1.0f, 1.0f, 0.5f).setUv(u1, v2).setLight(packedLightIn);
        wr.addVertex(posMat, -7.0f, 2.0f, -2.0f).setColor(1.0f, 1.0f, 1.0f, 0.5f).setUv(u1, v1).setLight(packedLightIn);
        wr.addVertex(posMat, -7.0f, 2.0f, 2.0f).setColor(1.0f, 1.0f, 1.0f, 0.5f).setUv(u2, v1).setLight(packedLightIn);
        wr.addVertex(posMat, -7.0f, -2.0f, 2.0f).setColor(1.0f, 1.0f, 1.0f, 0.5f).setUv(u2, v2).setLight(packedLightIn);
        wr.addVertex(posMat, -7.0f, -2.0f, -2.0f).setColor(1.0f, 1.0f, 1.0f, 0.5f).setUv(u1, v2).setLight(packedLightIn);
    }
}

