/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.client.TubeModuleClientRegistry;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class PressureTubeModuleRenderer
implements BlockEntityRenderer<PressureTubeBlockEntity> {
    private final Map<ResourceLocation, AbstractTubeModuleRenderer<?>> models = new HashMap();
    private final BlockEntityRendererProvider.Context ctx;

    public PressureTubeModuleRenderer(BlockEntityRendererProvider.Context ctx) {
        this.ctx = ctx;
    }

    public void render(PressureTubeBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        TubeModuleItem m;
        TubeModuleItem m2;
        if (tile.getCamouflage() != null) {
            return;
        }
        Player player = ClientUtils.getClientPlayer();
        Item item = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        TubeModuleItem moduleItem = item instanceof TubeModuleItem ? (m2 = (TubeModuleItem)item) : ((item = player.getItemInHand(InteractionHand.OFF_HAND).getItem()) instanceof TubeModuleItem ? (m = (TubeModuleItem)item) : null);
        List<AbstractTubeModule> modules = tile.tubeModules().toList();
        if (modules.isEmpty() && moduleItem == null) {
            return;
        }
        if (moduleItem != null && (item = Minecraft.getInstance().hitResult) instanceof BlockHitResult) {
            AbstractTubeModule fakeModule;
            Direction face;
            BlockHitResult blockHitResult = (BlockHitResult)item;
            Direction direction = face = player.isCrouching() ? blockHitResult.getDirection().getOpposite() : blockHitResult.getDirection();
            if (blockHitResult.getBlockPos().equals((Object)tile.getBlockPos()) && player.level().getBlockEntity(blockHitResult.getBlockPos()) == tile && tile.getModule(face) == null && tile.mayPlaceModule(fakeModule = moduleItem.createModule(face, tile))) {
                fakeModule.markFake();
                this.getModuleRenderer(fakeModule).renderModule(fakeModule, matrixStack, buffer, partialTicks, combinedLight, combinedOverlay);
            }
        }
        for (AbstractTubeModule m3 : modules) {
            this.getModuleRenderer(m3).renderModule(m3, matrixStack, buffer, partialTicks, combinedLight, combinedOverlay);
        }
    }

    private <T extends AbstractTubeModule> AbstractTubeModuleRenderer<T> getModuleRenderer(T module) {
        AbstractTubeModuleRenderer res = this.models.computeIfAbsent(module.getType(), k -> TubeModuleClientRegistry.createModel(module, this.ctx));
        return res;
    }

    public boolean shouldRenderOffScreen(PressureTubeBlockEntity te) {
        return te.tubeModules().findAny().isPresent();
    }

    public AABB getRenderBoundingBox(PressureTubeBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }
}

