/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.area;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Set;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public class AreaRenderer {
    private final Set<BlockPos> showingPositions;
    private final int color;
    private final float size;
    private final boolean disableDepthTest;
    private final boolean drawShapes;
    private final boolean drawFaces;
    private final boolean disableWriteMask;

    private AreaRenderer(Set<BlockPos> area, int color, float size, boolean disableDepthTest, boolean drawShapes, boolean disableWriteMask, boolean drawFaces) {
        this.showingPositions = area;
        this.color = color;
        this.size = size;
        this.disableDepthTest = disableDepthTest;
        this.disableWriteMask = disableWriteMask;
        this.drawShapes = drawShapes;
        this.drawFaces = drawFaces;
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer) {
        RenderType type;
        if (this.drawFaces) {
            type = ModRenderTypes.getBlockHilightFace(this.disableDepthTest, this.disableWriteMask);
            this.render(matrixStack, buffer.getBuffer(type));
            RenderUtils.finishBuffer(buffer, type);
        }
        type = ModRenderTypes.getBlockHilightLine(this.disableDepthTest, this.disableWriteMask);
        this.render(matrixStack, buffer.getBuffer(type));
        RenderUtils.finishBuffer(buffer, type);
    }

    private void render(PoseStack matrixStack, VertexConsumer builder) {
        int[] cols = RenderUtils.decomposeColor(this.color);
        for (BlockPos pos : this.showingPositions) {
            matrixStack.pushPose();
            if (this.drawShapes) {
                matrixStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            } else {
                double start = (double)(1.0f - this.size) / 2.0;
                matrixStack.translate((double)pos.getX() + start, (double)pos.getY() + start, (double)pos.getZ() + start);
            }
            Matrix4f posMat = matrixStack.last().pose();
            this.addVertices(builder, posMat, pos, cols);
            matrixStack.popPose();
        }
    }

    private void addVertices(VertexConsumer wr, Matrix4f posMat, BlockPos pos, int[] cols) {
        boolean xray;
        Level level = ClientUtils.getClientLevel();
        BlockState state = level.getBlockState(pos);
        boolean bl = xray = this.disableDepthTest || this.disableWriteMask;
        if (!xray && !state.canBeReplaced()) {
            return;
        }
        if (this.drawShapes) {
            VoxelShape voxelShape;
            Block block = state.getBlock();
            if (block instanceof AbstractCamouflageBlock) {
                AbstractCamouflageBlock c = (AbstractCamouflageBlock)block;
                voxelShape = c.getUncamouflagedShape(state, (BlockGetter)level, pos, CollisionContext.empty());
            } else {
                voxelShape = state.getShape((BlockGetter)level, pos, CollisionContext.empty());
            }
            VoxelShape shape = voxelShape;
            shape.forAllBoxes((x1d, y1d, z1d, x2d, y2d, z2d) -> {
                float x1 = (float)x1d;
                float x2 = (float)x2d;
                float y1 = (float)y1d;
                float y2 = (float)y2d;
                float z1 = (float)z1d;
                float z2 = (float)z2d;
                wr.addVertex(posMat, x1, y1, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y2, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y2, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y1, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y1, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y2, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y2, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y1, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y1, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y1, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y2, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y2, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y2, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y2, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y1, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y1, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y1, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y1, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y1, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y1, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y2, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y2, z2).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x2, y2, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
                wr.addVertex(posMat, x1, y2, z1).setColor(cols[1], cols[2], cols[3], cols[0]);
            });
        } else {
            wr.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, this.size, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, this.size, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, 0.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, 0.0f, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, this.size, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, this.size, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, 0.0f, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, 0.0f, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, this.size, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, this.size, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, this.size, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, this.size, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, 0.0f, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, 0.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, 0.0f, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, 0.0f, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, 0.0f, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, this.size, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, this.size, this.size).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, this.size, this.size, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
            wr.addVertex(posMat, 0.0f, this.size, 0.0f).setColor(cols[1], cols[2], cols[3], cols[0]);
        }
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private int color = 0x40808080;
        private float size = 0.5f;
        private boolean disableDepthTest = false;
        private boolean drawShapes = false;
        private boolean disableWriteMask = false;
        private boolean drawFaces = true;

        Builder() {
        }

        Builder withColor(int color) {
            this.color = color;
            return this;
        }

        Builder withSize(float size) {
            this.size = size;
            return this;
        }

        Builder disableDepthTest() {
            this.disableDepthTest = true;
            return this;
        }

        Builder disableWriteMask() {
            this.disableWriteMask = true;
            return this;
        }

        Builder xray() {
            this.disableDepthTest = true;
            this.disableWriteMask = true;
            return this;
        }

        Builder drawShapes() {
            this.drawShapes = true;
            return this;
        }

        Builder outlineOnly() {
            this.drawFaces = false;
            return this;
        }

        AreaRenderer build(Set<BlockPos> area) {
            return new AreaRenderer(area, this.color, this.size, this.disableDepthTest, this.drawShapes, this.disableWriteMask, this.drawFaces);
        }

        AreaRenderer build(BlockPos pos) {
            return this.build(Collections.singleton(pos));
        }
    }
}

