/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ModRenderTypes
extends RenderType {
    private static final Function<ResourceLocation, RenderType> TEXTURE_RENDER = Util.memoize(rl -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(rl, false, false);
        RenderType.CompositeState state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)textureState).setLightmapState(RenderStateShard.LIGHTMAP).setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).createCompositeState(false);
        return ModRenderTypes.create((String)"texture", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final BiFunction<ResourceLocation, Boolean, RenderType> TEXTURE_RENDER_COLORED = Util.memoize((rl, disableDepthTest) -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(rl, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setLightmapState(RenderStateShard.LIGHTMAP).setDepthTestState(disableDepthTest != false ? NO_DEPTH_TEST : LEQUAL_DEPTH_TEST).setWriteMaskState(disableDepthTest != false ? COLOR_WRITE : COLOR_DEPTH_WRITE).createCompositeState(false);
        return ModRenderTypes.create((String)"texture_color", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    public static final RenderType UNTEXTURED_QUAD_NO_DEPTH = ModRenderTypes.create((String)"untextured_quad_no_depth", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(RenderStateShard.NO_TEXTURE).setShaderState(RenderStateShard.POSITION_COLOR_LIGHTMAP_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(RenderStateShard.LIGHTMAP).setDepthTestState(NO_DEPTH_TEST).setWriteMaskState(COLOR_WRITE).createCompositeState(false));
    public static final RenderType UNTEXTURED_QUAD = ModRenderTypes.create((String)"untextured_quad", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(RenderStateShard.NO_TEXTURE).setShaderState(RenderStateShard.POSITION_COLOR_LIGHTMAP_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(RenderStateShard.LIGHTMAP).setDepthTestState(LEQUAL_DEPTH_TEST).setWriteMaskState(COLOR_DEPTH_WRITE).createCompositeState(false));
    public static final RenderType BLOCK_FRAME = ModRenderTypes.create((String)"block_frame", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setDepthTestState(NO_DEPTH_TEST).setWriteMaskState(COLOR_WRITE).createCompositeState(false));
    public static final RenderType BLOCK_TRACKER = ModRenderTypes.create((String)"block_tracker", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(RenderStateShard.LineStateShard.DEFAULT_LINE).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTextureState(NO_TEXTURE).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).setDepthTestState(NO_DEPTH_TEST).setWriteMaskState(COLOR_WRITE).createCompositeState(false));
    public static final RenderType TARGET_CIRCLE = ModRenderTypes.create((String)"target_circle", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_LIGHTMAP_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState(NO_TEXTURE).setCullState(NO_CULL).setLightmapState(LIGHTMAP).setDepthTestState(NO_DEPTH_TEST).setWriteMaskState(COLOR_WRITE).createCompositeState(false));
    private static final Function<Double, RenderType> LINE_LOOPS = Util.memoize(lineWidth -> {
        RenderStateShard.LineStateShard lineState = new RenderStateShard.LineStateShard(OptionalDouble.of(lineWidth));
        RenderType.CompositeState state = RenderType.CompositeState.builder().setLineState(lineState).setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setTextureState(RenderStateShard.NO_TEXTURE).setLightmapState(RenderStateShard.NO_LIGHTMAP).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setDepthTestState(NO_DEPTH_TEST).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).createCompositeState(false);
        return ModRenderTypes.create((String)"line_loops", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final BiFunction<Boolean, Boolean, RenderType> BLOCK_HILIGHT_FACE = Util.memoize((disableDepthTest, disableWriteMask) -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState(NO_TEXTURE).setLightmapState(NO_LIGHTMAP).setDepthTestState(disableDepthTest != false ? NO_DEPTH_TEST : LEQUAL_DEPTH_TEST).setWriteMaskState(disableWriteMask != false ? COLOR_WRITE : COLOR_DEPTH_WRITE).setShaderState(RenderStateShard.POSITION_COLOR_SHADER).createCompositeState(false);
        return ModRenderTypes.create((String)"nav_path_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final BiFunction<Boolean, Boolean, RenderType> BLOCK_HILIGHT_LINE = Util.memoize((disableDepthTest, disableWriteMask) -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState(NO_TEXTURE).setDepthTestState(disableDepthTest != false ? NO_DEPTH_TEST : RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).setWriteMaskState(disableWriteMask != false ? COLOR_WRITE : RenderStateShard.COLOR_DEPTH_WRITE).setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).createCompositeState(false);
        return ModRenderTypes.create((String)"block_hilight_line", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    public static final RenderType TRIANGLE_FAN = ModRenderTypes.create((String)"triangle_fan", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_FAN, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).setTextureState(NO_TEXTURE).setShaderState(RenderStateShard.POSITION_COLOR_SHADER).createCompositeState(false));

    public ModRenderTypes(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
        super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
    }

    public static RenderType getTextureRender(ResourceLocation texture) {
        return TEXTURE_RENDER.apply(texture);
    }

    public static RenderType getTextureRenderColored(ResourceLocation texture) {
        return ModRenderTypes.getTextureRenderColored(texture, false);
    }

    public static RenderType getTextureRenderColored(ResourceLocation texture, boolean disableDepthTest) {
        return TEXTURE_RENDER_COLORED.apply(texture, disableDepthTest);
    }

    public static RenderType getLineLoops(double lineWidth) {
        return LINE_LOOPS.apply(lineWidth);
    }

    public static RenderType getBlockHilightFace(boolean disableDepthTest, boolean disableWriteMask) {
        return BLOCK_HILIGHT_FACE.apply(disableDepthTest, disableWriteMask);
    }

    public static RenderType getBlockHilightLine(boolean disableDepthTest, boolean disableWriteMask) {
        return BLOCK_HILIGHT_LINE.apply(disableDepthTest, disableWriteMask);
    }
}

