/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.math.Axis;
import java.util.Optional;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.ChestplateLauncherOptions;
import me.desht.pneumaticcraft.client.render.ProgressBarRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChestplateLauncher;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ChestplateLauncherHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.HumanoidArm;

public class ChestplateLauncherClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler<ChestplateLauncherHandler> {
    public static final int MAX_PROGRESS = 15;
    private int launcherProgress = 0;

    public ChestplateLauncherClientHandler() {
        super(CommonUpgradeHandlers.chestplateLauncherHandler);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new ChestplateLauncherOptions(screen, this);
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    @Override
    public Optional<KeyMapping> getTriggerKeyBinding() {
        return Optional.of(KeyHandler.getInstance().keybindLauncher);
    }

    @Override
    public void onTriggered(ICommonArmorHandler armorHandler) {
        if (!armorHandler.getPlayer().getOffhandItem().isEmpty() && this.launcherProgress == 0 && armorHandler.upgradeUsable((IArmorUpgradeHandler<?>)this.getCommonHandler(), false)) {
            this.launcherProgress = 1;
        }
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        if (this.launcherProgress > 0) {
            if (!KeyHandler.getInstance().keybindLauncher.isDown()) {
                NetworkHandler.sendToServer(new PacketChestplateLauncher((float)this.launcherProgress / 15.0f));
                this.launcherProgress = 0;
            } else {
                this.launcherProgress = Math.min(this.launcherProgress + 1, 15);
            }
        }
    }

    @Override
    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
        if (this.launcherProgress == 0) {
            return;
        }
        Window mw = Minecraft.getInstance().getWindow();
        graphics.pose().pushPose();
        if (ClientUtils.getClientPlayer().getMainArm() == HumanoidArm.LEFT) {
            graphics.pose().translate((float)(mw.getGuiScaledWidth() - 30), (float)(mw.getGuiScaledHeight() - 30), -90.0f);
            graphics.pose().scale(-1.0f, 1.0f, 1.0f);
        } else {
            graphics.pose().translate(30.0f, (float)(mw.getGuiScaledHeight() - 30), -90.0f);
        }
        graphics.pose().mulPose(Axis.ZP.rotationDegrees(-60.0f));
        float progress = Math.min(100.0f, ((float)this.launcherProgress + partialTicks) * 100.0f / 15.0f);
        ProgressBarRenderer.render2d(graphics, 0.0f, 0.0f, (float)mw.getGuiScaledWidth() / 6.0f - 30.0f, 12.0f, 0.0f, progress, -1442840416, -1438605057);
        graphics.pose().popPose();
    }
}

