/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IClientArmorRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IKeybindingButton;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorStatMoveScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.KeybindingButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker.BlockTrackHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public enum ClientArmorRegistry implements IClientArmorRegistry
{
    INSTANCE;

    private List<List<IArmorUpgradeClientHandler<?>>> clientUpgradeHandlers = null;
    private final Map<ResourceLocation, IArmorUpgradeClientHandler<?>> id2HandlerMap = new ConcurrentHashMap();
    private final Map<ResourceLocation, KeyMapping> id2KeyBindMap = new ConcurrentHashMap<ResourceLocation, KeyMapping>();
    private final Map<String, IArmorUpgradeClientHandler<?>> triggerKeyBindMap = new ConcurrentHashMap();
    private boolean frozen;

    public static ClientArmorRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerEntityTrackEntry(Supplier<? extends IEntityTrackEntry> entry) {
        EntityTrackHandler.getInstance().register(entry);
    }

    @Override
    public void registerBlockTrackEntry(ResourceLocation id, Supplier<? extends IBlockTrackEntry> entry) {
        BlockTrackHandler.getInstance().register(id, entry);
    }

    @Override
    public void addHUDMessage(Component title, List<Component> message, int duration, int backColor) {
        HUDHandler.getInstance().addMessage(title, message, duration, backColor);
    }

    @Override
    public <T extends IArmorUpgradeHandler<?>> void registerUpgradeHandler(T handler, IArmorUpgradeClientHandler<T> clientHandler) {
        Validate.notNull(clientHandler, (String)"Render handler can't be null!", (Object[])new Object[0]);
        this.id2HandlerMap.put(handler.getID(), clientHandler);
        clientHandler.getInitialKeyBinding().ifPresent(keyMapping -> this.registerKeyBinding(handler.getID(), (KeyMapping)keyMapping));
        clientHandler.getTriggerKeyBinding().ifPresent(keyMapping -> this.registerTriggerKeybinding(clientHandler, (KeyMapping)keyMapping));
    }

    @Override
    public IKeybindingButton makeKeybindingButton(int yPos, KeyMapping keyBinding) {
        return new KeybindingButton(30, yPos, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.setKey", new Object[0]), keyBinding);
    }

    @Override
    public ICheckboxWidget makeKeybindingCheckBox(ResourceLocation upgradeId, int xPos, int yPos, int color, Consumer<ICheckboxWidget> onPressed) {
        return WidgetKeybindCheckBox.getOrCreate(upgradeId, xPos, yPos, color, onPressed);
    }

    @Override
    public IGuiAnimatedStat makeHUDStatPanel(Component title, ItemStack icon, IArmorUpgradeClientHandler<?> clientHandler) {
        StatPanelLayout layout = ArmorHUDLayout.INSTANCE.getLayoutFor(clientHandler.getID(), clientHandler.getDefaultStatLayout());
        return new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(icon), HUDHandler.getInstance().getStatOverlayColor(), null, layout);
    }

    @Override
    public IGuiAnimatedStat makeHUDStatPanel(Component title, ResourceLocation icon, IArmorUpgradeClientHandler<?> clientHandler) {
        StatPanelLayout layout = ArmorHUDLayout.INSTANCE.getLayoutFor(clientHandler.getID(), clientHandler.getDefaultStatLayout());
        return new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(icon), HUDHandler.getInstance().getStatOverlayColor(), null, layout);
    }

    @Override
    public AbstractWidget makeStatMoveButton(int x, int y, IArmorUpgradeClientHandler<?> handler) {
        return new WidgetButtonExtended(x, y, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.moveStatScreen", new Object[0]), b -> Minecraft.getInstance().setScreen((Screen)new ArmorStatMoveScreen(handler)));
    }

    @Override
    public Optional<IClientArmorRegistry.BlockTrackerFocus> getBlockTrackerFocus() {
        if (!CommonArmorHandler.getHandlerForPlayer().upgradeUsable(CommonUpgradeHandlers.blockTrackerHandler, true)) {
            return Optional.empty();
        }
        BlockTrackerClientHandler handler = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class);
        return Optional.of(new IClientArmorRegistry.BlockTrackerFocus(handler.getFocusedPos(), handler.getFocusedFace()));
    }

    private void registerKeyBinding(ResourceLocation upgradeID, KeyMapping keyBinding) {
        this.id2KeyBindMap.put(upgradeID, keyBinding);
    }

    private void registerTriggerKeybinding(IArmorUpgradeClientHandler<?> clientHandler, KeyMapping keyBinding) {
        this.triggerKeyBindMap.put(keyBinding.getName(), clientHandler);
    }

    public void registerSubKeyBinds() {
        this.id2HandlerMap.values().forEach(clientHandler -> clientHandler.getSubKeybinds().forEach(rl -> this.registerKeyBinding((ResourceLocation)rl, new KeyMapping(IArmorUpgradeHandler.getStringKey(rl), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, -1, clientHandler.getSubKeybindCategory()))));
    }

    public void registerKeybindsWithMinecraft() {
        Object[] keys = this.id2KeyBindMap.values().toArray(new KeyMapping[0]);
        Minecraft.getInstance().options.keyMappings = (KeyMapping[])ArrayUtils.addAll((Object[])Minecraft.getInstance().options.keyMappings, (Object[])keys);
    }

    public KeyMapping getKeybindingForUpgrade(ResourceLocation upgradeID) {
        return this.id2KeyBindMap.get(upgradeID);
    }

    public <C extends IArmorUpgradeClientHandler<U>, U extends IArmorUpgradeHandler<?>> C getClientHandler(U armorUpgradeHandler, Class<C> clientClass) {
        List<IArmorUpgradeClientHandler<?>> clientHandlers = this.getHandlersForSlot(armorUpgradeHandler.getEquipmentSlot());
        return (C)clientHandlers.get(armorUpgradeHandler.getIndex());
    }

    public IArmorUpgradeClientHandler<?> getClientHandler(ResourceLocation id) {
        return this.id2HandlerMap.get(id);
    }

    public Optional<IArmorUpgradeClientHandler<?>> getTriggeredHandler(KeyMapping keyBinding) {
        return keyBinding.getKeyModifier() == KeyModifier.getActiveModifier() ? Optional.ofNullable(this.triggerKeyBindMap.get(keyBinding.getName())) : Optional.empty();
    }

    public List<IArmorUpgradeClientHandler<?>> getHandlersForSlot(EquipmentSlot slot) {
        if (this.clientUpgradeHandlers == null) {
            this.initHandlerLists();
        }
        return this.clientUpgradeHandlers.get(slot.getIndex());
    }

    private void initHandlerLists() {
        if (!ArmorUpgradeRegistry.getInstance().isFrozen()) {
            throw new IllegalStateException("armor upgrade registry is not frozen yet!");
        }
        if (this.clientUpgradeHandlers != null) {
            throw new IllegalStateException("handler lists already inited!?");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EquipmentSlot ignored : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            builder.add(new ArrayList());
        }
        this.clientUpgradeHandlers = builder.build();
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (IArmorUpgradeHandler<?> handler : ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot)) {
                IArmorUpgradeClientHandler<?> clientHandler = this.id2HandlerMap.get(handler.getID());
                Validate.notNull(clientHandler, (String)("Null client-handler for upgrade handler '" + String.valueOf(handler.getID()) + "'! Did you forget to register it?"), (Object[])new Object[0]);
                this.clientUpgradeHandlers.get(slot.getIndex()).add(clientHandler);
            }
        }
        this.refreshConfig();
    }

    public void refreshConfig() {
        if (this.clientUpgradeHandlers == null) {
            return;
        }
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (IArmorUpgradeClientHandler<?> renderHandler : this.getHandlersForSlot(slot)) {
                renderHandler.initConfig();
            }
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }
}

