/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.processing.ThermoPlantBlockEntity;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ThermoPlantMenu;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class ThermoPlantScreen
extends AbstractPneumaticCraftContainerScreen<ThermoPlantMenu, ThermoPlantBlockEntity> {
    private WidgetTemperature tempWidget;
    private WidgetButtonExtended dumpButton;
    private int nExposedFaces;

    public ThermoPlantScreen(ThermoPlantMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 212;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_THERMOPNEUMATIC_PROCESSING_PLANT;
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 13, this.topPos + 19, ((ThermoPlantBlockEntity)this.te).getInputTank()));
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 79, this.topPos + 19, ((ThermoPlantBlockEntity)this.te).getOutputTank()));
        this.tempWidget = new WidgetTemperature(this.leftPos + 105, this.topPos + 25, TemperatureRange.of(273, 673), 273, 50);
        this.addRenderableWidget((GuiEventListener)this.tempWidget);
        this.dumpButton = new WidgetButtonExtended(this.leftPos + 14, this.topPos + 86, 14, 14, (Component)Component.empty()).withTag("dump").withCustomTooltip(this::makeDumpButtonTooltip);
        this.addRenderableWidget((GuiEventListener)this.dumpButton);
        this.nExposedFaces = HeatUtil.countExposedFaces(Collections.singletonList((ThermoPlantBlockEntity)this.te));
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (((ThermoPlantBlockEntity)this.te).maxTemperature > ((ThermoPlantBlockEntity)this.te).minTemperature && !((ThermoPlantBlockEntity)this.te).getCurrentRecipeIdSynced().isEmpty()) {
            this.tempWidget.setOperatingRange(TemperatureRange.of(((ThermoPlantBlockEntity)this.te).minTemperature, ((ThermoPlantBlockEntity)this.te).maxTemperature));
        } else {
            this.tempWidget.setOperatingRange(null);
        }
        this.tempWidget.setTemperature(((ThermoPlantBlockEntity)this.te).getHeatExchanger().getTemperatureAsInt());
        this.tempWidget.autoScaleForTemperature();
        this.dumpButton.setMessage((Component)(ThermoPlantScreen.hasShiftDown() ? Component.literal((String)"X").withStyle(ChatFormatting.RED) : Component.literal((String)"\u25b6").withStyle(ChatFormatting.DARK_AQUA)));
    }

    private List<Component> makeDumpButtonTooltip() {
        return ThermoPlantScreen.hasShiftDown() ? List.of(PneumaticCraftUtils.xlate("pneumaticcraft.gui.thermopneumatic.dumpInput", new Object[0])) : List.of(PneumaticCraftUtils.xlate("pneumaticcraft.gui.thermopneumatic.moveInput", new Object[0]));
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        double progress = ((ThermoPlantBlockEntity)this.te).getCraftingPercentage();
        int progressWidth = (int)(progress * 48.0);
        graphics.blit(this.getGuiTexture(), this.leftPos + 30, this.topPos + 36, this.imageWidth, 0, progressWidth, 30);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        graphics.pose().pushPose();
        graphics.pose().scale(0.95f, 1.0f, 1.0f);
        graphics.drawString(this.font, this.title.getVisualOrderText(), (float)this.imageWidth / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.1f, 5.0f, 0x404040, false);
        graphics.pose().popPose();
        super.renderLabels(graphics, x, y);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        return new PointXY(xStart + this.imageWidth * 3 / 4 + 14, yStart + this.imageHeight / 4 - 2);
    }

    @Override
    public void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((ThermoPlantBlockEntity)this.te).problem != null && ((ThermoPlantBlockEntity)this.te).problem != ThermoPlantBlockEntity.TPProblem.OK) {
            curInfo.addAll(GuiUtils.xlateAndSplit(((ThermoPlantBlockEntity)this.te).problem.getTranslationKey(), new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        if (this.nExposedFaces > 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.exposedFaces", this.nExposedFaces, 6));
        }
    }

    @Override
    public Collection<ItemStack> getTargetItems() {
        return this.getCurrentRecipe(ModRecipeTypes.THERMO_PLANT.get()).map(thermoPlantRecipe -> Collections.singletonList(((ThermoPlantRecipe)thermoPlantRecipe.value()).getOutputItem())).orElse(Collections.emptyList());
    }

    @Override
    public Collection<FluidStack> getTargetFluids() {
        return this.getCurrentRecipe(ModRecipeTypes.THERMO_PLANT.get()).map(thermoPlantRecipe -> Collections.singletonList(((ThermoPlantRecipe)thermoPlantRecipe.value()).getOutputFluid())).orElse(Collections.emptyList());
    }
}

