/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.HackSimulationRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.inventory.SecurityStationHackingMenu;
import me.desht.pneumaticcraft.common.item.NetworkComponentItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SecurityStationHackingScreen
extends AbstractPneumaticCraftContainerScreen<SecurityStationHackingMenu, SecurityStationBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private HackSimulationRenderer hackRenderer;
    private HackSimulation bgSimulation;
    private int stopWorms = 0;
    private int nukeViruses = 0;
    private final ItemStack stopWorm = new ItemStack((ItemLike)ModItems.STOP_WORM.get());
    private final ItemStack nukeVirus = new ItemStack((ItemLike)ModItems.NUKE_VIRUS.get());
    private WidgetButtonExtended nukeVirusButton;
    private WidgetButtonExtended stopWormButton;

    public SecurityStationHackingScreen(SecurityStationHackingMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 238;
    }

    @Override
    public void init() {
        super.init();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.SECURITY_STATION.get()), -22016, false);
        this.addInfoTab(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.security_station.hacking", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate(((Item)ModItems.NUKE_VIRUS.get()).getDescriptionId(), new Object[0]), new ItemStack((ItemLike)ModItems.NUKE_VIRUS.get()), -15152664, false).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.security_station.nukeVirus", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate(((Item)ModItems.STOP_WORM.get()).getDescriptionId(), new Object[0]), new ItemStack((ItemLike)ModItems.STOP_WORM.get()), -4115918, false).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.security_station.stopWorm", new Object[0]));
        this.nukeVirusButton = new WidgetButtonExtended(this.leftPos + 152, this.topPos + 95, 18, 18, "").setRenderStacks(this.nukeVirus);
        this.addRenderableWidget((GuiEventListener)this.nukeVirusButton);
        this.stopWormButton = new WidgetButtonExtended(this.leftPos + 152, this.topPos + 143, 18, 18, "", b -> {
            if (!((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI).isStopWormed()) {
                PneumaticCraftUtils.consumeInventoryItem(ClientUtils.getClientPlayer().getInventory(), (Item)ModItems.STOP_WORM.get());
                ClientUtils.getClientPlayer().playSound(SoundEvents.SLIME_BLOCK_BREAK, 1.0f, 1.0f);
            }
        });
        ((WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)this.stopWormButton)).withTag("stop_worm").setRenderStacks(this.stopWorm);
        this.initConnectionRendering();
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    private void initConnectionRendering() {
        this.hackRenderer = new HackSimulationRenderer(this.leftPos + 16, this.topPos + 30, 31);
        this.bgSimulation = HackSimulation.dummySimulation();
        this.bgSimulation.wakeUp();
        for (int i = 0; i < ((SecurityStationBlockEntity)this.te).getItemHandler().getSlots(); ++i) {
            this.bgSimulation.addNode(i, ((SecurityStationBlockEntity)this.te).getItemHandler().getStackInSlot(i));
        }
    }

    public static void addExtraHackInfoStatic(List<Component> curInfo) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof SecurityStationHackingScreen) {
            SecurityStationHackingScreen shs = (SecurityStationHackingScreen)screen;
            shs.addExtraHackInfo(curInfo);
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_HACKING;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        if (((SecurityStationBlockEntity)this.te).getSimulationController() != null) {
            HackSimulation aiSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
            HackSimulation playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
            if (aiSim.isAwake()) {
                graphics.drawCenteredString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.aiTracing", new Object[0]).withStyle(ChatFormatting.RED), this.imageWidth / 2, 7, 0xFFFFFF);
            } else {
                graphics.drawCenteredString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.detectionChance", ((SecurityStationBlockEntity)this.te).getDetectionChance()).withStyle(ChatFormatting.GOLD), this.imageWidth / 2, 7, 0xFFFFFF);
            }
            if (aiSim.isHackComplete()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.1", new Object[0]).withStyle(ChatFormatting.RED));
                if (!((SecurityStationBlockEntity)this.te).getSimulationController().isJustTesting()) {
                    builder.add((Object)Component.empty());
                    builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.2", new Object[0]).withStyle(ChatFormatting.RED));
                }
                GuiUtils.showPopupHelpScreen(graphics, (Screen)this, this.font, (List<Component>)builder.build());
            } else if (playerSim.isHackComplete()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.1", new Object[0]).withStyle(ChatFormatting.GREEN));
                if (!((SecurityStationBlockEntity)this.te).getSimulationController().isJustTesting()) {
                    builder.add((Object)Component.empty());
                    builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.2", new Object[0]).withStyle(ChatFormatting.GREEN));
                }
                GuiUtils.showPopupHelpScreen(graphics, (Screen)this, this.font, (List<Component>)builder.build());
            }
        }
        this.renderConsumables(graphics);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        this.hackRenderer.render(graphics, this.bgSimulation, -14540033);
        if (((SecurityStationBlockEntity)this.te).getSimulationController() != null) {
            HackSimulation aiSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
            if (!aiSim.isStopWormed() || (((SecurityStationBlockEntity)this.te).getLevel().getGameTime() & 0xFL) < 8L) {
                this.hackRenderer.render(graphics, ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI), -65536);
            }
            this.hackRenderer.render(graphics, ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER), -16711936);
        }
    }

    private void renderConsumables(GuiGraphics graphics) {
        graphics.drawString(this.font, PneumaticCraftUtils.convertAmountToString(this.nukeViruses), 158, 112, this.nukeViruses == 0 ? -40864 : -1, false);
        graphics.drawString(this.font, PneumaticCraftUtils.convertAmountToString(this.stopWorms), 158, 160, this.stopWorms == 0 ? -40864 : -1, false);
    }

    @Override
    public void containerTick() {
        HackSimulation aiSim;
        super.containerTick();
        this.stopWorms = 0;
        this.nukeViruses = 0;
        for (ItemStack stack : ClientUtils.getClientPlayer().getInventory().items) {
            if (stack.getItem() == ModItems.STOP_WORM.get()) {
                this.stopWorms += stack.getCount();
            }
            if (stack.getItem() != ModItems.NUKE_VIRUS.get()) continue;
            this.nukeViruses += stack.getCount();
        }
        this.bgSimulation.tick();
        this.statusStat.setText(this.getStatusText());
        HackSimulation playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController() == null ? null : ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation hackSimulation = aiSim = ((SecurityStationBlockEntity)this.te).getSimulationController() == null ? null : ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
        if (aiSim != null && aiSim.isAwake()) {
            this.stopWormButton.active = this.stopWorms > 0;
            this.stopWormButton.setTooltipText((Component)(this.stopWorms > 0 ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm.none", new Object[0]).withStyle(ChatFormatting.GOLD)));
        } else {
            this.stopWormButton.active = false;
            this.stopWormButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm.notTracing", new Object[0]).withStyle(ChatFormatting.GOLD));
        }
        if (playerSim != null) {
            boolean bl = this.nukeVirusButton.active = this.hasNukeViruses() && playerSim.isNukeVirusReady();
            if (playerSim.isNukeVirusReady()) {
                this.nukeVirusButton.setTooltipText((Component)(this.hasNukeViruses() ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus.none", new Object[0]).withStyle(ChatFormatting.GOLD)));
            } else {
                this.nukeVirusButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus.coolDown", new Object[0]).withStyle(ChatFormatting.GOLD));
            }
        }
    }

    private List<Component> getStatusText() {
        ArrayList<Component> text = new ArrayList<Component>();
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityLevel", new Object[0]).withStyle(ChatFormatting.WHITE));
        text.add((Component)Component.literal((String)("L" + ((SecurityStationBlockEntity)this.te).getSecurityLevel())).withStyle(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityRange", new Object[0]).withStyle(ChatFormatting.WHITE));
        text.add((Component)Component.literal((String)(((SecurityStationBlockEntity)this.te).getRange() * 2 + 1 + "m\u00b2")).withStyle(ChatFormatting.BLACK));
        return text;
    }

    protected void slotClicked(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null && slotIn.hasItem() && ((SecurityStationBlockEntity)this.te).getSimulationController() != null) {
            switch (mouseButton) {
                case 0: {
                    this.tryHackSlot(slotId);
                    break;
                }
                case 1: {
                    this.tryFortifySlot(slotId);
                    break;
                }
                case 2: {
                    this.tryNukeVirus(slotId);
                }
            }
        } else {
            super.slotClicked(slotIn, slotId, mouseButton, type);
        }
    }

    private void tryFortifySlot(int slotId) {
        HackSimulation playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation.Node node = playerSim.getNodeAt(slotId);
        if (node.isHacked() && !node.isFortified() && node.getFortification() == 0) {
            playerSim.fortify(slotId);
            NetworkHandler.sendToServer(new PacketGuiButton("fortify:" + slotId));
        }
    }

    private void tryHackSlot(int slotId) {
        HackSimulation playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation.Node node = playerSim.getNodeAt(slotId);
        if (!node.isHacked() && playerSim.getHackedNeighbour(slotId) >= 0) {
            playerSim.startHack(slotId);
            NetworkHandler.sendToServer(new PacketGuiButton("hack:" + slotId));
        }
    }

    private void tryNukeVirus(int slotId) {
        HackSimulation playerSim;
        HackSimulation.Node node;
        if (this.hasNukeViruses() && ((SecurityStationBlockEntity)this.te).getSimulationController() != null && !(node = (playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER)).getNodeAt(slotId)).isHacked() && playerSim.getHackedNeighbour(slotId) >= 0 && playerSim.initiateNukeVirus(slotId)) {
            NetworkHandler.sendToServer(new PacketGuiButton("nuke:" + slotId));
            PneumaticCraftUtils.consumeInventoryItem(ClientUtils.getClientPlayer().getInventory(), (Item)ModItems.NUKE_VIRUS.get());
        }
    }

    public void addExtraHackInfo(List<Component> toolTip) {
        HackSimulation playerSim;
        HackSimulation.Node node;
        if (this.hoveredSlot != null && ((SecurityStationBlockEntity)this.te).getSimulationController() != null && (node = (playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER)).getNodeAt(this.hoveredSlot.index)) != null) {
            if (node.isHacked()) {
                if (node.getFortification() == 0) {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.rightClickFortify", new Object[0]).withStyle(ChatFormatting.DARK_AQUA));
                } else if (node.getFortificationProgress() < 1.0f) {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.fortifyProgress", (int)(node.getFortificationProgress() * 100.0f)).withStyle(ChatFormatting.DARK_AQUA));
                } else {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.fortified", new Object[0]).withStyle(ChatFormatting.AQUA));
                }
            } else if (playerSim.getHackedNeighbour(this.hoveredSlot.index) >= 0) {
                if (node.getHackProgress() == 0.0f) {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.leftClickHack", new Object[0]).withStyle(ChatFormatting.GREEN));
                } else {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.hackProgress", (int)(node.getHackProgress() * 100.0f)).withStyle(ChatFormatting.GREEN));
                }
                if (this.nukeViruses > 0 && playerSim.isNukeVirusReady() && node.getType() == NetworkComponentItem.NetworkComponentType.NETWORK_NODE) {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.middleClickNuke", new Object[0]).withStyle(ChatFormatting.YELLOW));
                }
            }
        }
    }

    boolean hasNukeViruses() {
        return this.nukeViruses > 0;
    }
}

