/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.compressor.ElectrostaticCompressorBlockEntity;
import me.desht.pneumaticcraft.common.inventory.ElectrostaticCompressorMenu;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ElectrostaticCompressorScreen
extends AbstractPneumaticCraftContainerScreen<ElectrostaticCompressorMenu, ElectrostaticCompressorBlockEntity> {
    private int connectedCompressors;
    private WidgetAnimatedStat electrostaticStat;

    public ElectrostaticCompressorScreen(ElectrostaticCompressorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.electrostaticStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostaticCompressor.title", new Object[0]), new ItemStack((ItemLike)ModBlocks.ELECTROSTATIC_COMPRESSOR.get()), -14638849, false);
        this.electrostaticStat.setForegroundColor(-16777216);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    protected void addWarnings(List<Component> textList) {
        int generated;
        super.addWarnings(textList);
        int grounding = 10000 * ((ElectrostaticCompressorBlockEntity)this.te).ironBarsBeneath;
        if (this.connectedCompressors > 0 && grounding < (generated = 200000 / this.connectedCompressors)) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.electrostatic.notEnoughGrounding", grounding, generated));
        }
    }

    @Override
    public void containerTick() {
        if (this.firstUpdate || ClientUtils.getClientLevel().getGameTime() % 20L == 0L) {
            ObjectOpenHashSet positions = new ObjectOpenHashSet(500);
            positions.add(((ElectrostaticCompressorBlockEntity)this.te).getBlockPos());
            ObjectOpenHashSet compressors = new ObjectOpenHashSet(20);
            ((ElectrostaticCompressorBlockEntity)this.te).getElectrostaticGrid((Set<BlockPos>)positions, (Set<ElectrostaticCompressorBlockEntity>)compressors, ((ElectrostaticCompressorBlockEntity)this.te).getBlockPos());
            this.connectedCompressors = compressors.size();
        }
        super.containerTick();
        ArrayList<Component> info = new ArrayList<Component>();
        if (this.connectedCompressors > 0) {
            info.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.generating", PneumaticCraftUtils.roundNumberTo(200000.0f / (float)this.connectedCompressors, 1)));
        }
        info.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.connected", this.connectedCompressors));
        info.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.maxRedirection", PneumaticCraftUtils.roundNumberTo(10000 * ((ElectrostaticCompressorBlockEntity)this.te).ironBarsBeneath, 1)));
        info.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.lightningRod", ((ElectrostaticCompressorBlockEntity)this.te).ironBarsAbove));
        info.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.electrostatic.strikeTime", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((ElectrostaticCompressorBlockEntity)this.te).getStrikeChance(), false)));
        this.electrostaticStat.setText(info);
    }
}

