/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.recipe;

import com.mojang.serialization.Codec;
import java.util.Locale;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public abstract class AssemblyRecipe
extends PneumaticCraftRecipe {
    public abstract SizedIngredient getInput();

    public final int getInputAmount() {
        return this.getInput().count();
    }

    @Nonnull
    public abstract ItemStack getOutput();

    public abstract AssemblyProgramType getProgramType();

    public abstract boolean matches(ItemStack var1);

    public static enum AssemblyProgramType implements StringRepresentable
    {
        DRILL("drill"),
        LASER("laser"),
        DRILL_LASER("drill_laser");

        public static final Codec<AssemblyProgramType> CODEC;
        private final String name;

        private AssemblyProgramType(String name) {
            this.name = name;
        }

        public String getRegistryName() {
            return "assembly_program_" + this.toString().toLowerCase(Locale.ROOT);
        }

        public ResourceLocation getRecipeType() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> PneumaticRegistry.RL("assembly_drill");
                case 1 -> PneumaticRegistry.RL("assembly_laser");
                case 2 -> PneumaticRegistry.RL("assembly_drill_laser");
            };
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(AssemblyProgramType::values);
        }
    }
}

