/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TagUtils {
    public static CompoundTag mergeTags(CompoundTag tag1, CompoundTag tag2) {
        CompoundTag output = new CompoundTag();
        ArrayList<String> allKeys = new ArrayList<String>();
        tag1.getAllKeys().forEach(s -> allKeys.add((String)s));
        for (String key : tag2.getAllKeys()) {
            if (allKeys.contains(key) || key == null) continue;
            allKeys.add(key);
        }
        for (String key : allKeys) {
            if (tag1.contains(key) && tag2.contains(key)) {
                Tag tag = tag1.get(key);
                if (tag instanceof NumericTag) {
                    NumericTag numTag = (NumericTag)tag;
                    if (numTag instanceof DoubleTag) {
                        output.putDouble(key, tag1.getDouble(key) + tag2.getDouble(key));
                        continue;
                    }
                    if (numTag instanceof FloatTag) {
                        output.putFloat(key, tag1.getFloat(key) + tag2.getFloat(key));
                        continue;
                    }
                    if (numTag instanceof IntTag) {
                        output.putInt(key, tag1.getInt(key) + tag2.getInt(key));
                        continue;
                    }
                    if (numTag instanceof LongTag) {
                        output.putLong(key, tag1.getLong(key) + tag2.getLong(key));
                        continue;
                    }
                    if (numTag instanceof ShortTag) {
                        output.putShort(key, (short)(tag1.getShort(key) + tag2.getShort(key)));
                        continue;
                    }
                    output.put(key, tag1.get(key));
                    continue;
                }
                output.put(key, tag1.get(key));
                continue;
            }
            if (tag1.contains(key) && !tag2.contains(key)) {
                output.put(key, tag1.get(key));
                continue;
            }
            if (tag1.contains(key) || !tag2.contains(key)) continue;
            output.put(key, tag2.get(key));
        }
        return output;
    }

    public static CompoundTag stackTag(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return new CompoundTag();
        }
        if (stack.getCount() > 99) {
            ItemStack clone = stack.copy();
            clone.setCount(99);
            return (CompoundTag)clone.save((HolderLookup.Provider)level.registryAccess());
        }
        return (CompoundTag)stack.save((HolderLookup.Provider)level.registryAccess());
    }

    public static CompoundTag entityTag(Entity entity) {
        CompoundTag data = new CompoundTag();
        return entity == null ? data : entity.saveWithoutId(data);
    }

    public static CompoundTag tileTag(BlockEntity tile) {
        return tile == null ? new CompoundTag() : tile.saveWithFullMetadata((HolderLookup.Provider)tile.getLevel().registryAccess());
    }

    public static CompoundTag stateTag(BlockState state) {
        CompoundTag dataOut = new CompoundTag();
        state.getProperties().forEach(prop -> dataOut.putString(prop.getName(), state.getValue(prop).toString()));
        return dataOut;
    }

    public static float getFloat(CompoundTag nbt, String key, float ifAbsent) {
        return nbt.contains(key) ? nbt.getFloat(key) : ifAbsent;
    }

    public static BlockPos getBlockPos(CompoundTag nbt, String key, BlockPos ifAbsent) {
        return nbt.contains(key) ? BlockPos.of((long)nbt.getLong(key)) : ifAbsent;
    }
}

